/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.cpp;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.cpp.CppBlockRenderer;
import oracle.javatools.editor.language.cpp.CppLanguageSupport;
import oracle.javatools.editor.language.cpp.CppStyles;
import oracle.javatools.editor.resource.BundleHelper;

public final class CppLanguageModule
extends LanguageModule {
    private static final String[] supportedFileTypes = new String[]{"c", "cpp", "c++", "cplusplus", "h"};

    public String getPresentationName() {
        BundleHelper bundleHelper = EditorProperties.getEditorBundle();
        return bundleHelper.getString("CPP_MODULE_NAME");
    }

    public String[] getStyleNames() {
        return CppStyles.STYLE_NAMES;
    }

    public String getContentSample() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("// Employee: source\n");
        stringBuffer.append("\n");
        stringBuffer.append("#include <stdio.h>\n");
        stringBuffer.append("#include \"employee.h\"\n");
        stringBuffer.append("\n");
        stringBuffer.append("// Employee\n");
        stringBuffer.append("Employee::Employee( Name *name, int salary )\n");
        stringBuffer.append("{\n");
        stringBuffer.append("  empName = name;\n");
        stringBuffer.append("  empID = nextEmployeeID();\n");
        stringBuffer.append("  empSalary = salary;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("\n");
        stringBuffer.append("Employee::~Employee()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("  empName = NULL;\n");
        stringBuffer.append("  empID = -1;\n");
        stringBuffer.append("  empSalary = -1;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("\n");
        stringBuffer.append("// Employee operations\n");
        stringBuffer.append("void Employee::giveRaise( int raise )\n");
        stringBuffer.append("{\n");
        stringBuffer.append("  empSalary += raise;\n");
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public String[] getSupportedFileTypes() {
        return supportedFileTypes;
    }

    public void registerStyles(StyleRegistry styleRegistry) {
        new CppStyles(styleRegistry);
    }

    public LanguageSupport createLanguageSupport() {
        return new CppLanguageSupport();
    }

    public BlockRenderer createBlockRenderer(TextBuffer textBuffer) {
        return new CppBlockRenderer(textBuffer);
    }
}

