/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.css;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.LexerBlockRenderer;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.editor.language.css.CSSFontFaceRuleRenderer;
import oracle.javatools.editor.language.css.CSSImportRuleRenderer;
import oracle.javatools.editor.language.css.CSSMediaRuleRenderer;
import oracle.javatools.editor.language.css.CSSNamespaceRuleRenderer;
import oracle.javatools.editor.language.css.CSSPageRuleRenderer;
import oracle.javatools.editor.language.css.CSSRuleSetRenderer;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.css.CSSLexer;
import oracle.javatools.parser.css.CSSTokens;

public class CSSBlockRenderer
extends LexerBlockRenderer
implements CSSTokens {
    protected CSSNamespaceRuleRenderer _mNamespaceRuleRenderer;
    protected CSSImportRuleRenderer _mImportRuleRenderer;
    protected CSSMediaRuleRenderer _mMediaRuleRenderer;
    protected CSSPageRuleRenderer _mPageRuleRenderer;
    protected CSSFontFaceRuleRenderer _mFontFaceRenderer;
    protected CSSRuleSetRenderer _mRuleSetRenderer;

    public CSSBlockRenderer(TextBuffer textBuffer) {
        super(textBuffer);
    }

    protected Lexer createLexer() {
        return new CSSLexer();
    }

    protected void renderToken(StyledFragmentsList styledFragmentsList, int n, int n2, int n3, int n4, int n5) {
        int n6 = Math.max(n2, n4);
        int n7 = Math.min(n3, n5);
        switch (n) {
            case 55: {
                this.renderCSSNamespaceRule(styledFragmentsList, n, n2, n3, n6, n7);
                break;
            }
            case 28: {
                this.renderCSSImportRule(styledFragmentsList, n, n2, n3, n6, n7);
                break;
            }
            case 33: {
                this.renderCSSPageRule(styledFragmentsList, n, n2, n3, n6, n7);
                break;
            }
            case 32: {
                this.renderCSSMediaRule(styledFragmentsList, n, n2, n3, n6, n7);
                break;
            }
            case 31: {
                this.renderCSSFontFaceRule(styledFragmentsList, n, n2, n3, n6, n7);
                break;
            }
            case 100: {
                this.renderCSSRuleSet(styledFragmentsList, n, n2, n3, n6, n7);
                break;
            }
            default: {
                super.renderToken(styledFragmentsList, n, n2, n3, n4, n5);
            }
        }
    }

    protected String mapTokenToStyleName(int n) {
        switch (n) {
            case 18: {
                return "css-comment-style";
            }
            case 29: 
            case 30: {
                return "css-at-rule-style";
            }
            case -1: {
                return "css-error-style";
            }
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 55: 
            case 100: {
                throw new IllegalStateException("Should be sub-rendering style rules");
            }
        }
        return this.getDefaultStyleName();
    }

    protected void renderCSSRuleSet(StyledFragmentsList styledFragmentsList, int n, int n2, int n3, int n4, int n5) {
        if (this._mRuleSetRenderer == null) {
            this._mRuleSetRenderer = new CSSRuleSetRenderer(this.getTextBuffer());
        }
        this._mRuleSetRenderer.renderBlock(styledFragmentsList, n2, n3, n4, n5);
    }

    protected void renderCSSNamespaceRule(StyledFragmentsList styledFragmentsList, int n, int n2, int n3, int n4, int n5) {
        if (this._mNamespaceRuleRenderer == null) {
            this._mNamespaceRuleRenderer = new CSSNamespaceRuleRenderer(this.getTextBuffer());
        }
        this._mNamespaceRuleRenderer.renderBlock(styledFragmentsList, n2, n3, n4, n5);
    }

    protected void renderCSSImportRule(StyledFragmentsList styledFragmentsList, int n, int n2, int n3, int n4, int n5) {
        if (this._mImportRuleRenderer == null) {
            this._mImportRuleRenderer = new CSSImportRuleRenderer(this.getTextBuffer());
        }
        this._mImportRuleRenderer.renderBlock(styledFragmentsList, n2, n3, n4, n5);
    }

    protected void renderCSSMediaRule(StyledFragmentsList styledFragmentsList, int n, int n2, int n3, int n4, int n5) {
        if (this._mMediaRuleRenderer == null) {
            this._mMediaRuleRenderer = new CSSMediaRuleRenderer(this.getTextBuffer());
        }
        this._mMediaRuleRenderer.renderBlock(styledFragmentsList, n2, n3, n4, n5);
    }

    protected void renderCSSFontFaceRule(StyledFragmentsList styledFragmentsList, int n, int n2, int n3, int n4, int n5) {
        if (this._mFontFaceRenderer == null) {
            this._mFontFaceRenderer = new CSSFontFaceRuleRenderer(this.getTextBuffer());
        }
        this._mFontFaceRenderer.renderBlock(styledFragmentsList, n2, n3, n4, n5);
    }

    protected void renderCSSPageRule(StyledFragmentsList styledFragmentsList, int n, int n2, int n3, int n4, int n5) {
        if (this._mPageRuleRenderer == null) {
            this._mPageRuleRenderer = new CSSPageRuleRenderer(this.getTextBuffer());
        }
        this._mPageRuleRenderer.renderBlock(styledFragmentsList, n2, n3, n4, n5);
    }
}

