/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.css;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.css.CSSBlockRenderer;
import oracle.javatools.editor.language.css.CSSLanguageSupport;
import oracle.javatools.editor.language.css.CSSStyles;
import oracle.javatools.editor.resource.BundleHelper;

public class CSSLanguageModule
extends LanguageModule {
    public String getContentSample() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("@charset \"ISO-8859-1\";\n");
        stringBuffer.append("@import \"ext/extension.css\" print, screen;\n");
        stringBuffer.append("@namespace xyx \"www.xyz.com\";\n");
        stringBuffer.append("@media print {\n");
        stringBuffer.append("  /* style sheet for print goes here */\n");
        stringBuffer.append("  xyz|abcElement {\n");
        stringBuffer.append("    unknown_property: inherit;\n");
        stringBuffer.append("  }\n");
        stringBuffer.append("}\n");
        stringBuffer.append("@page rotated :left {\n");
        stringBuffer.append("  size: 8.5in 11in;\n");
        stringBuffer.append("  margin: 2cm;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("@font-face {\n");
        stringBuffer.append("  font-family: \"Swiss 721\";\n");
        stringBuffer.append("  src: url(swiss721.pfr); /* The condensed Swiss 721 */\n");
        stringBuffer.append("  font-stretch: condensed;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("/* style rules beginhere */\n");
        stringBuffer.append("A:link {\n");
        stringBuffer.append("  font-family: \"Swiss 721\";\n");
        stringBuffer.append("  color: purple !important;\n");
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public String[] getStyleNames() {
        return CSSStyles.getStyleNames();
    }

    public void registerStyles(StyleRegistry styleRegistry) {
        new CSSStyles(styleRegistry);
    }

    public LanguageSupport createLanguageSupport() {
        return new CSSLanguageSupport();
    }

    public BlockRenderer createBlockRenderer(TextBuffer textBuffer) {
        return new CSSBlockRenderer(textBuffer);
    }

    public String[] getSupportedFileTypes() {
        String[] stringArray = new String[]{"css"};
        return stringArray;
    }

    public String getPresentationName() {
        BundleHelper bundleHelper = EditorProperties.getEditorBundle();
        return bundleHelper.getString("CSS_MODULE_NAME");
    }
}

