/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.diff;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.diff.DiffBlockRenderer;
import oracle.javatools.editor.language.diff.DiffLanguageSupport;
import oracle.javatools.editor.language.diff.DiffStyles;
import oracle.javatools.editor.resource.BundleHelper;

public final class DiffLanguageModule
extends LanguageModule {
    private static final String[] supportedFileTypes = new String[]{"diff", "patch"};

    public String getPresentationName() {
        BundleHelper bundleHelper = EditorProperties.getEditorBundle();
        return bundleHelper.getString("DIFF_MODULE_NAME");
    }

    public String[] getStyleNames() {
        return DiffStyles.STYLE_NAMES;
    }

    public String getContentSample() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("--- lao Sat Jan 26 23:30:39 1991\n");
        stringBuffer.append("+++ tzu Sat Jan 26 23:30:50 1991\n");
        stringBuffer.append("@@ -1,7 +1,6 @@\n");
        stringBuffer.append("-The Way that can be told of is not the eternal Way;\n");
        stringBuffer.append("-The name that can be named is not the eternal name.\n");
        stringBuffer.append(" The Nameless is the origin of Heaven and Earth;\n");
        stringBuffer.append("-The Named is the mother of all things.\n");
        stringBuffer.append("+The named is the mother of all things.\n");
        stringBuffer.append("+\n");
        stringBuffer.append(" Therefore let there always be non-being,\n");
        stringBuffer.append("   so we may see their subtlety,\n");
        stringBuffer.append(" And let there always be being,\n");
        stringBuffer.append("@@ -9,3 +8,6 @@\n");
        stringBuffer.append(" The two are the same,\n");
        stringBuffer.append(" But after they are produced,\n");
        stringBuffer.append("   they have different names.\n");
        stringBuffer.append("+They both may be called deep and profound.\n");
        stringBuffer.append("+Deeper and more profound,\n");
        stringBuffer.append("+The door of all subtleties!\n");
        return stringBuffer.toString();
    }

    public String[] getSupportedFileTypes() {
        return supportedFileTypes;
    }

    public void registerStyles(StyleRegistry styleRegistry) {
        DiffStyles diffStyles = new DiffStyles(styleRegistry);
    }

    public LanguageSupport createLanguageSupport() {
        return new DiffLanguageSupport();
    }

    public BlockRenderer createBlockRenderer(TextBuffer textBuffer) {
        return new DiffBlockRenderer(textBuffer);
    }
}

