/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.html;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LexerBlockRenderer;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.editor.language.html.TagBlockRenderer;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.html.HTMLLexer;
import oracle.javatools.parser.html.HTMLTokens;

public class HTMLBlockRenderer
extends LexerBlockRenderer
implements HTMLTokens {
    protected TagBlockRenderer tagRenderer;
    protected BlockRenderer jsRenderer;
    protected BlockRenderer styleRenderer;
    protected HTMLLexer scratchLexer;
    protected LexerToken scratchToken;

    public HTMLBlockRenderer(TextBuffer textBuffer) {
        super(textBuffer);
        this.tagRenderer = this.createTagRenderer(textBuffer);
        this.jsRenderer = this.createJSRenderer(textBuffer);
        this.styleRenderer = this.createCSSRenderer(textBuffer);
    }

    protected TagBlockRenderer createTagRenderer(TextBuffer textBuffer) {
        return new TagBlockRenderer(textBuffer);
    }

    protected BlockRenderer createCSSRenderer(TextBuffer textBuffer) {
        return LanguageModule.createBlockRendererForFileType("css", textBuffer);
    }

    protected BlockRenderer createJSRenderer(TextBuffer textBuffer) {
        return LanguageModule.createBlockRendererForFileType("js", textBuffer);
    }

    protected Lexer createLexer() {
        HTMLLexer hTMLLexer = new HTMLLexer();
        hTMLLexer.setRecognizeEmbeddedTags(true);
        hTMLLexer.setRecognizeScripts(true);
        hTMLLexer.setRecognizeStyles(true);
        return hTMLLexer;
    }

    public void setRecognizeJSP(boolean bl) {
        HTMLLexer hTMLLexer = (HTMLLexer)this.getLexer();
        hTMLLexer.setRecognizeJSP(bl);
        hTMLLexer.setRecognizeEmbeddedTags(bl);
        this.tagRenderer.setRecognizeJSP(bl);
    }

    protected void renderToken(StyledFragmentsList styledFragmentsList, int n, int n2, int n3, int n4, int n5) {
        switch (n) {
            case 11: {
                int n6 = Math.max(n2, n4);
                int n7 = Math.min(n3, n5);
                this.renderHTMLTag(styledFragmentsList, n, n2, n3, n6, n7);
                break;
            }
            case 13: {
                int n8 = Math.max(n2, n4);
                int n9 = Math.min(n3, n5);
                this.renderHTMLScript(styledFragmentsList, n, n2, n3, n8, n9);
                break;
            }
            case 14: {
                int n10 = Math.max(n2, n4);
                int n11 = Math.min(n3, n5);
                this.renderHTMLStyle(styledFragmentsList, n, n2, n3, n10, n11);
                break;
            }
            default: {
                super.renderToken(styledFragmentsList, n, n2, n3, n4, n5);
            }
        }
    }

    protected String mapTokenToStyleName(int n) {
        switch (n) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                throw new UnsupportedOperationException("cannot map jsp tags");
            }
            case 11: {
                throw new IllegalStateException("Should be sub-rendering tags");
            }
            case 12: {
                return "html-comment-style";
            }
        }
        return this.getDefaultStyleName();
    }

    protected void renderHTMLScript(StyledFragmentsList styledFragmentsList, int n, int n2, int n3, int n4, int n5) {
        if (this.scratchLexer == null) {
            this.scratchLexer = (HTMLLexer)this.createLexer();
            this.scratchLexer.setRecognizeScripts(false);
            this.scratchLexer.setRecognizeStyles(false);
            this.scratchToken = this.scratchLexer.createLexerToken();
        }
        TextBuffer textBuffer = this.getTextBuffer();
        this.scratchLexer.setTextBuffer(textBuffer);
        this.scratchLexer.setPosition(n2);
        int n6 = this.scratchLexer.lex(this.scratchToken);
        int n7 = n2;
        int n8 = this.scratchToken.getEndOffset();
        this.renderHTMLTag(styledFragmentsList, n6, n7, n8, Math.max(n7, n4), Math.min(n8, n5));
        this.scratchLexer.setTextBuffer(null);
        int n9 = this.findScriptEnd(textBuffer, n8, n3);
        int n10 = n3;
        BlockRenderer blockRenderer = this.getRenderer(textBuffer, n7, n8);
        blockRenderer.renderBlock(styledFragmentsList, n8, n9, Math.max(n8, n4), Math.min(n9, n5));
        if (n9 < n10) {
            this.renderHTMLTag(styledFragmentsList, n6, n9, n10, Math.max(n9, n4), Math.min(n10, n5));
        }
    }

    protected void renderHTMLStyle(StyledFragmentsList styledFragmentsList, int n, int n2, int n3, int n4, int n5) {
        if (this.scratchLexer == null) {
            this.scratchLexer = (HTMLLexer)this.createLexer();
            this.scratchLexer.setRecognizeStyles(false);
            this.scratchLexer.setRecognizeScripts(false);
            this.scratchToken = this.scratchLexer.createLexerToken();
        }
        TextBuffer textBuffer = this.getTextBuffer();
        this.scratchLexer.setTextBuffer(textBuffer);
        this.scratchLexer.setPosition(n2);
        int n6 = this.scratchLexer.lex(this.scratchToken);
        int n7 = n2;
        int n8 = this.scratchToken.getEndOffset();
        this.renderHTMLTag(styledFragmentsList, n6, n7, n8, Math.max(n7, n4), Math.min(n8, n5));
        this.scratchLexer.setTextBuffer(null);
        int n9 = this.findScriptEnd(textBuffer, n8, n3);
        int n10 = n3;
        BlockRenderer blockRenderer = this.getStyleRenderer(textBuffer, n7, n8);
        int n11 = Math.max(n8, n4);
        int n12 = Math.min(n9, n5);
        blockRenderer.renderBlock(styledFragmentsList, n8, n9, n11, n12);
        if (n9 < n10) {
            this.renderHTMLTag(styledFragmentsList, n6, n9, n10, Math.max(n9, n4), Math.min(n10, n5));
        }
    }

    protected BlockRenderer getRenderer(TextBuffer textBuffer, int n, int n2) {
        return this.jsRenderer;
    }

    protected int findScriptEnd(TextBuffer textBuffer, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            int n4;
            char c = textBuffer.getChar(n3);
            if (c == '<' && (n4 = n2 - n3) >= 3 && textBuffer.getChar(n3 + 1) == '/' && ('a' <= (c = textBuffer.getChar(n3 + 2)) && c <= 'z' || 'A' <= c && c <= 'Z')) break;
            ++n3;
        }
        return n3;
    }

    protected boolean isScriptEnd(TextBuffer textBuffer, int n, int n2) {
        char c;
        if (n2 - n < 9) {
            return false;
        }
        int n3 = n;
        if ((c = textBuffer.getChar(n3++)) != '<') {
            return false;
        }
        if ((c = textBuffer.getChar(n3++)) != '/') {
            return false;
        }
        if ((c = textBuffer.getChar(n3++)) != 's' && c != 'S') {
            return false;
        }
        if ((c = textBuffer.getChar(n3++)) != 'c' && c != 'C') {
            return false;
        }
        if ((c = textBuffer.getChar(n3++)) != 'r' && c != 'R') {
            return false;
        }
        if ((c = textBuffer.getChar(n3++)) != 'i' && c != 'I') {
            return false;
        }
        if ((c = textBuffer.getChar(n3++)) != 'p' && c != 'P') {
            return false;
        }
        if ((c = textBuffer.getChar(n3++)) != 't' && c != 'T') {
            return false;
        }
        return (c = textBuffer.getChar(n3++)) == '>';
    }

    protected BlockRenderer getStyleRenderer(TextBuffer textBuffer, int n, int n2) {
        return this.styleRenderer;
    }

    protected void renderHTMLTag(StyledFragmentsList styledFragmentsList, int n, int n2, int n3, int n4, int n5) {
        this.tagRenderer.renderBlock(styledFragmentsList, n2, n3, n4, n5);
    }
}

