/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.html;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.html.HTMLBlockRenderer;
import oracle.javatools.editor.language.html.HTMLLanguageSupport;
import oracle.javatools.editor.language.html.HTMLStyles;
import oracle.javatools.editor.resource.BundleHelper;

public final class HTMLLanguageModule
extends LanguageModule {
    private static final String[] supportedFileTypes = new String[]{"html", "htm", "xml", "dtd", "xsl"};

    public String getPresentationName() {
        BundleHelper bundleHelper = EditorProperties.getEditorBundle();
        return bundleHelper.getString("HTML_MODULE_NAME");
    }

    public String[] getStyleNames() {
        return HTMLStyles.STYLE_NAMES;
    }

    public String getContentSample() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>\n");
        stringBuffer.append("  <head>\n");
        stringBuffer.append("    <meta HTTP-EQUIV=\"Content-Type\" ");
        stringBuffer.append("CONTENT=\"text/html; charset=WINDOWS-1252\">\n");
        stringBuffer.append("    <title>Oracle JDeveloper 9i</title>\n");
        stringBuffer.append("  </head>\n");
        stringBuffer.append("  <body>\n");
        stringBuffer.append("    <h4>Oracle JDeveloper 9i</h4><p>\n");
        stringBuffer.append("    New features in JDev 9i: <p>\n");
        stringBuffer.append("    <ul type=circle>\n");
        stringBuffer.append("      <li>100% Java IDE </li>\n");
        stringBuffer.append("      <li>Innovative J2EE development and ");
        stringBuffer.append("deployment support </li>\n");
        stringBuffer.append("      <li>Integrated support for Oracle9iAS ");
        stringBuffer.append("Containers for J2EE (OC4J) </li>\n");
        stringBuffer.append("      <li>Integrated UML Class modeler and ");
        stringBuffer.append("Activity modeler </li>\n");
        stringBuffer.append("      <li>Integrated Software Configuration ");
        stringBuffer.append("Management (SCM) </li>\n");
        stringBuffer.append("      <li>Innovative Profiler and ");
        stringBuffer.append("CodeCoach tools </li>\n");
        stringBuffer.append("      <li>Enhanced Business Components for ");
        stringBuffer.append("Java (BC4J) </li>\n");
        stringBuffer.append("      <li>Improved JSP support </li>\n");
        stringBuffer.append("      <li>Improved Java clients for BC4J </li>\n");
        stringBuffer.append("      <li>Enhanced database integration ");
        stringBuffer.append("features </li>\n");
        stringBuffer.append("      <li>Enhanced debugging support </li>\n");
        stringBuffer.append("      <li>Powerful code editor and tools </li>\n");
        stringBuffer.append("      <li>Java Addin API for customizing ");
        stringBuffer.append("JDeveloper </li>\n");
        stringBuffer.append("      <li>Enhanced XML support </li>\n");
        stringBuffer.append("    </ul>\n");
        stringBuffer.append("  </body>\n");
        stringBuffer.append("</html>\n");
        return stringBuffer.toString();
    }

    public String[] getSupportedFileTypes() {
        return supportedFileTypes;
    }

    public void registerStyles(StyleRegistry styleRegistry) {
        new HTMLStyles(styleRegistry);
    }

    public LanguageSupport createLanguageSupport() {
        return new HTMLLanguageSupport();
    }

    public BlockRenderer createBlockRenderer(TextBuffer textBuffer) {
        return new HTMLBlockRenderer(textBuffer);
    }
}

