/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.idl;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.idl.IDLBlockRenderer;
import oracle.javatools.editor.language.idl.IDLLanguageSupport;
import oracle.javatools.editor.language.idl.IDLStyles;
import oracle.javatools.editor.resource.BundleHelper;

public final class IDLLanguageModule
extends LanguageModule {
    private static final String[] supportedFileTypes = new String[]{"idl"};

    public String getPresentationName() {
        BundleHelper bundleHelper = EditorProperties.getEditorBundle();
        return bundleHelper.getString("IDL_MODULE_NAME");
    }

    public String[] getStyleNames() {
        return IDLStyles.STYLE_NAMES;
    }

    public String getContentSample() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("const long VERSION = 1;\n");
        stringBuffer.append("\n");
        stringBuffer.append("module hello\n");
        stringBuffer.append("{\n");
        stringBuffer.append("  // Returns some friendly message\n");
        stringBuffer.append("  interface Hello\n");
        stringBuffer.append("  {\n");
        stringBuffer.append("    wstring helloWorld();\n");
        stringBuffer.append("  };\n");
        stringBuffer.append("};\n");
        return stringBuffer.toString();
    }

    public String[] getSupportedFileTypes() {
        return supportedFileTypes;
    }

    public void registerStyles(StyleRegistry styleRegistry) {
        new IDLStyles(styleRegistry);
    }

    public LanguageSupport createLanguageSupport() {
        return new IDLLanguageSupport();
    }

    public BlockRenderer createBlockRenderer(TextBuffer textBuffer) {
        return new IDLBlockRenderer(textBuffer);
    }
}

