/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.java;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.LexerBlockRenderer;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.editor.language.java.JavaDocBlockRenderer;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.java.v2.JavaTokens;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;

public class JavaBlockRenderer
extends LexerBlockRenderer
implements JavaTokens {
    private JavaDocBlockRenderer docRenderer;

    public JavaBlockRenderer(TextBuffer textBuffer) {
        super(textBuffer);
        this.docRenderer = new JavaDocBlockRenderer(textBuffer);
    }

    protected Lexer createLexer() {
        JavaLexer javaLexer = new JavaLexer();
        javaLexer.setRecognizeSQLJ(true);
        return javaLexer;
    }

    protected void renderToken(StyledFragmentsList styledFragmentsList, int n, int n2, int n3, int n4, int n5) {
        switch (n) {
            case 26: {
                int n6 = Math.max(n2, n4);
                int n7 = Math.min(n3, n5);
                this.docRenderer.renderBlock(styledFragmentsList, n2, n3, n6, n7);
                break;
            }
            default: {
                super.renderToken(styledFragmentsList, n, n2, n3, n4, n5);
            }
        }
    }

    protected String mapTokenToStyleName(int n) {
        switch (n) {
            case 6: {
                return "java-sqlj-style";
            }
            case 4: {
                return "java-identifier-style";
            }
            case 8: 
            case 10: {
                return "java-number-style";
            }
            case 12: 
            case 15: {
                return "java-literals-style";
            }
            case 13: 
            case 14: {
                return "java-string-style";
            }
            case 24: 
            case 25: {
                return "java-comment-style";
            }
            case 26: {
                throw new IllegalStateException("should be sub-rendering doc");
            }
            case 49: 
            case 50: 
            case 55: 
            case 70: 
            case 71: 
            case 72: {
                return "java-brace-style";
            }
        }
        if (32 <= n && n < 81) {
            return "java-operator-style";
        }
        if (96 <= n && n < 146) {
            return "java-keyword-style";
        }
        return this.getDefaultStyleName();
    }
}

