/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.java;

import java.lang.ref.SoftReference;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.language.ExtendedBraceProvider;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;

public class JavaBraceProvider
implements ExtendedBraceProvider {
    protected LanguageSupport support;
    protected TextBuffer textBuffer;
    private static final int AVERAGE_TOKEN_SIZE = 8;
    private static final float BRACE_OCCURRENCE = 0.25f;
    private static final int MINIMUM_BRACE_ENTRIES = 20;
    private static final float EXPANSION_FACTOR = 1.25f;
    protected int[] braceArray;
    protected int braceCount;
    private SoftReference braceArrayRef;
    private int bufferChangeId;
    private static JavaLexer sharedJavaLexer = null;
    private static LexerToken sharedJavaToken = null;

    void $init$() {
        this.support = null;
    }

    public JavaBraceProvider(LanguageSupport languageSupport) {
        this.$init$();
        this.support = languageSupport;
        BasicDocument basicDocument = languageSupport.getDocument();
        this.textBuffer = basicDocument.getTextBuffer();
        this.bufferChangeId = -1;
    }

    public JavaBraceProvider(TextBuffer textBuffer) {
        this.$init$();
        this.textBuffer = textBuffer;
        this.bufferChangeId = -1;
    }

    public int getBraceType(int n, NumberRange numberRange) {
        switch (n) {
            case 40: 
            case 41: {
                return 1;
            }
            case 123: 
            case 125: {
                return 3;
            }
            case 91: 
            case 93: {
                return 2;
            }
        }
        return -1;
    }

    public boolean isOpenBraceType(int n) {
        switch (n) {
            case 40: 
            case 91: 
            case 123: {
                return true;
            }
        }
        return false;
    }

    public boolean isCloseBraceType(int n) {
        switch (n) {
            case 41: 
            case 93: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    public synchronized int findClosestBrace(int n, NumberRange numberRange) {
        int n2 = Math.max(0, n);
        n2 = Math.min(n2, this.textBuffer.getLength());
        try {
            int n3;
            this.buildBraceArray();
            int n4 = JavaBraceProvider.binarySearch(this.braceArray, this.braceCount, n);
            if (n4 >= 0 && this.braceArray[n4] == n) {
                --n4;
            }
            if (n4 < 0) {
                int n5 = -1;
                this.releaseBraceArray();
                return n5;
            }
            numberRange.start = n3 = this.braceArray[n4];
            numberRange.end = n3 + 1;
            char c = this.textBuffer.getChar(n3);
            this.releaseBraceArray();
            return c;
        }
        catch (Throwable throwable) {
            this.releaseBraceArray();
            throw throwable;
        }
    }

    public synchronized int isPartOfBrace(int n, NumberRange numberRange) {
        char c = this.textBuffer.getChar(n);
        switch (c) {
            case '(': 
            case ')': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                if (!this.isValidBrace(n)) break;
                char c2 = c;
                numberRange.start = n;
                numberRange.end = n + 1;
                return c2;
            }
        }
        int n2 = -1;
        return n2;
    }

    public synchronized int findMatchingBrace(int n, NumberRange numberRange, NumberRange numberRange2) {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        switch (n) {
            case 91: {
                bl2 = true;
                bl = true;
                break;
            }
            case 40: {
                bl4 = true;
                bl = true;
                break;
            }
            case 123: {
                bl3 = true;
                bl = true;
                break;
            }
            case 93: {
                bl2 = true;
                bl = false;
                break;
            }
            case 41: {
                bl4 = true;
                bl = false;
                break;
            }
            case 125: {
                bl3 = true;
                bl = false;
                break;
            }
            default: {
                return 3;
            }
        }
        if (!(bl2 || bl4 || bl3)) {
            throw new IllegalStateException("bad check logic");
        }
        int n2 = numberRange.start;
        if (n2 < 0 || n2 >= this.textBuffer.getLength() || n != this.textBuffer.getChar(n2)) {
            throw new IllegalStateException("brace not in buffer");
        }
        try {
            int n3;
            this.buildBraceArray();
            int n4 = this.findEntryForOffset(n2);
            if (n4 == -1) {
                int n5 = 3;
                this.releaseBraceArray();
                return n5;
            }
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = n3 = bl ? 1 : -1;
            for (int i = n4; i >= 0; i += n3) {
                if (i >= this.braceCount) {
                    break;
                }
                int n10 = this.braceArray[i];
                char c = this.textBuffer.getChar(n10);
                switch (c) {
                    case '[': {
                        ++n8;
                        break;
                    }
                    case ']': {
                        --n8;
                        break;
                    }
                    case '{': {
                        ++n7;
                        break;
                    }
                    case '}': {
                        --n7;
                        break;
                    }
                    case '(': {
                        ++n6;
                        break;
                    }
                    case ')': {
                        --n6;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("not a brace: " + c);
                    }
                }
                if (!(bl3 && n7 == 0 || bl4 && n6 == 0) && (!bl2 || n8 != 0)) continue;
                numberRange2.start = n10;
                numberRange2.end = n10 + 1;
                if (n7 == 0 && n6 == 0 && n8 == 0) {
                    int n11 = 1;
                    this.releaseBraceArray();
                    return n11;
                }
                int n12 = 2;
                this.releaseBraceArray();
                return n12;
            }
        }
        finally {
            this.releaseBraceArray();
        }
        return 3;
    }

    protected int guessBraceCount(int n) {
        return (int)((float)(n / 8) * 0.25f);
    }

    protected int[] expandBraceArray(int[] nArray) {
        int n = nArray.length;
        int n2 = (int)((float)n * 1.25f);
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    protected void fillBraceArray() {
        JavaLexer javaLexer = JavaBraceProvider.acquireJavaLexer();
        javaLexer.setTextBuffer(this.textBuffer);
        LexerToken lexerToken = JavaBraceProvider.acquireJavaLexerToken(javaLexer);
        this.scanJavaBlock(javaLexer, lexerToken, 0, this.textBuffer.getLength());
        JavaBraceProvider.releaseJavaLexer(javaLexer);
        JavaBraceProvider.releaseJavaLexerToken(lexerToken);
    }

    protected void scanJavaBlock(JavaLexer javaLexer, LexerToken lexerToken, int n, int n2) {
        javaLexer.setPosition(n);
        block4: while (true) {
            int n3 = javaLexer.lex(lexerToken);
            if (lexerToken.getStartOffset() >= n2) break;
            switch (n3) {
                case 0: {
                    break block4;
                }
                case 49: 
                case 50: 
                case 55: 
                case 70: 
                case 71: 
                case 72: {
                    if (this.braceCount == this.braceArray.length) {
                        this.braceArray = this.expandBraceArray(this.braceArray);
                    }
                    this.braceArray[this.braceCount++] = lexerToken.getStartOffset();
                }
                default: {
                    continue block4;
                }
            }
            break;
        }
    }

    private void buildBraceArray() {
        if (this.braceArrayRef != null) {
            this.braceArray = (int[])this.braceArrayRef.get();
        }
        if (this.braceArray == null || this.bufferChangeId != this.textBuffer.getChangeId()) {
            int n = this.textBuffer.getLength();
            int n2 = Math.max(this.guessBraceCount(n), 20);
            if (this.braceArray == null) {
                this.braceArray = new int[n2];
            }
            this.bufferChangeId = this.textBuffer.getChangeId();
            this.braceCount = 0;
            this.fillBraceArray();
            this.braceArrayRef = new SoftReference<int[]>(this.braceArray);
        }
    }

    private void releaseBraceArray() {
        this.braceArray = null;
    }

    private boolean isValidBrace(int n) {
        try {
            this.buildBraceArray();
            int n2 = this.findEntryForOffset(n);
            boolean bl = n2 != -1;
            this.releaseBraceArray();
            return bl;
        }
        catch (Throwable throwable) {
            this.releaseBraceArray();
            throw throwable;
        }
    }

    private int findEntryForOffset(int n) {
        int n2 = JavaBraceProvider.binarySearch(this.braceArray, this.braceCount, n);
        if (n2 != -1 && this.braceArray[n2] != n) {
            n2 = -1;
        }
        return n2;
    }

    private static int binarySearch(int[] nArray, int n, int n2) {
        if (nArray == null || nArray.length == 0 || n == 0) {
            return -1;
        }
        if (nArray.length > 0 && n > 0 && n2 < nArray[0]) {
            return -1;
        }
        int n3 = 0;
        int n4 = n;
        int n5;
        while ((n5 = n4 - n3) != 1) {
            int n6 = n4 + n3 >> 1;
            int n7 = nArray[n6];
            if (n7 > n2) {
                n4 = n6;
                continue;
            }
            n3 = n6;
        }
        return n3;
    }

    protected static synchronized JavaLexer acquireJavaLexer() {
        JavaLexer javaLexer = sharedJavaLexer;
        sharedJavaLexer = null;
        if (javaLexer == null) {
            javaLexer = new JavaLexer();
            javaLexer.setSkipComments(true);
            javaLexer.setRecognizeSQLJ(true);
        }
        return javaLexer;
    }

    protected static synchronized void releaseJavaLexer(JavaLexer javaLexer) {
        if (javaLexer != null) {
            javaLexer.setTextBuffer(null);
        }
        sharedJavaLexer = javaLexer;
    }

    protected static synchronized LexerToken acquireJavaLexerToken(JavaLexer javaLexer) {
        LexerToken lexerToken = sharedJavaToken;
        sharedJavaToken = null;
        if (lexerToken == null) {
            lexerToken = javaLexer.createLexerToken();
        }
        return lexerToken;
    }

    protected static synchronized void releaseJavaLexerToken(LexerToken lexerToken) {
        sharedJavaToken = lexerToken;
    }
}

