/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.java;

import javax.swing.event.DocumentEvent;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocumentEvent;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.HistoryReadTextBuffer;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.LexerDocumentRenderer;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.language.java.JavaBlockRenderer;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.JavaTokens;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;

final class JavaDocumentRenderer
extends LexerDocumentRenderer
implements JavaTokens {
    JavaDocumentRenderer(LanguageSupport languageSupport) {
        super(languageSupport);
    }

    protected BlockRenderer createBlockRenderer() {
        TextBuffer textBuffer = this.getTextBuffer();
        return new JavaBlockRenderer(textBuffer);
    }

    protected Lexer createLexer() {
        JavaLexer javaLexer = new JavaLexer();
        javaLexer.setRecognizeSQLJ(true);
        return javaLexer;
    }

    public boolean isMultiLineToken(int n) {
        switch (n) {
            case 6: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    public void calculateDamage(DocumentEvent documentEvent, NumberRange numberRange) {
        int n;
        int n2;
        int n3;
        TextBuffer textBuffer = this.getTextBuffer();
        LineMap lineMap = this.getLineMap();
        int n4 = lineMap.getLineCount();
        boolean bl = documentEvent.getType() == DocumentEvent.EventType.INSERT;
        int n5 = documentEvent.getLength();
        int n6 = documentEvent.getOffset();
        int n7 = bl ? n5 + n6 : n6;
        int n8 = bl ? n6 : n5 + n6;
        int n9 = lineMap.getLineFromOffset(n6);
        Lexer lexer = this.getLexer();
        LexerToken lexerToken = this.getLexerToken();
        int n10 = this.getOffsetsCache().findClosestOffset(lexer, lexerToken, n6);
        int n11 = -1;
        int n12 = -1;
        int n13 = 0;
        lexer.setTextBuffer(textBuffer);
        lexer.setPosition(n10);
        while ((n3 = lexer.lex(lexerToken)) != 0) {
            int n14 = lexerToken.getStartOffset();
            int n15 = lexerToken.getEndOffset();
            if (n15 <= n7) continue;
            if (n14 >= n6) break;
            n11 = n14;
            n12 = n15 - n14;
            n13 = n3;
            break;
        }
        lexer.setTextBuffer(null);
        if (n13 != 25 && n13 != 26 && n13 != 6) {
            super.calculateDamage(documentEvent, numberRange);
            return;
        }
        int n16 = -1;
        int n17 = -1;
        int n18 = 0;
        HistoryReadTextBuffer historyReadTextBuffer = HistoryReadTextBuffer.acquireReadTextBuffer(textBuffer, (BasicDocumentEvent)documentEvent);
        lexer.setTextBuffer(historyReadTextBuffer);
        lexer.setPosition(n10);
        while ((n2 = lexer.lex(lexerToken)) != 0) {
            int n19 = lexerToken.getStartOffset();
            int n20 = lexerToken.getEndOffset();
            if (n20 <= n8) continue;
            if (n19 >= n6) break;
            n16 = n19;
            n17 = n20 - n19;
            n18 = n2;
            break;
        }
        lexer.setTextBuffer(null);
        HistoryReadTextBuffer.releaseReadTextBuffer(historyReadTextBuffer);
        int n21 = n = bl ? n17 + n5 : n17 - n5;
        if (n16 != n11 || n != n12 || n18 != n13) {
            super.calculateDamage(documentEvent, numberRange);
            return;
        }
        if (n13 == 25 || n13 == 6) {
            numberRange.start = n9;
            numberRange.end = n9;
            return;
        }
        boolean bl2 = false;
        char[] cArray = ((BasicDocumentEvent)documentEvent).getData();
        int n22 = 0;
        while (n22 < n5) {
            if (cArray[n22] == '@') {
                bl2 = true;
                break;
            }
            ++n22;
        }
        if (bl2) {
            int n23 = n11 + n12;
            int n24 = lineMap.getLineFromOffset(n23);
            numberRange.start = n9;
            numberRange.end = n24;
        } else {
            numberRange.start = n9;
            numberRange.end = n9;
        }
    }
}

