/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.java;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.java.JavaBlockRenderer;
import oracle.javatools.editor.language.java.JavaLanguageSupport;
import oracle.javatools.editor.language.java.JavaStyles;
import oracle.javatools.editor.resource.BundleHelper;

public final class JavaLanguageModule
extends LanguageModule {
    private static final String[] supportedFileTypes = new String[]{"java", "sqlj"};

    public String getPresentationName() {
        BundleHelper bundleHelper = EditorProperties.getEditorBundle();
        return bundleHelper.getString("JAVA_MODULE_NAME");
    }

    public String[] getStyleNames() {
        return JavaStyles.getStyleNames();
    }

    public String getContentSample() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("import java.util.Date;\n");
        stringBuffer.append("import java.text.DateFormat;\n");
        stringBuffer.append("\n");
        stringBuffer.append("/**\n");
        stringBuffer.append(" * Simple <code>Today</code> class which ");
        stringBuffer.append("prints out today's date.\n");
        stringBuffer.append(" * @version 1.00 09/25/2001\n");
        stringBuffer.append(" */\n");
        stringBuffer.append("public final class Today\n");
        stringBuffer.append("{\n");
        stringBuffer.append("  public static void main( String[] args )\n");
        stringBuffer.append("  {\n");
        stringBuffer.append("    // We don't take any arguments\n");
        stringBuffer.append("    if ( ( args != null ) && ( args.length > 0 ) )\n");
        stringBuffer.append("    {\n");
        stringBuffer.append("      System.out.println( \"Usage:\" );\n");
        stringBuffer.append("      System.out.println( \"  java Today\" );\n");
        stringBuffer.append("      return;\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("    // Use the local date formatter\n");
        stringBuffer.append("    Date today = new Date();\n");
        stringBuffer.append("    String todayText = ");
        stringBuffer.append("DateFormat.getDateInstance().format( today );\n");
        stringBuffer.append("    System.out.println( \"Today's date: \" + ");
        stringBuffer.append("todayText );\n");
        stringBuffer.append("  }\n");
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public String[] getSupportedFileTypes() {
        return supportedFileTypes;
    }

    public void registerStyles(StyleRegistry styleRegistry) {
        JavaStyles javaStyles = new JavaStyles(styleRegistry);
    }

    public LanguageSupport createLanguageSupport() {
        return new JavaLanguageSupport();
    }

    public BlockRenderer createBlockRenderer(TextBuffer textBuffer) {
        return new JavaBlockRenderer(textBuffer);
    }
}

