/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.java;

import java.awt.Color;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.BuiltInStyles;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.resource.BundleHelper;

public final class JavaStyles {
    public static final String JAVA_COMMENT_STYLE = "java-comment-style";
    public static final String JAVA_KEYWORD_STYLE = "java-keyword-style";
    public static final String JAVA_STRING_STYLE = "java-string-style";
    public static final String JAVA_LITERALS_STYLE = "java-literals-style";
    public static final String JAVA_NUMBER_STYLE = "java-number-style";
    public static final String JAVA_IDENTIFIER_STYLE = "java-identifier-style";
    public static final String JAVA_OPERATOR_STYLE = "java-operator-style";
    public static final String JAVA_BRACE_STYLE = "java-brace-style";
    public static final String JAVA_SQLJ_STYLE = "java-sqlj-style";
    public static final String JAVADOC_COMMENT_STYLE = "javadoc-comment-style";
    public static final String JAVADOC_TAG_STYLE = "javadoc-tag-style";
    public static final String JAVADOC_TAG_TEXT_STYLE = "javadoc-tag-text-style";
    public static final String[] STYLE_NAMES = new String[]{"java-comment-style", "java-keyword-style", "java-string-style", "java-literals-style", "java-number-style", "java-identifier-style", "java-operator-style", "java-brace-style", "java-sqlj-style", "javadoc-comment-style", "javadoc-tag-style", "javadoc-tag-text-style"};
    public static BaseStyle javaPlainStyle;
    public static BaseStyle javaCommentStyle;
    public static BaseStyle javaKeywordStyle;
    public static BaseStyle javaStringStyle;
    public static BaseStyle javaLiteralsStyle;
    public static BaseStyle javaNumberStyle;
    public static BaseStyle javaIdentifierStyle;
    public static BaseStyle javaOperatorStyle;
    public static BaseStyle javaBraceStyle;
    public static BaseStyle javaSQLJStyle;
    public static BaseStyle javadocCommentStyle;
    public static BaseStyle javadocTagStyle;
    public static BaseStyle javadocTagTextStyle;

    public JavaStyles(StyleRegistry styleRegistry) {
        this.reloadStyles(styleRegistry);
    }

    public static String[] getStyleNames() {
        return STYLE_NAMES;
    }

    public void reloadStyles(StyleRegistry styleRegistry) {
        BundleHelper bundleHelper = EditorProperties.getEditorBundle();
        BuiltInStyles builtInStyles = new BuiltInStyles(styleRegistry);
        javaPlainStyle = builtInStyles.plainStyle;
        javaCommentStyle = styleRegistry.lookupStyle(JAVA_COMMENT_STYLE);
        if (javaCommentStyle == null) {
            String string = bundleHelper.getString("JAVA_COMMENT_STYLE");
            javaCommentStyle = styleRegistry.createStyle(JAVA_COMMENT_STYLE, string, "base-comment-style");
        }
        if ((javaStringStyle = styleRegistry.lookupStyle(JAVA_STRING_STYLE)) == null) {
            String string = bundleHelper.getString("JAVA_STRING_STYLE");
            javaStringStyle = styleRegistry.createStyle(JAVA_STRING_STYLE, string, "base-string-style");
        }
        if ((javaKeywordStyle = styleRegistry.lookupStyle(JAVA_KEYWORD_STYLE)) == null) {
            String string = bundleHelper.getString("JAVA_KEYWORD_STYLE");
            javaKeywordStyle = styleRegistry.createStyle(JAVA_KEYWORD_STYLE, string, "base-keyword-style");
        }
        if ((javaLiteralsStyle = styleRegistry.lookupStyle(JAVA_LITERALS_STYLE)) == null) {
            String string = bundleHelper.getString("JAVA_LITERALS_STYLE");
            javaLiteralsStyle = styleRegistry.createStyle(JAVA_LITERALS_STYLE, string, "base-keyword-style", Color.blue);
        }
        if ((javaNumberStyle = styleRegistry.lookupStyle(JAVA_NUMBER_STYLE)) == null) {
            String string = bundleHelper.getString("JAVA_NUMBER_STYLE");
            javaNumberStyle = styleRegistry.createStyle(JAVA_NUMBER_STYLE, string, "base-number-style");
        }
        if ((javaIdentifierStyle = styleRegistry.lookupStyle(JAVA_IDENTIFIER_STYLE)) == null) {
            String string = bundleHelper.getString("JAVA_IDENTIFIER_STYLE");
            javaIdentifierStyle = styleRegistry.createStyle(JAVA_IDENTIFIER_STYLE, string, "base-identifier-style");
        }
        if ((javaOperatorStyle = styleRegistry.lookupStyle(JAVA_OPERATOR_STYLE)) == null) {
            String string = bundleHelper.getString("JAVA_OPERATOR_STYLE");
            javaOperatorStyle = styleRegistry.createStyle(JAVA_OPERATOR_STYLE, string, "base-operator-style");
        }
        if ((javaBraceStyle = styleRegistry.lookupStyle(JAVA_BRACE_STYLE)) == null) {
            String string = bundleHelper.getString("JAVA_BRACE_STYLE");
            javaBraceStyle = styleRegistry.createStyle(JAVA_BRACE_STYLE, string, "base-brace-style");
        }
        if ((javaSQLJStyle = styleRegistry.lookupStyle(JAVA_SQLJ_STYLE)) == null) {
            String string = bundleHelper.getString("JAVA_SQLJ_STYLE");
            javaSQLJStyle = styleRegistry.createStyle(JAVA_SQLJ_STYLE, string, "base-plain-style", new Color(204, 204, 0));
        }
        if ((javadocCommentStyle = styleRegistry.lookupStyle(JAVADOC_COMMENT_STYLE)) == null) {
            String string = bundleHelper.getString("JAVADOC_COMMENT_STYLE");
            javadocCommentStyle = styleRegistry.createStyle(JAVADOC_COMMENT_STYLE, string, JAVA_COMMENT_STYLE, Color.gray);
        }
        if ((javadocTagTextStyle = styleRegistry.lookupStyle(JAVADOC_TAG_TEXT_STYLE)) == null) {
            String string = bundleHelper.getString("JAVADOC_TAG_TEXT_STYLE");
            javadocTagTextStyle = styleRegistry.createStyle(JAVADOC_TAG_TEXT_STYLE, string, JAVADOC_COMMENT_STYLE, new Color(153, 102, 102));
        }
        if ((javadocTagStyle = styleRegistry.lookupStyle(JAVADOC_TAG_STYLE)) == null) {
            String string = bundleHelper.getString("JAVADOC_TAG_STYLE");
            javadocTagStyle = styleRegistry.createStyle(JAVADOC_TAG_STYLE, string, JAVADOC_COMMENT_STYLE, new Color(153, 102, 102), 3);
        }
    }
}

