/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.jsp;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.editor.language.html.HTMLBlockRenderer;
import oracle.javatools.editor.language.html.TagBlockRenderer;
import oracle.javatools.editor.language.java.JavaBlockRenderer;
import oracle.javatools.editor.language.jsp.JSPTagBlockRenderer;

final class JSPBlockRenderer
extends HTMLBlockRenderer {
    protected JavaBlockRenderer javaRenderer;

    JSPBlockRenderer(TextBuffer textBuffer) {
        super(textBuffer);
        this.javaRenderer = new JavaBlockRenderer(textBuffer);
        this.setRecognizeJSP(true);
    }

    protected TagBlockRenderer createTagRenderer(TextBuffer textBuffer) {
        return new JSPTagBlockRenderer(textBuffer);
    }

    protected void renderToken(StyledFragmentsList styledFragmentsList, int n, int n2, int n3, int n4, int n5) {
        switch (n) {
            case 21: {
                int n6 = Math.max(n2, n4);
                int n7 = Math.min(n3, n5);
                this.renderHTMLTag(styledFragmentsList, n, n2, n3, n6, n7);
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                int n8 = Math.max(n2, n4);
                int n9 = Math.min(n3, n5);
                this.renderJavaTag(styledFragmentsList, n, n2, n3, n8, n9);
                break;
            }
            default: {
                super.renderToken(styledFragmentsList, n, n2, n3, n4, n5);
            }
        }
    }

    protected void renderJavaTag(StyledFragmentsList styledFragmentsList, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8 = n2;
        int n9 = n3;
        switch (n) {
            case 22: {
                n8 += 2;
                break;
            }
            case 23: 
            case 24: {
                n8 += 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown java tag: " + n);
            }
        }
        if (this.textBuffer.getChar(n3 - 1) == '>' && this.textBuffer.getChar(n3 - 2) == '%') {
            int n10 = n3 - n2;
            int n11 = Math.max(Math.min(n10 - 2, 2), 0);
            n9 -= n11;
        }
        if ((n7 = Math.max(n2, n4)) < (n6 = Math.min(n8, n5))) {
            styledFragmentsList.add("html-symbol-style", n7, n6);
        }
        if (n8 != n9) {
            int n12 = Math.max(n8, n4);
            int n13 = Math.min(n9, n5);
            this.javaRenderer.renderBlock(styledFragmentsList, n8, n9, n12, n13);
        }
        if (n9 != n3 && (n7 = Math.max(n9, n4)) < (n6 = Math.min(n3, n5))) {
            styledFragmentsList.add("html-symbol-style", n7, n6);
        }
    }

    protected String mapTokenToStyleName(int n) {
        switch (n) {
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                throw new IllegalStateException("Should be sub-rendering tags");
            }
            case 25: {
                return "html-comment-style";
            }
        }
        return super.mapTokenToStyleName(n);
    }
}

