/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.jsp;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.java.JavaBraceProvider;
import oracle.javatools.editor.language.jsp.LexerHelper;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.html.HTMLLexer;
import oracle.javatools.parser.html.TagLexer;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;

public final class JSPBraceProvider
extends JavaBraceProvider {
    private static final int AVERAGE_TOKEN_SIZE = 8;
    private static final float JAVA_OCCURRENCE = 0.3f;
    private static final float BRACE_OCCURRENCE = 0.25f;
    private static LexerHelper sharedLexerHelper = null;

    public JSPBraceProvider(LanguageSupport languageSupport) {
        super(languageSupport);
    }

    protected int guessBraceCount(int n) {
        return (int)((float)(n / 8) * 0.25f * 0.3f);
    }

    protected void fillBraceArray() {
        LexerHelper lexerHelper = JSPBraceProvider.acquireLexerHelper();
        JavaLexer javaLexer = JSPBraceProvider.acquireJavaLexer();
        javaLexer.setTextBuffer(this.textBuffer);
        LexerToken lexerToken = JSPBraceProvider.acquireJavaLexerToken(javaLexer);
        this.scanHTMLBlock(lexerHelper, javaLexer, lexerToken, 0, this.textBuffer.getLength());
        JSPBraceProvider.releaseLexerHelper(lexerHelper);
        JSPBraceProvider.releaseJavaLexer(javaLexer);
        JSPBraceProvider.releaseJavaLexerToken(lexerToken);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void scanHTMLBlock(LexerHelper lexerHelper, JavaLexer javaLexer, LexerToken lexerToken, int n, int n2) {
        HTMLLexer hTMLLexer = lexerHelper.htmlLexer;
        hTMLLexer.setTextBuffer(this.textBuffer);
        hTMLLexer.setPosition(n);
        LexerToken lexerToken2 = lexerHelper.htmlToken;
        while (true) {
            int n3 = hTMLLexer.lex(lexerToken2);
            if (lexerToken2.getStartOffset() >= n2) {
                return;
            }
            switch (n3) {
                case 0: {
                    return;
                }
                case 11: 
                case 21: {
                    int n4 = lexerToken2.getStartOffset();
                    int n5 = lexerToken2.getEndOffset();
                    this.scanTagBlock(lexerHelper, javaLexer, lexerToken, n4, n5);
                    break;
                }
                case 22: 
                case 23: 
                case 24: {
                    int n6 = lexerToken2.getStartOffset();
                    int n7 = lexerToken2.getEndOffset();
                    this.scanJavaBlock(javaLexer, lexerToken, n6, n7);
                }
            }
        }
    }

    private void scanTagBlock(LexerHelper lexerHelper, JavaLexer javaLexer, LexerToken lexerToken, int n, int n2) {
        TagLexer tagLexer = lexerHelper.tagLexer;
        tagLexer.setTextBuffer(this.textBuffer);
        tagLexer.setPosition(n);
        LexerToken lexerToken2 = lexerHelper.tagToken;
        block4: while (true) {
            int n3 = tagLexer.lex(lexerToken2);
            if (lexerToken2.getStartOffset() >= n2) break;
            switch (n3) {
                case 0: {
                    break block4;
                }
                case 24: {
                    int n4;
                    int n5 = lexerToken2.getStartOffset();
                    if (JSPBraceProvider.isQuote(this.textBuffer, n5)) {
                        ++n5;
                    }
                    if (JSPBraceProvider.isQuote(this.textBuffer, (n4 = lexerToken2.getEndOffset()) - 1)) {
                        --n4;
                    }
                    LexerHelper lexerHelper2 = lexerHelper.getEmbeddedHelper();
                    this.scanHTMLBlock(lexerHelper2, javaLexer, lexerToken, n5, n4);
                }
                default: {
                    continue block4;
                }
            }
            break;
        }
    }

    private static boolean isQuote(TextBuffer textBuffer, int n) {
        char c = textBuffer.getChar(n);
        return c == '\'' || c == '\"';
    }

    private static synchronized LexerHelper acquireLexerHelper() {
        LexerHelper lexerHelper = sharedLexerHelper;
        sharedLexerHelper = null;
        if (lexerHelper == null) {
            lexerHelper = new LexerHelper();
        }
        return lexerHelper;
    }

    protected static synchronized void releaseLexerHelper(LexerHelper lexerHelper) {
        if (lexerHelper != null) {
            lexerHelper.clear();
        }
        sharedLexerHelper = lexerHelper;
    }
}

