/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.jsp;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.html.HTMLStyles;
import oracle.javatools.editor.language.java.JavaStyles;
import oracle.javatools.editor.language.jsp.JSPBlockRenderer;
import oracle.javatools.editor.language.jsp.JSPLanguageSupport;
import oracle.javatools.editor.resource.BundleHelper;

public final class JSPLanguageModule
extends LanguageModule {
    private static final String[] supportedFileTypes = new String[]{"jsp"};

    public String getPresentationName() {
        BundleHelper bundleHelper = EditorProperties.getEditorBundle();
        return bundleHelper.getString("JSP_MODULE_NAME");
    }

    public String[] getStyleNames() {
        String[] stringArray = JavaStyles.STYLE_NAMES;
        int n = stringArray.length;
        String[] stringArray2 = HTMLStyles.STYLE_NAMES;
        int n2 = stringArray2.length;
        String[] stringArray3 = new String[n + n2];
        System.arraycopy(stringArray, 0, stringArray3, 0, n);
        System.arraycopy(stringArray2, 0, stringArray3, n, n2);
        return stringArray3;
    }

    public String getContentSample() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        stringBuffer.append("<%@ page contentType=\"text/html;");
        stringBuffer.append("charset=WINDOWS-1252\"%>\n");
        stringBuffer.append("<html>\n");
        stringBuffer.append("<head>\n");
        stringBuffer.append("<meta http-equiv=\"Content-Type\" ");
        stringBuffer.append("content=\"text/html; charset=WINDOWS-1252\">\n");
        stringBuffer.append("<title>Today's Date</title>\n");
        stringBuffer.append("</head>\n");
        stringBuffer.append("<body>\n");
        stringBuffer.append("<%\n");
        stringBuffer.append("  // Just print out today's date\n");
        stringBuffer.append("  java.util.Date today = new java.util.Date();\n");
        stringBuffer.append("  out.println( \"Today's date: \" +");
        stringBuffer.append("today.toString() ); %> <P>\n");
        stringBuffer.append("</body>\n");
        stringBuffer.append("</html>\n");
        return stringBuffer.toString();
    }

    public String[] getSupportedFileTypes() {
        return supportedFileTypes;
    }

    public void registerStyles(StyleRegistry styleRegistry) {
    }

    public LanguageSupport createLanguageSupport() {
        return new JSPLanguageSupport();
    }

    public BlockRenderer createBlockRenderer(TextBuffer textBuffer) {
        return new JSPBlockRenderer(textBuffer);
    }
}

