/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.php;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.editor.language.html.HTMLBlockRenderer;
import oracle.javatools.editor.language.php.PHPBlockRenderer;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.html.HTMLLexer;
import oracle.javatools.parser.html.HTMLTokens;
import oracle.javatools.parser.html.TagLexer;

public class PHPHTMLBlockRenderer
extends HTMLBlockRenderer
implements HTMLTokens {
    protected PHPBlockRenderer phpRenderer;
    protected TagLexer scratchTagLexer;
    protected LexerToken scratchTagToken;

    public PHPHTMLBlockRenderer(TextBuffer textBuffer) {
        super(textBuffer);
        this.phpRenderer = new PHPBlockRenderer(textBuffer);
    }

    protected Lexer createLexer() {
        HTMLLexer hTMLLexer = new HTMLLexer();
        hTMLLexer.setRecognizeScripts(true);
        hTMLLexer.setRecognizePHP(true);
        return hTMLLexer;
    }

    protected void renderToken(StyledFragmentsList styledFragmentsList, int n, int n2, int n3, int n4, int n5) {
        switch (n) {
            case 31: {
                int n6 = Math.max(n2, n4);
                int n7 = Math.min(n3, n5);
                this.renderPHPTag(styledFragmentsList, n, n2, n3, n6, n7);
                break;
            }
            case 32: {
                int n8 = Math.max(n2, n4);
                int n9 = Math.min(n3, n5);
                this.renderPHPASPTag(styledFragmentsList, n, n2, n3, n8, n9);
                break;
            }
            default: {
                super.renderToken(styledFragmentsList, n, n2, n3, n4, n5);
            }
        }
    }

    protected String mapTokenToStyleName(int n) {
        switch (n) {
            case 31: 
            case 32: {
                throw new IllegalStateException("Should be sub-rendering tags");
            }
        }
        return super.mapTokenToStyleName(n);
    }

    protected BlockRenderer getRenderer(TextBuffer textBuffer, int n, int n2) {
        int n3;
        if (this.scratchTagLexer == null) {
            this.scratchTagLexer = new TagLexer();
            this.scratchTagLexer.setRecognizeJSP(false);
            this.scratchTagLexer.setSkipSymbols(true);
            this.scratchTagToken = this.scratchTagLexer.createLexerToken();
        }
        this.scratchTagLexer.setTextBuffer(textBuffer);
        this.scratchTagLexer.setPosition(n);
        PHPBlockRenderer pHPBlockRenderer = null;
        String string = null;
        while ((n3 = this.scratchTagLexer.lex(this.scratchTagToken)) != 0) {
            int n4 = this.scratchTagToken.getStartOffset();
            int n5 = this.scratchTagToken.getEndOffset();
            String string2 = textBuffer.getString(n4, n5 - n4).trim();
            if (n4 >= n2) break;
            if (n3 == 21) {
                string = string2;
                continue;
            }
            if (n3 != 22) continue;
            String string3 = string2;
            if (string3.startsWith("\"") || string3.startsWith("'")) {
                string3 = string3.substring(1);
            }
            if (string3.endsWith("\"") || string3.endsWith("'")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            if ((!string.equalsIgnoreCase("language") || !string3.regionMatches(true, 0, "php", 0, 3)) && (!string.equalsIgnoreCase("type") || !string3.regionMatches(true, 0, "text/php", 0, 8))) continue;
            pHPBlockRenderer = this.phpRenderer;
            break;
        }
        this.scratchTagLexer.setTextBuffer(null);
        if (pHPBlockRenderer != null) {
            return pHPBlockRenderer;
        }
        return super.getRenderer(textBuffer, n, n2);
    }

    protected void renderPHPTag(StyledFragmentsList styledFragmentsList, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = Math.max(n4, n2);
        if (n7 < (n6 = Math.min(n5, n2 + 2))) {
            styledFragmentsList.add("html-symbol-style", n7, n6);
        }
        int n8 = n2 + 2;
        int n9 = n3;
        int n10 = Math.max(n4, n8);
        int n11 = Math.min(n5, n9);
        TextBuffer textBuffer = this.getTextBuffer();
        if (n9 - n8 >= 5) {
            int n12 = n8;
            char c = textBuffer.getChar(n12++);
            char c2 = textBuffer.getChar(n12++);
            char c3 = textBuffer.getChar(n12++);
            if (!(c != 'p' && c != 'P' || c2 != 'h' && c2 != 'H' || c3 != 'p' && c3 != 'P')) {
                n7 = Math.max(n4, n8);
                if (n7 < (n6 = Math.min(n5, n8 + 3))) {
                    styledFragmentsList.add("html-element-style", n7, n6);
                }
                n8 = n2 + 5;
                n10 = Math.max(n4, n8);
            }
        }
        boolean bl = false;
        if (n9 - n8 >= 2) {
            int n13 = n9 - 2;
            char c = textBuffer.getChar(n13++);
            char c4 = textBuffer.getChar(n13);
            if (c == '?' && c4 == '>') {
                bl = true;
                n9 = n3 - 2;
                n11 = Math.min(n5, n9);
            }
        }
        this.phpRenderer.renderBlock(styledFragmentsList, n8, n9, n10, n11);
        if (bl && (n7 = Math.max(n4, n3 - 2)) < (n6 = Math.min(n5, n3))) {
            styledFragmentsList.add("html-symbol-style", n7, n6);
        }
    }

    protected void renderPHPASPTag(StyledFragmentsList styledFragmentsList, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = Math.max(n4, n2);
        if (n7 < (n6 = Math.min(n5, n2 + 2))) {
            styledFragmentsList.add("html-symbol-style", n7, n6);
        }
        int n8 = n2 + 2;
        int n9 = n3;
        int n10 = Math.max(n4, n8);
        int n11 = Math.min(n5, n9);
        TextBuffer textBuffer = this.getTextBuffer();
        if (n8 < n9 && textBuffer.getChar(n8) == '=') {
            n7 = Math.max(n4, n8);
            if (n7 < (n6 = Math.min(n5, n8 + 1))) {
                styledFragmentsList.add("html-symbol-style", n7, n6);
            }
            n8 = n2 + 3;
            n10 = Math.max(n4, n8);
        }
        boolean bl = false;
        if (n9 - n8 >= 2) {
            int n12 = n9 - 2;
            char c = textBuffer.getChar(n12++);
            char c2 = textBuffer.getChar(n12);
            if (c == '%' && c2 == '>') {
                bl = true;
                n9 = n3 - 2;
                n11 = Math.min(n5, n9);
            }
        }
        this.phpRenderer.renderBlock(styledFragmentsList, n8, n9, n10, n11);
        if (bl && (n7 = Math.max(n4, n3 - 2)) < (n6 = Math.min(n5, n3))) {
            styledFragmentsList.add("html-symbol-style", n7, n6);
        }
    }
}

