/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.php;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.php.PHPBlockRenderer;
import oracle.javatools.editor.language.php.PHPLanguageSupport;
import oracle.javatools.editor.language.php.PHPStyles;
import oracle.javatools.editor.resource.BundleHelper;

public final class PHPLanguageModule
extends LanguageModule {
    private static final String[] supportedFileTypes = new String[]{"php", "php3", "php4"};

    public String getPresentationName() {
        BundleHelper bundleHelper = EditorProperties.getEditorBundle();
        return bundleHelper.getString("PHP_MODULE_NAME");
    }

    public String[] getStyleNames() {
        return PHPStyles.STYLE_NAMES;
    }

    public String getContentSample() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>\n");
        stringBuffer.append(" <head>\n");
        stringBuffer.append("  <title>PHP Hello World</title>\n");
        stringBuffer.append(" </head>\n");
        stringBuffer.append(" <body>\n");
        stringBuffer.append(" <?php echo \"<p>Hello World</p>\"; ?>\n");
        stringBuffer.append(" </body>\n");
        stringBuffer.append("</html>\n");
        return stringBuffer.toString();
    }

    public String[] getSupportedFileTypes() {
        return supportedFileTypes;
    }

    public void registerStyles(StyleRegistry styleRegistry) {
        new PHPStyles(styleRegistry);
    }

    public LanguageSupport createLanguageSupport() {
        return new PHPLanguageSupport();
    }

    public BlockRenderer createBlockRenderer(TextBuffer textBuffer) {
        return new PHPBlockRenderer(textBuffer);
    }
}

