/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.php;

import oracle.javatools.editor.language.php.PHPLanguage;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.generic.GenericLexer;
import oracle.javatools.parser.generic.Language;

public class PHPLexer
extends GenericLexer {
    static Language phpLanguage = new PHPLanguage();

    public PHPLexer() {
        this(phpLanguage);
    }

    protected PHPLexer(Language language) {
        super(language);
    }

    public int lex(LexerToken lexerToken) {
        if (this.useLastToken) {
            return super.lex(lexerToken);
        }
        int n = super.lex(lexerToken);
        switch (n) {
            case 19: {
                int n2 = this.textBuffer.getLength();
                int n3 = this.startOffset;
                if (n2 - n3 < 3 || this.textBuffer.getChar(n3++) != '<' || this.textBuffer.getChar(n3++) != '<' || this.textBuffer.getChar(n3) != '<') break;
                int n4 = this.startOffset + 3;
                int n5 = this.findIdentifierEnd(n4);
                if (n4 == n5) {
                    return n;
                }
                this.lastToken = 14;
                int n6 = n5 - n4;
                char c = this.textBuffer.getChar(n4);
                int n7 = n5;
                while (n7 < n2) {
                    char c2 = this.textBuffer.getChar(n7);
                    if (c2 == c && this.regionMatches(n4, n5, n7, n7 + n6) && this.isStartOfLine(n7) && this.isEndOfLine(n7 + n6)) {
                        this.endOffset = this.currentPos = n7 + n6;
                        return this.fillLexerToken(lexerToken);
                    }
                    ++n7;
                }
                this.endOffset = this.currentPos = n2;
                return this.fillLexerToken(lexerToken);
            }
        }
        return n;
    }

    private int findIdentifierEnd(int n) {
        int n2 = this.textBuffer.getLength();
        int n3 = n;
        while (n3 < n2) {
            char c = this.textBuffer.getChar(n3);
            if (!phpLanguage.isIdentifierCharacter(c)) {
                return n3;
            }
            ++n3;
        }
        return n2;
    }

    private boolean isStartOfLine(int n) {
        int n2 = this.textBuffer.getLength();
        if (n < 0 || n >= n2) {
            return false;
        }
        if (n == 0) {
            return true;
        }
        char c = this.textBuffer.getChar(n - 1);
        return c == '\n' || c == '\r';
    }

    private boolean isEndOfLine(int n) {
        int n2 = this.textBuffer.getLength();
        if (n < 0 || n > n2) {
            return false;
        }
        if (n == n2) {
            return true;
        }
        char c = this.textBuffer.getChar(n);
        if (c == '\n' || c == '\r') {
            return true;
        }
        if (c == ';') {
            return this.isEndOfLine(n + 1);
        }
        return false;
    }

    private boolean regionMatches(int n, int n2, int n3, int n4) {
        int n5 = this.textBuffer.getLength();
        if (n4 > n5 || n2 > n5) {
            return false;
        }
        int n6 = n2 - n;
        int n7 = n4 - n3;
        if (n6 != n7) {
            return false;
        }
        int n8 = 0;
        while (n8 < n6) {
            char c;
            char c2 = this.textBuffer.getChar(n + n8);
            if (c2 != (c = this.textBuffer.getChar(n3 + n8))) {
                return false;
            }
            ++n8;
        }
        return true;
    }
}

