/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.php;

import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.BuiltInStyles;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.resource.BundleHelper;

public final class PHPStyles {
    public static final String PHP_COMMENT_STYLE = "php-comment-style";
    public static final String PHP_KEYWORD_STYLE = "php-keyword-style";
    public static final String PHP_IDENTIFIER_STYLE = "php-identifier-style";
    public static final String PHP_STRING_STYLE = "php-string-style";
    public static final String PHP_NUMBER_STYLE = "php-number-style";
    public static final String PHP_BRACE_STYLE = "php-brace-style";
    public static final String PHP_OPERATOR_STYLE = "php-operator-style";
    public static final String[] STYLE_NAMES = new String[]{"php-comment-style", "php-keyword-style", "php-identifier-style", "php-string-style", "php-number-style", "php-brace-style", "php-operator-style"};
    public static BaseStyle phpPlainStyle;
    public static BaseStyle phpCommentStyle;
    public static BaseStyle phpKeywordStyle;
    public static BaseStyle phpIdentifierStyle;
    public static BaseStyle phpStringStyle;
    public static BaseStyle phpNumberStyle;
    public static BaseStyle phpBraceStyle;
    public static BaseStyle phpOperatorStyle;

    public PHPStyles(StyleRegistry styleRegistry) {
        this.reloadStyles(styleRegistry);
    }

    public void reloadStyles(StyleRegistry styleRegistry) {
        BundleHelper bundleHelper = EditorProperties.getEditorBundle();
        BuiltInStyles builtInStyles = new BuiltInStyles(styleRegistry);
        phpPlainStyle = builtInStyles.plainStyle;
        phpCommentStyle = styleRegistry.lookupStyle(PHP_COMMENT_STYLE);
        if (phpCommentStyle == null) {
            String string = bundleHelper.getString("PHP_COMMENT_STYLE");
            phpCommentStyle = styleRegistry.createStyle(PHP_COMMENT_STYLE, string, "base-comment-style");
        }
        if ((phpStringStyle = styleRegistry.lookupStyle(PHP_STRING_STYLE)) == null) {
            String string = bundleHelper.getString("PHP_STRING_STYLE");
            phpStringStyle = styleRegistry.createStyle(PHP_STRING_STYLE, string, "base-string-style");
        }
        if ((phpKeywordStyle = styleRegistry.lookupStyle(PHP_KEYWORD_STYLE)) == null) {
            String string = bundleHelper.getString("PHP_KEYWORD_STYLE");
            phpKeywordStyle = styleRegistry.createStyle(PHP_KEYWORD_STYLE, string, "base-keyword-style");
        }
        if ((phpIdentifierStyle = styleRegistry.lookupStyle(PHP_IDENTIFIER_STYLE)) == null) {
            String string = bundleHelper.getString("PHP_IDENTIFIER_STYLE");
            phpIdentifierStyle = styleRegistry.createStyle(PHP_IDENTIFIER_STYLE, string, "base-identifier-style");
        }
        if ((phpNumberStyle = styleRegistry.lookupStyle(PHP_NUMBER_STYLE)) == null) {
            String string = bundleHelper.getString("PHP_NUMBER_STYLE");
            phpNumberStyle = styleRegistry.createStyle(PHP_NUMBER_STYLE, string, "base-number-style");
        }
        if ((phpBraceStyle = styleRegistry.lookupStyle(PHP_BRACE_STYLE)) == null) {
            String string = bundleHelper.getString("PHP_BRACE_STYLE");
            phpBraceStyle = styleRegistry.createStyle(PHP_BRACE_STYLE, string, "base-brace-style");
        }
        if ((phpOperatorStyle = styleRegistry.lookupStyle(PHP_OPERATOR_STYLE)) == null) {
            String string = bundleHelper.getString("PHP_OPERATOR_STYLE");
            phpOperatorStyle = styleRegistry.createStyle(PHP_OPERATOR_STYLE, string, "base-operator-style");
        }
    }
}

