/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.properties;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.properties.PropertiesBlockRenderer;
import oracle.javatools.editor.language.properties.PropertiesLanguageSupport;
import oracle.javatools.editor.language.properties.PropertiesStyles;
import oracle.javatools.editor.resource.BundleHelper;

public final class PropertiesLanguageModule
extends LanguageModule {
    private static final String[] supportedFileTypes = new String[]{"properties", "rts"};

    public String getPresentationName() {
        BundleHelper bundleHelper = EditorProperties.getEditorBundle();
        return bundleHelper.getString("PROPERTIES_MODULE_NAME");
    }

    public String[] getStyleNames() {
        return PropertiesStyles.STYLE_NAMES;
    }

    public String getContentSample() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("# String resources for Java application\n");
        stringBuffer.append("\n");
        stringBuffer.append("# Title displayed in main application frame\n");
        stringBuffer.append("FRAME_TITLE = SmartCalendar\n");
        stringBuffer.append("\n");
        stringBuffer.append("# About box: company name\n");
        stringBuffer.append("ABOUT_BOX_COMPANY = SmartCalendar Corporation\n");
        stringBuffer.append("\n");
        stringBuffer.append("# About box: version number\n");
        stringBuffer.append("ABOUT_BOX_VERSION = 1.05\n");
        stringBuffer.append("\n");
        stringBuffer.append("# About box: copyright info\n");
        stringBuffer.append("ABOUT_BOX_COPYRIGHT = Copyright (c) 2001, ");
        stringBuffer.append("SmartCalendar Corporation.  \\\n");
        stringBuffer.append("All rights reserved.\n");
        return stringBuffer.toString();
    }

    public String[] getSupportedFileTypes() {
        return supportedFileTypes;
    }

    public void registerStyles(StyleRegistry styleRegistry) {
        new PropertiesStyles(styleRegistry);
    }

    public LanguageSupport createLanguageSupport() {
        return new PropertiesLanguageSupport();
    }

    public BlockRenderer createBlockRenderer(TextBuffer textBuffer) {
        return new PropertiesBlockRenderer(textBuffer);
    }
}

