/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.plugins;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.Timer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.plugins.EditorPlugin;

public abstract class AbstractClickPlugin
implements MouseMotionListener,
MouseListener,
ActionListener,
EditorPlugin {
    private Point _mousePoint;
    private int _actionType;
    private Timer _updateTimer;
    protected static final int ACTION_NONE = -1;
    protected static final int DEFAULT_DELAY_TIME = 150;
    protected static final int ALL_MODIFIER_MASK = 960;
    private BasicEditorPane _editor;
    private HighlightLayer _highlightLayer;

    public void install(BasicEditorPane basicEditorPane) {
        this._editor = basicEditorPane;
        this._editor.addMouseListener(this);
        this._editor.addMouseMotionListener(this);
        this._updateTimer = new Timer(this.getUpdateDelayTime(), this);
        this._updateTimer.setRepeats(false);
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        this._updateTimer.stop();
        this._updateTimer = null;
        this._editor.removeMouseListener(this);
        this._editor.removeMouseMotionListener(this);
        if (this._highlightLayer != null) {
            this._editor.destroyHighlightLayer(this._highlightLayer);
            this._highlightLayer = null;
        }
        this._editor = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            return;
        }
        int n = this.getActionTypeFor(mouseEvent);
        if (n != -1) {
            this.handleClickAction(mouseEvent.getPoint(), n);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.scheduleUpdate(null, -1);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.getActionTypeFor(mouseEvent);
        Point point = n == -1 ? null : mouseEvent.getPoint();
        this.scheduleUpdate(point, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleUpdate(Point point, int n) {
        AbstractClickPlugin abstractClickPlugin = this;
        synchronized (abstractClickPlugin) {
            this._mousePoint = point;
            this._actionType = n;
        }
        if (point == null) {
            this.updateHighlight(null, n);
        } else if (this._updateTimer != null) {
            this._updateTimer.restart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        Point point;
        AbstractClickPlugin abstractClickPlugin = this;
        synchronized (abstractClickPlugin) {
            point = this._mousePoint;
            n = this._actionType;
        }
        if (this._editor != null) {
            this.updateHighlight(point, n);
        }
    }

    protected abstract int getActionTypeFor(MouseEvent var1);

    protected abstract void handleClickAction(Point var1, int var2);

    protected abstract HighlightStyle getHighlightStyleFor(int var1);

    protected abstract String getHintTextFor(int var1);

    protected abstract NumberRange getRegionFor(int var1, int var2);

    protected int getUpdateDelayTime() {
        return 150;
    }

    protected boolean isActionTrigger(MouseEvent mouseEvent) {
        return this.getActionTypeFor(mouseEvent) != -1;
    }

    protected boolean hasModifierEx(MouseEvent mouseEvent, int n) {
        return (mouseEvent.getModifiersEx() & 0x3C0) == n;
    }

    protected TextBuffer getTextBuffer() {
        return this.getDocument().getTextBuffer();
    }

    protected BasicEditorPane getEditorPane() {
        return this._editor;
    }

    protected BasicDocument getDocument() {
        return (BasicDocument)this._editor.getDocument();
    }

    private HighlightLayer getHighlightLayer() {
        if (this._highlightLayer == null) {
            this._highlightLayer = this._editor.createHighlightLayer();
        }
        return this._highlightLayer;
    }

    protected void updateHighlight(Point point, int n) {
        HighlightLayer highlightLayer = this.getHighlightLayer();
        if (highlightLayer != null) {
            int n2;
            NumberRange numberRange;
            HighlightStyle highlightStyle;
            highlightLayer.removeAllHighlights();
            if (n != -1 && (highlightStyle = this.getHighlightStyleFor(n)) != null && point != null && (numberRange = this.getRegionFor(n2 = this._editor.viewToModel(point), n)) != null) {
                highlightLayer.addHighlight(highlightStyle, numberRange.start, numberRange.end);
            }
        }
        this.updateHint(n);
    }

    protected void updateHint(int n) {
        String string;
        boolean bl = false;
        if (n != -1 && (string = this.getHintTextFor(n)) != null) {
            this._editor.getFeedbackManager().showFeedback(this._editor, string);
            bl = true;
        }
        if (!bl) {
            this._editor.getFeedbackManager().hideFeedback(this._editor);
        }
    }
}

