/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.plugins;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.javatools.editor.ActionHookInvoker;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.language.BraceProvider;
import oracle.javatools.editor.language.ExtendedBraceProvider;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.resource.BundleHelper;

public final class BraceMatchingPlugin
implements EditorPlugin,
DocumentListener,
CaretListener,
ActionListener,
ActionHookInvoker {
    private static HighlightStyle braceMatchStyle1;
    private static HighlightStyle braceMatchStyle2;
    private static HighlightStyle nonMatchingStyle;
    private static HighlightStyle enclosingBlockStyle;
    private static HighlightStyle enclosingParenStyle;
    private HighlightLayer highlightLayer;
    private BasicEditorPane editor;
    private boolean doHighlighting = false;
    private boolean doBlocks;
    private boolean doParens;
    private NumberRange braceLocation;
    private NumberRange matchingLocation;
    private Timer delayedTimer = null;
    private static final int MATCHING_TIMER_DELAY = 300;
    public static final int DEFAULT_BRACE_PRIORITY = 80;
    public static final String HIGHLIGHT_BRACE_MATCH1 = "brace-match1-highlight";
    public static final String HIGHLIGHT_BRACE_MATCH2 = "brace-match2-highlight";
    public static final String HIGHLIGHT_BRACE_MISMATCH = "brace-mismatch-highlight";
    public static final String HIGHLIGHT_ENCLOSING_BLOCK = "enclosing-block-highlight";
    public static final String HIGHLIGHT_ENCLOSING_PARENS = "enclosing-parens-highlight";

    public void install(BasicEditorPane basicEditorPane) {
        this.editor = basicEditorPane;
        basicEditorPane.addActionHookInvoker(this);
        basicEditorPane.addCaretListener(this);
        Document document = basicEditorPane.getDocument();
        document.addDocumentListener(this);
        this.doHighlighting = false;
        this.updateEnabled();
        this.braceLocation = new NumberRange(0, 0);
        this.matchingLocation = new NumberRange(0, 0);
        this.delayedTimer = new Timer(300, this);
        this.delayedTimer.setRepeats(false);
        this.updateTimerDelay();
        this.scheduleMatch();
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        this.delayedTimer.stop();
        this.delayedTimer = null;
        basicEditorPane.removeCaretListener(this);
        basicEditorPane.removeActionHookInvoker(this);
        Document document = basicEditorPane.getDocument();
        if (document != null) {
            document.removeDocumentListener(this);
        }
        if (this.highlightLayer != null) {
            basicEditorPane.destroyHighlightLayer(this.highlightLayer);
            this.highlightLayer = null;
        }
        basicEditorPane = null;
        this.doHighlighting = false;
        this.braceLocation = null;
        this.matchingLocation = null;
    }

    protected void updateEnabled() {
        this.doHighlighting = this.editor.getBooleanProperty("brace-matching-auto");
        this.doBlocks = this.editor.getBooleanProperty("brace-matching-enclosing-blocks");
        this.doParens = this.editor.getBooleanProperty("brace-matching-enclosing-parens");
    }

    protected void updateTimerDelay() {
        int n = this.editor.getIntegerProperty("brace-matching-delay");
        this.delayedTimer.setInitialDelay(n);
        this.delayedTimer.setDelay(n);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        EditorProperties editorProperties = EditorProperties.getProperties();
        boolean bl = false;
        if (string.equals("language-support")) {
            bl = true;
        } else if (string.equals("brace-matching-auto")) {
            bl = true;
        } else if (string.equals("brace-matching-enclosing-blocks")) {
            bl = true;
        } else if (string.equals("brace-matching-enclosing-parens")) {
            bl = true;
        } else if (string.equals("brace-matching-delay")) {
            this.updateTimerDelay();
        } else if (string.equals("document")) {
            Object object;
            Object object2 = propertyChangeEvent.getOldValue();
            if (object2 instanceof Document) {
                Document document = (Document)object2;
                document.removeDocumentListener(this);
            }
            if ((object = propertyChangeEvent.getNewValue()) instanceof Document) {
                Document document = (Document)object;
                document.addDocumentListener(this);
            }
            bl = true;
        }
        if (bl) {
            this.updateEnabled();
            if (this.doHighlighting) {
                this.scheduleMatch();
            }
        }
    }

    public void caretUpdate(CaretEvent caretEvent) {
        this.scheduleMatch();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.scheduleMatch();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.scheduleMatch();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.scheduleMatch();
    }

    public boolean invokeAction(String string) {
        if (string.equals("show-matching-brace")) {
            this.performBraceHighlighting(true);
            return true;
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.editor == null) {
            return;
        }
        this.performBraceHighlighting(false);
    }

    static {
        EditorProperties editorProperties = EditorProperties.getProperties();
        HighlightRegistry highlightRegistry = editorProperties.getHighlightRegistry();
        BundleHelper bundleHelper = EditorProperties.getEditorBundle();
        String string = bundleHelper.getString("BRACE_MATCH1_HIGHLIGHT");
        braceMatchStyle1 = highlightRegistry.createStyle(HIGHLIGHT_BRACE_MATCH1, string, 80, Color.black, Color.yellow);
        string = bundleHelper.getString("BRACE_MATCH2_HIGHLIGHT");
        braceMatchStyle2 = highlightRegistry.createStyle(HIGHLIGHT_BRACE_MATCH2, string, 80, Color.black, Color.orange);
        string = bundleHelper.getString("BRACE_MISMATCH_HIGHLIGHT");
        nonMatchingStyle = highlightRegistry.createStyle(HIGHLIGHT_BRACE_MISMATCH, string, 80, Color.black, Color.red);
        string = "Brace Enclosing Parenthesis";
        enclosingParenStyle = highlightRegistry.createStyle(HIGHLIGHT_ENCLOSING_PARENS, string, 79, Color.black, new Color(214, 214, 255));
        string = "Brace Enclosing Block";
        enclosingBlockStyle = highlightRegistry.createStyle(HIGHLIGHT_ENCLOSING_BLOCK, string, 79, Color.black, new Color(239, 214, 255));
    }

    private void scheduleMatch() {
        if (this.doHighlighting) {
            this.delayedTimer.restart();
        }
    }

    private void clearHighlighting() {
        if (this.highlightLayer != null) {
            this.highlightLayer.removeAllHighlights();
        }
    }

    private void highlightLocation(HighlightStyle highlightStyle, NumberRange numberRange) {
        if (highlightStyle != null) {
            HighlightLayer highlightLayer = this.getHighlightLayer();
            highlightLayer.addHighlight(highlightStyle, numberRange.start, numberRange.end);
        }
    }

    private void highlightBraces(HighlightStyle highlightStyle, NumberRange numberRange, NumberRange numberRange2) {
        if (numberRange != null) {
            this.highlightLocation(highlightStyle, numberRange);
        }
        if (numberRange2 != null) {
            this.highlightLocation(highlightStyle, numberRange2);
        }
    }

    private boolean highlightBracesOnOffset(int n, BraceProvider braceProvider) {
        int n2;
        int n3;
        BasicDocument basicDocument = (BasicDocument)this.editor.getDocument();
        HighlightStyle highlightStyle = braceMatchStyle1;
        int n4 = -1;
        int n5 = -1;
        boolean bl = false;
        if (n > 0 && (n3 = braceProvider.isPartOfBrace(n - 1, this.braceLocation)) != -1) {
            n4 = this.braceLocation.start;
            bl = true;
            int n6 = braceProvider.findMatchingBrace(n3, this.braceLocation, this.matchingLocation);
            if (n6 == 1 || n6 == 2) {
                this.highlightBraces(highlightStyle, this.braceLocation, this.matchingLocation);
                highlightStyle = braceMatchStyle2;
                n5 = this.matchingLocation.start;
            } else {
                this.highlightBraces(nonMatchingStyle, this.braceLocation, null);
            }
        }
        if (n < basicDocument.getLength() && (n2 = braceProvider.isPartOfBrace(n, this.braceLocation)) != -1 && this.braceLocation.start != n4 && this.braceLocation.start != n5) {
            bl = true;
            int n7 = braceProvider.findMatchingBrace(n2, this.braceLocation, this.matchingLocation);
            if (n7 == 1 || n7 == 2) {
                this.highlightBraces(highlightStyle, this.braceLocation, this.matchingLocation);
            } else {
                this.highlightBraces(nonMatchingStyle, this.braceLocation, null);
            }
        }
        return bl;
    }

    private boolean highlightEnclosingBraces(int n, int n2, ExtendedBraceProvider extendedBraceProvider, HighlightStyle highlightStyle) {
        int n3 = n;
        while (n3 > 0) {
            int n4 = extendedBraceProvider.findClosestBrace(n3, this.braceLocation);
            if (n4 == -1) {
                return false;
            }
            int n5 = extendedBraceProvider.findMatchingBrace(n4, this.braceLocation, this.matchingLocation);
            if (extendedBraceProvider.isOpenBraceType(n4)) {
                int n6;
                if (n2 != -1 && n2 != (n6 = extendedBraceProvider.getBraceType(n4, this.braceLocation))) {
                    n3 = this.braceLocation.start;
                    continue;
                }
                if (n5 == 1 || n5 == 2) {
                    if (this.matchingLocation.start > n) {
                        this.highlightBraces(highlightStyle, this.braceLocation, this.matchingLocation);
                    }
                } else {
                    this.highlightBraces(nonMatchingStyle, this.braceLocation, null);
                }
                return true;
            }
            if (extendedBraceProvider.isCloseBraceType(n4)) {
                if (n5 == 1 || n5 == 2) {
                    n3 = this.matchingLocation.start;
                    continue;
                }
                return false;
            }
            System.out.println("Warning: unrecognized brace type: " + n4);
            return false;
        }
        return false;
    }

    private void performBraceHighlighting(boolean bl) {
        this.clearHighlighting();
        if (this.doHighlighting || bl) {
            if (this.editor == null || this.editor.getDocument() == null) {
                this.doHighlighting = false;
                return;
            }
            BasicDocument basicDocument = (BasicDocument)this.editor.getDocument();
            LanguageSupport languageSupport = basicDocument.getLanguageSupport();
            BraceProvider braceProvider = languageSupport.getBraceProvider();
            if (braceProvider == null) {
                this.doHighlighting = false;
                return;
            }
            basicDocument.readLock();
            try {
                int n = this.editor.getCaretPosition();
                this.highlightBracesOnOffset(n, braceProvider);
                if (braceProvider instanceof ExtendedBraceProvider) {
                    ExtendedBraceProvider extendedBraceProvider = (ExtendedBraceProvider)braceProvider;
                    if (this.doBlocks) {
                        this.highlightEnclosingBraces(n, 3, extendedBraceProvider, enclosingBlockStyle);
                    }
                    if (this.doParens) {
                        this.highlightEnclosingBraces(n, 1, extendedBraceProvider, enclosingParenStyle);
                    }
                }
            }
            finally {
                basicDocument.readUnlock();
            }
        }
    }

    private HighlightLayer getHighlightLayer() {
        if (this.highlightLayer == null) {
            this.highlightLayer = this.editor.createHighlightLayer();
        }
        return this.highlightLayer;
    }
}

