/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.plugins;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import oracle.javatools.editor.BasicCaret;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.plugins.DropTargetPlugin;
import oracle.javatools.editor.resource.BundleHelper;

public class DragDropPlugin
extends DropTargetPlugin
implements DragSourceListener,
DragGestureListener {
    protected Caret originalCaret;
    protected DragGestureRecognizer dragRecognizer;
    protected boolean selectionClicked;
    protected boolean queuedPopupTrigger;
    protected boolean dragInProgress;
    protected int dropOffset;
    protected static final EditDescriptor DRAG_DESCRIPTOR;
    protected static final EditDescriptor DRAGDROP_DESCRIPTOR;
    private static final boolean needsFocusWorkaround;
    private boolean skipDragGesture;
    protected boolean focusWasGained;
    protected static final DataFlavor OUR_FLAVOR;
    private static DataFlavor[] ourFlavors;

    public DragDropPlugin() {
        this.$init$();
    }

    public void install(BasicEditorPane basicEditorPane) {
        super.install(basicEditorPane);
        DragSource dragSource = DragSource.getDefaultDragSource();
        int n = 3;
        this.dragRecognizer = dragSource.createDefaultDragGestureRecognizer(basicEditorPane, n, this);
        this.installDragCaret();
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        this.deinstallDragCaret();
        this.dragRecognizer.setComponent(null);
        this.dragRecognizer = null;
        super.deinstall(basicEditorPane);
    }

    protected void installDragCaret() {
        Caret caret = this.editor.getCaret();
        DragCaret dragCaret = new DragCaret();
        this.exchangeCaret(caret, dragCaret);
        if (!(caret instanceof BasicCaret)) {
            this.originalCaret = caret;
        }
    }

    protected void deinstallDragCaret() {
        Caret caret = this.originalCaret == null ? (Caret)new BasicCaret() : this.originalCaret;
        Caret caret2 = this.editor.getCaret();
        try {
            this.exchangeCaret(caret2, caret);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.originalCaret = null;
    }

    protected void exchangeCaret(Caret caret, Caret caret2) {
        int n = caret.getBlinkRate();
        int n2 = caret.getDot();
        int n3 = caret.getMark();
        Point point = caret.getMagicCaretPosition();
        this.editor.setCaret(caret2);
        int n4 = this.editor.getDocument().getLength();
        n2 = Math.min(n2, n4);
        n3 = Math.min(n2, n4);
        caret2.setBlinkRate(n);
        caret2.setVisible(this.editor.hasFocus());
        caret2.setMagicCaretPosition(point);
        caret2.setDot(n3);
        caret2.moveDot(n2);
        if (caret instanceof BasicCaret && caret2 instanceof BasicCaret) {
            boolean bl = ((BasicCaret)caret).getInsertMode();
            ((BasicCaret)caret2).setInsertMode(bl);
        }
    }

    void $init$() {
        this.originalCaret = null;
        this.dragRecognizer = null;
        this.selectionClicked = false;
        this.queuedPopupTrigger = false;
        this.dragInProgress = false;
        this.dropOffset = -1;
        this.skipDragGesture = false;
        this.focusWasGained = false;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        if (!this.focusWasGained && this.selectionClicked && !this.skipDragGesture) {
            Point point = dragGestureEvent.getDragOrigin();
            int n = this.editor.viewToModel(point);
            if (this.editor.hasSelection() && this.editor.getSelectionStart() <= n && n < this.editor.getSelectionEnd()) {
                this.dragInProgress = true;
                this.dropOffset = -1;
                try {
                    DragTransferable dragTransferable = new DragTransferable();
                    dragGestureEvent.startDrag(DragSource.DefaultCopyNoDrop, dragTransferable, this);
                }
                catch (InvalidDnDOperationException invalidDnDOperationException) {
                    this.dragInProgress = false;
                }
            }
        }
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        this.handleDragEvent(dragSourceDragEvent);
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        this.handleDragEvent(dragSourceDragEvent);
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        this.handleDragEvent(dragSourceDragEvent);
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
        this.cancelDragEvent(dragSourceEvent);
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this.handleDropEvent(dragSourceDropEvent);
    }

    protected void handleDragEvent(DragSourceDragEvent dragSourceDragEvent) {
        int n = dragSourceDragEvent.getDropAction();
        this.updateDragCursor(dragSourceDragEvent, n);
    }

    protected void cancelDragEvent(DragSourceEvent dragSourceEvent) {
        this.updateDragCursor(dragSourceEvent, 0);
    }

    protected void handleDropEvent(DragSourceDropEvent dragSourceDropEvent) {
        boolean bl = dragSourceDropEvent.getDropSuccess();
        if (bl) {
            int n = dragSourceDropEvent.getDropAction();
            if (this.dropOffset == -1) {
                if (n == 2) {
                    this.editor.beginEdit(DRAG_DESCRIPTOR);
                    try {
                        this.removeSelectedText();
                    }
                    finally {
                        this.editor.endEdit();
                    }
                }
            } else {
                this.editor.beginEdit(DRAGDROP_DESCRIPTOR);
                try {
                    try {
                        Transferable transferable = dragSourceDropEvent.getDragSourceContext().getTransferable();
                        String string = transferable.getTransferData(DropTargetPlugin.STRING_FLAVOR).toString();
                        if (n == 2) {
                            this.removeSelectedText();
                            int n2 = this.editor.getCaretPosition();
                            if (n2 < this.dropOffset) {
                                this.dropOffset -= string.length();
                                if (this.dropOffset < 0) {
                                    throw new IllegalStateException("negative drop");
                                }
                            }
                        }
                        BasicDocument basicDocument = this.getDocument();
                        basicDocument.insertString(this.dropOffset, string, null);
                        this.editor.setCaretPosition(this.dropOffset + string.length());
                    }
                    catch (BadLocationException badLocationException) {
                    }
                    catch (IOException iOException) {
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {}
                }
                finally {
                    this.editor.endEdit();
                }
            }
        }
        this.selectionClicked = false;
        this.queuedPopupTrigger = false;
        this.dragInProgress = false;
        this.dropOffset = -1;
    }

    protected void removeSelectedText() {
        try {
            int n = this.editor.getSelectionStart();
            int n2 = this.editor.getSelectionEnd();
            BasicDocument basicDocument = this.getDocument();
            basicDocument.remove(n, n2 - n);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    protected void handleDropEvent(DropTargetDropEvent dropTargetDropEvent) {
        int n = dropTargetDropEvent.getDropAction();
        if (this.editor.isEditable() && this.isDropActionSupported(n) && dropTargetDropEvent.isDataFlavorSupported(OUR_FLAVOR)) {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            try {
                DragTransferable dragTransferable = (DragTransferable)transferable.getTransferData(OUR_FLAVOR);
                if (this.editor == dragTransferable.getEditorPane()) {
                    this.clearDropLocation();
                    dropTargetDropEvent.acceptDrop(n);
                    Point point = dropTargetDropEvent.getLocation();
                    this.dropOffset = this.editor.viewToModel(point);
                    int n2 = this.editor.getSelectionStart();
                    int n3 = this.editor.getSelectionEnd();
                    boolean bl = n2 <= this.dropOffset && this.dropOffset <= n3;
                    dropTargetDropEvent.dropComplete(bl ^ true);
                    return;
                }
            }
            catch (IOException iOException) {
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                // empty catch block
            }
        }
        super.handleDropEvent(dropTargetDropEvent);
    }

    protected void updateDragCursor(DragSourceEvent dragSourceEvent, int n) {
        Cursor cursor = null;
        switch (n) {
            case 1: {
                cursor = DragSource.DefaultCopyDrop;
                break;
            }
            case 2: {
                cursor = DragSource.DefaultMoveDrop;
                break;
            }
            case 0: {
                cursor = DragSource.DefaultCopyNoDrop;
                break;
            }
        }
        dragSourceEvent.getDragSourceContext().setCursor(cursor);
    }

    static {
        BundleHelper bundleHelper = EditorProperties.getEditorBundle();
        String string = bundleHelper.getString("UNDO_DRAG_OPERATION");
        DRAG_DESCRIPTOR = new EditDescriptor(string);
        string = bundleHelper.getString("UNDO_DRAG_DROP_OPERATION");
        DRAGDROP_DESCRIPTOR = new EditDescriptor(string);
        String string2 = System.getProperty("java.version");
        needsFocusWorkaround = string2 != null && (string2.startsWith("1.3") || string2.startsWith("1.2"));
        OUR_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref; class=" + DragTransferable.class.getName(), "Editor Text");
        ourFlavors = null;
    }

    static boolean ra$skipDragGesture(DragDropPlugin dragDropPlugin) {
        return dragDropPlugin.skipDragGesture;
    }

    static void wa$skipDragGesture(DragDropPlugin dragDropPlugin, boolean bl) {
        dragDropPlugin.skipDragGesture = bl;
    }

    static boolean ra$needsFocusWorkaround() {
        return needsFocusWorkaround;
    }

    static DataFlavor[] ra$ourFlavors() {
        return ourFlavors;
    }

    static void wa$ourFlavors(DataFlavor[] dataFlavorArray) {
        ourFlavors = dataFlavorArray;
    }

    protected class DragCaret
    extends BasicCaret {
        public void focusGained(FocusEvent focusEvent) {
            super.focusGained(focusEvent);
            if (DragDropPlugin.ra$needsFocusWorkaround()) {
                DragDropPlugin.this.focusWasGained = true;
                if (DragDropPlugin.this.selectionClicked) {
                    DragDropPlugin.wa$skipDragGesture(DragDropPlugin.this, true);
                    DragDropPlugin.this.selectionClicked = false;
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (DragDropPlugin.this.dragInProgress || DragDropPlugin.this.selectionClicked) {
                return;
            }
            super.mouseClicked(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (DragDropPlugin.this.dragInProgress || DragDropPlugin.this.selectionClicked) {
                return;
            }
            super.mouseDragged(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            DragDropPlugin.this.queuedPopupTrigger = false;
            if (DragDropPlugin.this.dragInProgress) {
                return;
            }
            if (mouseEvent.getClickCount() > 1) {
                super.mousePressed(mouseEvent);
                return;
            }
            if (DragDropPlugin.this.focusWasGained) {
                super.mousePressed(mouseEvent);
                return;
            }
            int n = this.getOffsetForMouseEvent(mouseEvent);
            if (this.offsetInSelection(n)) {
                DragDropPlugin.this.selectionClicked = true;
                DragDropPlugin.this.queuedPopupTrigger = mouseEvent.isPopupTrigger();
            } else {
                super.mousePressed(mouseEvent);
            }
        }

        protected boolean offsetInSelection(int n) {
            int n2;
            int n3 = Math.min(this.getDot(), this.getMark());
            return n3 != (n2 = Math.max(this.getDot(), this.getMark())) && n3 <= n && n < n2;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (DragDropPlugin.this.dragInProgress) {
                return;
            }
            if (DragDropPlugin.this.selectionClicked || DragDropPlugin.ra$skipDragGesture(DragDropPlugin.this)) {
                DragDropPlugin.this.selectionClicked = false;
                DragDropPlugin.wa$skipDragGesture(DragDropPlugin.this, false);
                MouseEvent mouseEvent2 = new MouseEvent((Component)mouseEvent.getSource(), 501, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), DragDropPlugin.this.queuedPopupTrigger, mouseEvent.getButton());
                super.mousePressed(mouseEvent2);
                DragDropPlugin.this.queuedPopupTrigger = false;
            }
            DragDropPlugin.this.focusWasGained = false;
            super.mouseReleased(mouseEvent);
        }

        public boolean isVisible() {
            return !DragDropPlugin.this.dragInProgress && super.isVisible();
        }

        protected DragCaret() {
        }
    }

    protected class DragTransferable
    implements Transferable {
        private String data;

        protected DragTransferable() {
            this.data = DragDropPlugin.this.editor.getSelectedText();
        }

        public DataFlavor[] getTransferDataFlavors() {
            if (DragDropPlugin.ra$ourFlavors() == null) {
                DragDropPlugin.wa$ourFlavors(new DataFlavor[]{OUR_FLAVOR, DropTargetPlugin.STRING_FLAVOR});
            }
            return DragDropPlugin.ra$ourFlavors();
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor.equals(OUR_FLAVOR) || dataFlavor.equals(DropTargetPlugin.STRING_FLAVOR);
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (dataFlavor.equals(OUR_FLAVOR)) {
                return this;
            }
            if (dataFlavor.equals(DropTargetPlugin.STRING_FLAVOR)) {
                return this.data;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        protected BasicEditorPane getEditorPane() {
            return DragDropPlugin.this.editor;
        }
    }
}

