/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.plugins;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.io.Reader;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.resource.BundleHelper;

public class DropTargetPlugin
implements EditorPlugin,
DropTargetListener {
    protected BasicEditorPane editor;
    protected DropTarget dropTarget;
    protected Rectangle lastDropRect;
    protected static final int DROP_RECT_WIDTH = 1;
    protected static final DataFlavor STRING_FLAVOR = DataFlavor.stringFlavor;
    protected static final DataFlavor PLAIN_FLAVOR = DataFlavor.getTextPlainUnicodeFlavor();
    private static DataFlavor[] supportedFlavors = new DataFlavor[]{STRING_FLAVOR, PLAIN_FLAVOR};
    protected static final EditDescriptor DROP_DESCRIPTOR;

    public DropTargetPlugin() {
        this.$init$();
        this.dropTarget = new DropTarget(null, 3, this);
    }

    public void install(BasicEditorPane basicEditorPane) {
        this.editor = basicEditorPane;
        this.dropTarget.setComponent(basicEditorPane);
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        this.dropTarget.setComponent(null);
        this.editor = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.handleDragEvent(dropTargetDragEvent);
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.handleDragEvent(dropTargetDragEvent);
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        this.handleDragEvent(dropTargetDragEvent);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.cancelDragEvent(dropTargetEvent);
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.handleDropEvent(dropTargetDropEvent);
    }

    protected BasicDocument getDocument() {
        return (BasicDocument)this.editor.getDocument();
    }

    protected Rectangle getDropRectangle(Point point) {
        int n = this.editor.viewToModel(point);
        Rectangle rectangle = null;
        try {
            rectangle = this.editor.modelToView(n);
        }
        catch (BadLocationException badLocationException) {
            rectangle = null;
        }
        return rectangle;
    }

    void $init$() {
        this.lastDropRect = null;
    }

    static {
        BundleHelper bundleHelper = EditorProperties.getEditorBundle();
        String string = bundleHelper.getString("UNDO_DROP_OPERATION");
        DROP_DESCRIPTOR = new EditDescriptor(string);
    }

    protected void clearDropLocation() {
        if (SwingUtilities.isEventDispatchThread() && this.lastDropRect != null) {
            Graphics graphics = this.editor.getGraphics();
            this.editor.paintImmediately(this.lastDropRect.x, this.lastDropRect.y, 2, this.lastDropRect.height);
            this.lastDropRect = null;
        }
    }

    protected void paintDropLocation(Point point) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.clearDropLocation();
            this.lastDropRect = this.getDropRectangle(point);
            if (this.lastDropRect != null) {
                Graphics graphics = this.editor.getGraphics();
                EditorProperties editorProperties = EditorProperties.getProperties();
                Color color = (Color)editorProperties.getProperty("caret-color");
                graphics.setColor(color);
                graphics.drawRect(this.lastDropRect.x, this.lastDropRect.y, 1, this.lastDropRect.height - 1);
            }
        }
    }

    protected void cancelDragEvent(DropTargetEvent dropTargetEvent) {
        this.clearDropLocation();
    }

    protected void handleDropEvent(DropTargetDropEvent dropTargetDropEvent) {
        this.clearDropLocation();
        int n = dropTargetDropEvent.getDropAction();
        if (this.editor.isEditable() && this.isDropActionSupported(n) && this.isDataFlavorSupported(dropTargetDropEvent)) {
            dropTargetDropEvent.acceptDrop(n);
            Transferable transferable = dropTargetDropEvent.getTransferable();
            String string = this.getTransferText(transferable);
            boolean bl = false;
            if (string != null && string.length() > 0) {
                Point point = dropTargetDropEvent.getLocation();
                int n2 = this.editor.viewToModel(point);
                this.editor.beginEdit(DROP_DESCRIPTOR);
                try {
                    try {
                        BasicDocument basicDocument = this.getDocument();
                        basicDocument.insertString(n2, string, null);
                        bl = true;
                        Window window = SwingUtilities.getWindowAncestor(this.editor);
                        if (window != null) {
                            window.toFront();
                        }
                        this.editor.setCaretPosition(n2 + string.length());
                        this.editor.requestFocus();
                    }
                    catch (BadLocationException badLocationException) {}
                }
                finally {
                    this.editor.endEdit();
                }
            }
            dropTargetDropEvent.dropComplete(bl);
            return;
        }
        dropTargetDropEvent.rejectDrop();
    }

    protected String getTransferText(Transferable transferable) {
        String string = null;
        DataFlavor dataFlavor = this.getPreferredDataFlavor(transferable);
        if (dataFlavor == STRING_FLAVOR) {
            try {
                string = transferable.getTransferData(dataFlavor).toString();
            }
            catch (IOException iOException) {
                string = null;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                string = null;
            }
        } else if (dataFlavor == PLAIN_FLAVOR) {
            Reader reader = null;
            try {
                try {
                    reader = PLAIN_FLAVOR.getReaderForText(transferable);
                    if (reader != null) {
                        TextBuffer textBuffer = TextBufferFactory.createTextBuffer();
                        textBuffer.read(reader);
                        string = textBuffer.getString(0, textBuffer.getLength());
                    }
                }
                catch (IOException iOException) {
                    string = null;
                }
                catch (NullPointerException nullPointerException) {
                    string = null;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    string = null;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    string = null;
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return string;
    }

    protected DataFlavor getPreferredDataFlavor(Transferable transferable) {
        DataFlavor[] dataFlavorArray = this.getSupportedFlavors();
        int n = dataFlavorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataFlavor dataFlavor = dataFlavorArray[n2];
            if (transferable.isDataFlavorSupported(dataFlavor)) {
                return dataFlavor;
            }
            ++n2;
        }
        return null;
    }

    protected void handleDragEvent(DropTargetDragEvent dropTargetDragEvent) {
        this.paintDropLocation(dropTargetDragEvent.getLocation());
        int n = dropTargetDragEvent.getDropAction();
        if (this.editor.isEditable() && this.isDropActionSupported(n) && this.isDataFlavorSupported(dropTargetDragEvent)) {
            dropTargetDragEvent.acceptDrag(n);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    protected boolean isDropActionSupported(int n) {
        return (n & 3) != 0;
    }

    protected boolean isDataFlavorSupported(DropTargetDragEvent dropTargetDragEvent) {
        DataFlavor[] dataFlavorArray = this.getSupportedFlavors();
        int n = dataFlavorArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (dropTargetDragEvent.isDataFlavorSupported(dataFlavorArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean isDataFlavorSupported(DropTargetDropEvent dropTargetDropEvent) {
        DataFlavor[] dataFlavorArray = this.getSupportedFlavors();
        int n = dataFlavorArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (dropTargetDropEvent.isDataFlavorSupported(dataFlavorArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected DataFlavor[] getSupportedFlavors() {
        return supportedFlavors;
    }
}

