/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.plugins;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.Utilities;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.HighlightedText;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.resource.BundleHelper;

public final class FindHighlightPlugin
implements DocumentListener,
EditorPlugin {
    private static final boolean FORWARD = true;
    private static final boolean BACKWARDS = false;
    private static final boolean IGNORE_CASE = true;
    private static HighlightStyle findStyle;
    private HighlightLayer highlightLayer = null;
    private BasicEditorPane editor = null;
    private String lastSearchText = null;
    private boolean lastMatchCase = false;
    private boolean lastWholeWordOnly = false;
    private ArrayList offsetList = new ArrayList();
    private ArrayList highlightList = new ArrayList();
    private ArrayList tempOffsetList = new ArrayList();
    private ArrayList tempHighlightList = new ArrayList();
    public static final int DEFAULT_FIND_PRIORITY = 60;
    public static final String HIGHLIGHT_FIND_RESULT = "find-results-highlight";

    static {
        EditorProperties editorProperties = EditorProperties.getProperties();
        HighlightRegistry highlightRegistry = editorProperties.getHighlightRegistry();
        BundleHelper bundleHelper = EditorProperties.getEditorBundle();
        String string = bundleHelper.getString("FIND_OCCURRENCE_HIGHLIGHT");
        findStyle = highlightRegistry.createStyle(HIGHLIGHT_FIND_RESULT, string, 60, Color.black, new Color(200, 180, 220));
    }

    public void install(BasicEditorPane basicEditorPane) {
        this.editor = basicEditorPane;
        Document document = basicEditorPane.getDocument();
        document.addDocumentListener(this);
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        Document document = basicEditorPane.getDocument();
        if (document != null) {
            document.removeDocumentListener(this);
        }
        if (this.highlightLayer != null) {
            basicEditorPane.destroyHighlightLayer(this.highlightLayer);
            this.highlightLayer = null;
        }
        basicEditorPane = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("document")) {
            Object object;
            Object object2 = propertyChangeEvent.getOldValue();
            if (object2 instanceof Document) {
                Document document = (Document)object2;
                document.removeDocumentListener(this);
            }
            if ((object = propertyChangeEvent.getNewValue()) instanceof Document) {
                Document document = (Document)object;
                document.addDocumentListener(this);
                if (this.highlightLayer != null) {
                    this.highlightLayer.removeAllHighlights();
                }
                this.highlightList.clear();
                this.offsetList.clear();
                if (this.lastSearchText != null) {
                    this.updateFindRegion(0, document.getLength());
                }
            }
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent.getOffset(), documentEvent.getLength());
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.removeUpdate(documentEvent.getOffset(), documentEvent.getLength());
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public int findText(String string, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return this.findText(string, n, bl, bl2, bl3, false, bl4);
    }

    public int findText(String string, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        if (bl5) {
            boolean bl6 = false;
            if (this.lastSearchText == null) {
                bl6 = true;
            } else if (!string.equals(this.lastSearchText) || bl2 != this.lastMatchCase || bl4 != this.lastWholeWordOnly) {
                bl6 = true;
            }
            if (bl6) {
                this.clearFindHighlighting();
                this.performFindHighlighting(string, bl2, bl4);
            }
            int n2 = -1;
            int n3 = this.offsetList.size();
            if (bl) {
                int n4 = 0;
                while (n4 < n3) {
                    int n5 = (Integer)this.offsetList.get(n4);
                    if (n5 >= n) {
                        n2 = n5;
                        break;
                    }
                    ++n4;
                }
                if (bl3 && n2 == -1) {
                    int n6 = 0;
                    while (n6 < n3) {
                        int n7 = (Integer)this.offsetList.get(n6);
                        if (n7 < n) {
                            n2 = n7;
                            break;
                        }
                        ++n6;
                    }
                }
            } else {
                int n8 = string.length();
                int n9 = n3 - 1;
                while (n9 >= 0) {
                    int n10 = (Integer)this.offsetList.get(n9);
                    if (n10 + n8 <= n) {
                        n2 = n10;
                        break;
                    }
                    --n9;
                }
                if (bl3 && n2 == -1) {
                    int n11 = n3 - 1;
                    while (n11 >= 0) {
                        int n12 = (Integer)this.offsetList.get(n11);
                        if (n12 + n8 > n) {
                            n2 = n12;
                            break;
                        }
                        --n11;
                    }
                }
            }
            return n2;
        }
        this.clearFindHighlighting();
        Document document = this.editor.getDocument();
        int n13 = -1;
        if (bl) {
            n13 = this.findTextInternal(string, true, bl2, bl4, n, document.getLength());
            if (bl3 && n13 == -1) {
                n13 = this.findTextInternal(string, true, bl2, bl4, 0, n);
            }
        } else {
            n13 = this.findTextInternal(string, false, bl2, bl4, 0, n);
            if (bl3 && n13 == -1) {
                n13 = this.findTextInternal(string, false, bl2, bl4, n, document.getLength());
            }
        }
        return n13;
    }

    public void clearFindHighlighting() {
        if (this.highlightLayer != null) {
            this.highlightLayer.removeAllHighlights();
        }
        this.lastSearchText = null;
        this.offsetList.clear();
        this.highlightList.clear();
    }

    public boolean hasFindHighlighting() {
        return this.lastSearchText != null;
    }

    public boolean getFirstHighlightAfter(int n, int[] nArray) {
        int n2 = Collections.binarySearch(this.offsetList, new Integer(n));
        if (n2 < 0) {
            n2 = -n2 - 1;
        }
        while (n2 < this.offsetList.size()) {
            Integer n3 = (Integer)this.offsetList.get(n2);
            int n4 = n3;
            if (n4 > n) {
                HighlightedText highlightedText = (HighlightedText)this.highlightList.get(n2);
                nArray[0] = n4;
                nArray[1] = highlightedText.getEndOffset();
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean getFirstHighlightBefore(int n, int[] nArray) {
        int n2 = Collections.binarySearch(this.offsetList, new Integer(n));
        if (n2 < 0) {
            n2 = -n2 - 1;
        }
        while (--n2 >= 0) {
            Integer n3 = (Integer)this.offsetList.get(n2);
            int n4 = n3;
            if (n4 >= n) continue;
            HighlightedText highlightedText = (HighlightedText)this.highlightList.get(n2);
            nArray[0] = n4;
            nArray[1] = highlightedText.getEndOffset();
            return true;
        }
        return false;
    }

    private void performFindHighlighting(String string, boolean bl, boolean bl2) {
        if (string == null) {
            return;
        }
        if (this.editor == null || this.editor.getDocument() == null) {
            return;
        }
        this.lastSearchText = string;
        this.lastMatchCase = bl;
        this.lastWholeWordOnly = bl2;
        BasicDocument basicDocument = (BasicDocument)this.editor.getDocument();
        ReadTextBuffer readTextBuffer = basicDocument.getTextBuffer();
        basicDocument.readLock();
        try {
            this.updateFindRegion(0, basicDocument.getLength());
        }
        finally {
            basicDocument.readUnlock();
        }
    }

    private void insertUpdate(int n, int n2) {
        if (this.lastSearchText != null) {
            HighlightLayer highlightLayer = this.getHighlightLayer();
            Document document = this.editor.getDocument();
            int n3 = this.lastSearchText.length();
            int n4 = Math.max(0, n - n3);
            int n5 = n;
            int n6 = this.offsetList.size();
            int n7 = -1;
            int n8 = -1;
            boolean bl = false;
            boolean bl2 = true;
            int n9 = 2;
            int n10 = 0;
            int n11 = 0;
            while (n11 < n6) {
                int n12 = (Integer)this.offsetList.get(n11);
                switch (n10) {
                    case 0: {
                        if (n12 < n4) break;
                        n7 = n11;
                        n10 = 1;
                        n8 = n6;
                    }
                    case 1: {
                        if (n12 <= n5) {
                            HighlightedText highlightedText = (HighlightedText)this.highlightList.get(n11);
                            highlightLayer.removeHighlight(highlightedText);
                            break;
                        }
                        n8 = n11;
                        n10 = 2;
                    }
                    case 2: {
                        this.offsetList.set(n11, new Integer(n12 += n2));
                    }
                }
                ++n11;
            }
            if (n7 != n8) {
                int n13 = n8 - n7;
                int n14 = 0;
                while (n14 < n13) {
                    this.offsetList.remove(n7);
                    this.highlightList.remove(n7);
                    ++n14;
                }
            }
            int n15 = n4;
            int n16 = Math.min(n + n2 + n3, document.getLength());
            this.updateFindRegion(n15, n16);
        }
    }

    private void removeUpdate(int n, int n2) {
        if (this.lastSearchText != null) {
            HighlightLayer highlightLayer = this.getHighlightLayer();
            Document document = this.editor.getDocument();
            int n3 = this.lastSearchText.length();
            int n4 = Math.max(0, n - n3);
            int n5 = Math.min(document.getLength(), n + n2);
            int n6 = this.offsetList.size();
            int n7 = -1;
            int n8 = -1;
            boolean bl = false;
            boolean bl2 = true;
            int n9 = 2;
            int n10 = 0;
            int n11 = 0;
            while (n11 < n6) {
                int n12 = (Integer)this.offsetList.get(n11);
                switch (n10) {
                    case 0: {
                        if (n12 < n4) break;
                        n7 = n11;
                        n10 = 1;
                        n8 = n6;
                    }
                    case 1: {
                        if (n12 <= n5) {
                            HighlightedText highlightedText = (HighlightedText)this.highlightList.get(n11);
                            highlightLayer.removeHighlight(highlightedText);
                            break;
                        }
                        n8 = n11;
                        n10 = 2;
                    }
                    case 2: {
                        this.offsetList.set(n11, new Integer(n12 -= n2));
                    }
                }
                ++n11;
            }
            if (n7 != n8) {
                int n13 = n8 - n7;
                int n14 = 0;
                while (n14 < n13) {
                    this.offsetList.remove(n7);
                    this.highlightList.remove(n7);
                    ++n14;
                }
            }
            int n15 = n4;
            int n16 = Math.min(n + n3, document.getLength());
            this.updateFindRegion(n15, n16);
        }
    }

    private void updateFindRegion(int n, int n2) {
        int n3;
        if (this.lastSearchText == null) {
            return;
        }
        int n4 = n3 = this.offsetList.size();
        int n5 = 0;
        while (n5 < n3) {
            int n6 = (Integer)this.offsetList.get(n5);
            if (n6 > n) {
                n4 = n5;
                break;
            }
            ++n5;
        }
        HighlightLayer highlightLayer = this.getHighlightLayer();
        int n7 = this.lastSearchText.length();
        highlightLayer.beginBlockUpdate();
        try {
            int n8 = n;
            while (n8 < n2) {
                int n9 = this.findTextInternal(this.lastSearchText, true, this.lastMatchCase, this.lastWholeWordOnly, n8, n2);
                if (n9 == -1) {
                    break;
                }
                HighlightedText highlightedText = highlightLayer.addHighlight(findStyle, n9, n9 + n7);
                this.tempOffsetList.add(new Integer(n9));
                this.tempHighlightList.add(highlightedText);
                n8 = n9 + 1;
            }
        }
        finally {
            highlightLayer.endBlockUpdate();
        }
        if (this.tempOffsetList.size() > 0) {
            this.offsetList.addAll(n4, this.tempOffsetList);
            this.highlightList.addAll(n4, this.tempHighlightList);
        }
        this.tempOffsetList.clear();
        this.tempHighlightList.clear();
    }

    private int findTextInternal(String string, boolean bl, boolean bl2, boolean bl3, int n, int n2) {
        int n3;
        BasicDocument basicDocument = (BasicDocument)this.editor.getDocument();
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        while (true) {
            n3 = -1;
            n3 = bl2 ? (bl ? this.searchForwardMatch(string, textBuffer, n, n2) : this.searchBackwardMatch(string, textBuffer, n, n2)) : (bl ? this.searchForwardNoMatch(string, textBuffer, n, n2) : this.searchBackwardNoMatch(string, textBuffer, n, n2));
            if (n3 == -1 || !bl3 || this.isWholeWordMatch(basicDocument, n3, string.length())) break;
            if (bl) {
                n = n3 + 1;
                continue;
            }
            n2 = n3 - 1;
        }
        return n3;
    }

    private boolean isWholeWordMatch(BasicDocument basicDocument, int n, int n2) {
        int n3 = n + n2;
        int n4 = Utilities.getWordStart(basicDocument, n);
        int n5 = Utilities.getWordEnd(basicDocument, n3 - 1);
        return n4 == n && n5 == n3;
    }

    private int searchForwardMatch(String string, ReadTextBuffer readTextBuffer, int n, int n2) {
        int n3 = string.length();
        int n4 = n2 - n3;
        block0: for (int i = n; i <= n4; ++i) {
            int n5 = 0;
            int n6 = i;
            int n7 = i + n3;
            while (n6 < n7) {
                char c;
                char c2;
                if ((c2 = readTextBuffer.getChar(n6++)) == (c = string.charAt(n5++))) continue;
                continue block0;
            }
            return i;
        }
        return -1;
    }

    private int searchBackwardMatch(String string, ReadTextBuffer readTextBuffer, int n, int n2) {
        int n3 = string.length();
        block0: for (int i = n2 - n3; i >= n; --i) {
            int n4 = 0;
            int n5 = i;
            int n6 = i + n3;
            while (n5 < n6) {
                char c;
                char c2;
                if ((c2 = readTextBuffer.getChar(n5++)) == (c = string.charAt(n4++))) continue;
                continue block0;
            }
            return i;
        }
        return -1;
    }

    private int searchForwardNoMatch(String string, ReadTextBuffer readTextBuffer, int n, int n2) {
        int n3 = string.length();
        int n4 = n2 - n3;
        block0: for (int i = n; i <= n4; ++i) {
            int n5 = 0;
            int n6 = i;
            int n7 = i + n3;
            while (n6 < n7) {
                char c;
                char c2;
                char c3;
                char c4;
                char c5;
                char c6;
                if ((c6 = readTextBuffer.getChar(n6++)) == (c5 = string.charAt(n5++)) || (c4 = Character.toUpperCase(c6)) == (c3 = Character.toUpperCase(c5)) || (c2 = Character.toLowerCase(c4)) == (c = Character.toLowerCase(c3))) continue;
                continue block0;
            }
            return i;
        }
        return -1;
    }

    private int searchBackwardNoMatch(String string, ReadTextBuffer readTextBuffer, int n, int n2) {
        int n3 = string.length();
        block0: for (int i = n2 - n3; i >= n; --i) {
            int n4 = 0;
            int n5 = i;
            int n6 = i + n3;
            while (n5 < n6) {
                char c;
                char c2;
                char c3;
                char c4;
                char c5;
                char c6;
                if ((c6 = readTextBuffer.getChar(n5++)) == (c5 = string.charAt(n4++)) || (c4 = Character.toUpperCase(c6)) == (c3 = Character.toUpperCase(c5)) || (c2 = Character.toLowerCase(c4)) == (c = Character.toLowerCase(c3))) continue;
                continue block0;
            }
            return i;
        }
        return -1;
    }

    private HighlightLayer getHighlightLayer() {
        if (this.highlightLayer == null) {
            this.highlightLayer = this.editor.createHighlightLayer();
        }
        return this.highlightLayer;
    }
}

