/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.plugins;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.HighlightedText;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.resource.BundleHelper;

public final class LineHighlightPlugin
implements EditorPlugin,
DocumentListener,
CaretListener {
    private BasicEditorPane editor;
    private HighlightedText lineHighlight;
    private HighlightLayer highlightLayer;
    public static final int DEFAULT_LINE_PRIORITY = 10;
    public static final String CARET_LINE_HIGHLIGHT = "caret-line-highlight";
    private static final HighlightStyle highlightStyle;

    public LineHighlightPlugin() {
        this.$init$();
    }

    public void install(BasicEditorPane basicEditorPane) {
        this.editor = basicEditorPane;
        basicEditorPane.addCaretListener(this);
        Document document = basicEditorPane.getDocument();
        document.addDocumentListener(this);
        this.updateHighlight();
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        this.removeHighlightLayer();
        basicEditorPane.removeCaretListener(this);
        this.editor = null;
        Document document = basicEditorPane.getDocument();
        if (document != null) {
            document.removeDocumentListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("document")) {
            Object object;
            this.clearHighlight();
            Object object2 = propertyChangeEvent.getOldValue();
            if (object2 instanceof Document) {
                Document document = (Document)object2;
                document.removeDocumentListener(this);
            }
            if ((object = propertyChangeEvent.getNewValue()) instanceof Document) {
                Document document = (Document)object;
                document.addDocumentListener(this);
            }
            this.updateHighlight();
        }
    }

    public void caretUpdate(CaretEvent caretEvent) {
        this.updateHighlight();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateHighlight();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateHighlight();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    void $init$() {
        this.lineHighlight = null;
        this.highlightLayer = null;
    }

    private BasicDocument getDocument() {
        return (BasicDocument)this.editor.getDocument();
    }

    private synchronized void removeHighlightLayer() {
        if (this.highlightLayer != null) {
            this.editor.destroyHighlightLayer(this.highlightLayer);
            this.highlightLayer = null;
            this.lineHighlight = null;
        }
    }

    private synchronized HighlightLayer getHighlightLayer() {
        if (this.highlightLayer == null) {
            this.highlightLayer = this.editor.createHighlightLayer();
        }
        return this.highlightLayer;
    }

    private synchronized void clearHighlight() {
        if (this.highlightLayer != null) {
            this.highlightLayer.removeAllHighlights();
        }
        this.lineHighlight = null;
    }

    private synchronized void updateHighlight() {
        BasicDocument basicDocument = this.getDocument();
        if (basicDocument != null) {
            basicDocument.readLock();
            try {
                LineMap lineMap = basicDocument.getLineMap();
                int n = this.editor.getCaretPosition();
                int n2 = lineMap.getLineFromOffset(n);
                HighlightLayer highlightLayer = this.getHighlightLayer();
                if (this.lineHighlight == null) {
                    this.lineHighlight = highlightLayer.addLineHighlight(highlightStyle, n2);
                } else {
                    int n3 = lineMap.getLineStartOffset(n2);
                    int n4 = lineMap.getLineEndOffset(n2);
                    if (this.lineHighlight.getStartOffset() != n3 || this.lineHighlight.getEndOffset() != n4) {
                        highlightLayer.changeHighlight(this.lineHighlight, n3, n4);
                    }
                }
            }
            finally {
                basicDocument.readUnlock();
            }
        }
    }

    static {
        EditorProperties editorProperties = EditorProperties.getProperties();
        HighlightRegistry highlightRegistry = editorProperties.getHighlightRegistry();
        BundleHelper bundleHelper = EditorProperties.getEditorBundle();
        String string = bundleHelper.getString("CARET_LINE_HIGHLIGHT");
        highlightStyle = highlightRegistry.createStyle(CARET_LINE_HIGHLIGHT, string, true, 10, null, Color.lightGray);
    }
}

