/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.plugins;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Caret;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicCaret;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.FeedbackManager;
import oracle.javatools.editor.Utilities;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.resource.BundleHelper;

public final class StatusBarPlugin
implements FeedbackManager,
EditorPlugin,
ChangeListener,
ActionListener {
    private BasicEditorPane editor = null;
    private JPanel mainPanel;
    private StatusBarCell feedbackCell;
    private StatusBarCell insertOverwriteCell;
    private StatusBarCell lineNumberCell;
    private StatusBarCell eolTypeCell;
    private StatusBarCell modifiedCell;
    private Timer feedbackTimer;
    private Timer caretTimer;
    private static final int CARET_TIMER_DELAY = 100;
    private int lastOffset;
    private int lastId;
    private static char[] digitArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final Border EMPTY_PIXEL_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    public static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder(0, 3, 0, 3);
    public static final Border ETCHED_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), EMPTY_BORDER);
    public static final Border BEVEL_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), EMPTY_BORDER);
    public static final String BLANK_MESSAGE = " ";
    public static final String INSERT_MODE;
    public static final String OVERWRITE_MODE;
    public static final String LINE_COLUMN;
    public static final String EOL_MACINTOSH;
    public static final String EOL_UNIX;
    public static final String EOL_WINDOWS;
    public static final String MODIFIED;
    public static final String READ_ONLY;
    public static final String PROTECTED;
    public static final String[] INSERT_OVERWRITE_CELL_STRINGS;
    public static final String[] EOL_CELL_STRINGS;
    public static final String[] MODIFIED_CELL_STRINGS;
    public static final String[] LINE_NUMBER_CELL_STRINGS;
    private static final StringBuffer scratchBuffer;

    public StatusBarPlugin() {
        this(ETCHED_BORDER, null);
    }

    public StatusBarPlugin(Font font) {
        this(ETCHED_BORDER, font);
    }

    public StatusBarPlugin(Border border) {
        this(border, null);
    }

    public StatusBarPlugin(Border border, Font font) {
        this.createPanel(border, font);
    }

    public void install(BasicEditorPane basicEditorPane) {
        this.lastOffset = -1;
        this.lastId = -1;
        this.editor = basicEditorPane;
        basicEditorPane.addFeedbackManager(this);
        Caret caret = basicEditorPane.getCaret();
        caret.addChangeListener(this);
        this.feedbackTimer = new Timer(5000, this);
        this.feedbackTimer.setRepeats(false);
        this.caretTimer = new Timer(100, this);
        this.caretTimer.setRepeats(false);
        this.updateAllCells();
        StatusBarUpdater.mav$registerStatusBar(StatusBarUpdater.maS$getUpdater(), this);
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        StatusBarUpdater.mav$unregisterStatusBar(StatusBarUpdater.maS$getUpdater(), this);
        this.feedbackTimer.stop();
        this.feedbackTimer = null;
        this.caretTimer.stop();
        this.caretTimer = null;
        Caret caret = basicEditorPane.getCaret();
        if (caret != null) {
            caret.removeChangeListener(this);
        }
        basicEditorPane.removeFeedbackManager(this);
        basicEditorPane = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        boolean bl = false;
        if (string.equals("caret")) {
            Object object;
            Object object2 = propertyChangeEvent.getOldValue();
            if (object2 instanceof Caret) {
                Caret caret = (Caret)object2;
                caret.removeChangeListener(this);
            }
            if ((object = propertyChangeEvent.getNewValue()) instanceof Caret) {
                Caret caret = (Caret)object;
                caret.addChangeListener(this);
            }
            bl = true;
        } else if (string.equals("tab-size")) {
            bl = true;
        }
        if (bl) {
            this.lastOffset = -1;
            this.lastId = -1;
            this.updateAllCells();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (!this.caretTimer.isRunning()) {
            this.caretTimer.restart();
        }
    }

    public void showFeedback(BasicEditorPane basicEditorPane, String string) {
        this.feedbackTimer.stop();
        this.feedbackCell.setText(string);
    }

    public void showFeedback(BasicEditorPane basicEditorPane, String string, int n) {
        this.feedbackTimer.stop();
        this.feedbackTimer.setInitialDelay(n);
        this.feedbackTimer.setDelay(n);
        this.feedbackTimer.start();
        this.feedbackCell.setText(string);
    }

    public void hideFeedback(BasicEditorPane basicEditorPane) {
        this.feedbackTimer.stop();
        this.feedbackCell.setText(BLANK_MESSAGE);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.feedbackTimer) {
            this.feedbackCell.setText(BLANK_MESSAGE);
        } else if (object == this.caretTimer) {
            this.updateAllCells();
        }
    }

    static {
        BundleHelper bundleHelper = EditorProperties.getEditorBundle();
        INSERT_MODE = bundleHelper.getString("STATUS_INSERT");
        OVERWRITE_MODE = bundleHelper.getString("STATUS_OVERWRITE");
        LINE_COLUMN = bundleHelper.getString("STATUS_LINE_COLUMN");
        EOL_MACINTOSH = bundleHelper.getString("STATUS_EOL_MAC");
        EOL_UNIX = bundleHelper.getString("STATUS_EOL_UNIX");
        EOL_WINDOWS = bundleHelper.getString("STATUS_EOL_WINDOWS");
        MODIFIED = bundleHelper.getString("STATUS_MODIFIED");
        READ_ONLY = bundleHelper.getString("STATUS_READONLY");
        PROTECTED = bundleHelper.getString("STATUS_PROTECTED");
        scratchBuffer = new StringBuffer();
        INSERT_OVERWRITE_CELL_STRINGS = new String[]{INSERT_MODE, OVERWRITE_MODE, READ_ONLY, PROTECTED};
        EOL_CELL_STRINGS = new String[]{EOL_MACINTOSH, EOL_UNIX, EOL_WINDOWS};
        MODIFIED_CELL_STRINGS = new String[]{MODIFIED};
        LINE_NUMBER_CELL_STRINGS = new String[]{StatusBarPlugin.getLineColumnText(LINE_COLUMN, 1234, 123)};
    }

    public JPanel getPanel() {
        return this.mainPanel;
    }

    private void createPanel(Border border, Font font) {
        this.feedbackCell = new StatusBarCell("Feedback", border, null);
        this.feedbackCell.setText(BLANK_MESSAGE);
        this.insertOverwriteCell = new StatusBarCell("Insert", border, INSERT_OVERWRITE_CELL_STRINGS);
        this.insertOverwriteCell.setHorizontalAlignment(2);
        this.eolTypeCell = new StatusBarCell("EOL", border, EOL_CELL_STRINGS);
        this.eolTypeCell.setHorizontalAlignment(2);
        this.modifiedCell = new StatusBarCell("Modified", border, MODIFIED_CELL_STRINGS);
        this.modifiedCell.setHorizontalAlignment(2);
        this.lineNumberCell = new StatusBarCell("LineCol", border, LINE_NUMBER_CELL_STRINGS);
        this.lineNumberCell.setHorizontalAlignment(2);
        if (font != null) {
            this.feedbackCell.setFont(font);
            this.insertOverwriteCell.setFont(font);
            this.lineNumberCell.setFont(font);
            this.eolTypeCell.setFont(font);
            this.modifiedCell.setFont(font);
        }
        Insets insets = new Insets(1, 1, 1, 1);
        this.mainPanel = new JPanel(new GridBagLayout());
        this.mainPanel.setBorder(EMPTY_PIXEL_BORDER);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 1, insets, 0, 0);
        this.mainPanel.add((Component)this.lineNumberCell, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 17, 1, insets, 0, 0);
        this.mainPanel.add((Component)this.insertOverwriteCell, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 1, insets, 0, 0);
        this.mainPanel.add((Component)this.feedbackCell, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(3, 0, 1, 1, 0.0, 1.0, 17, 1, insets, 0, 0);
        this.mainPanel.add((Component)this.modifiedCell, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(4, 0, 1, 1, 0.0, 1.0, 17, 1, insets, 0, 0);
        this.mainPanel.add((Component)this.eolTypeCell, gridBagConstraints);
    }

    private int getTabSize() {
        Integer n = (Integer)this.editor.getProperty("tab-size");
        int n2 = n != null ? n : 8;
        return n2;
    }

    private void updateAllCells() {
        this.updateCaretCell();
        this.updateOtherCells();
    }

    private void updateCaretCell() {
        if (this.editor != null) {
            String string = BLANK_MESSAGE;
            BasicDocument basicDocument = (BasicDocument)this.editor.getDocument();
            TextBuffer textBuffer = basicDocument.getTextBuffer();
            int n = 0;
            int n2 = 0;
            basicDocument.readLock();
            try {
                int n3 = this.editor.getCaretPosition();
                if (n3 == this.lastOffset && textBuffer.getChangeId() == this.lastId) {
                    basicDocument.readUnlock();
                    return;
                }
                this.lastOffset = n3;
                this.lastId = textBuffer.getChangeId();
                LineMap lineMap = basicDocument.getLineMap();
                n = lineMap.getLineFromOffset(n3);
                int n4 = this.getTabSize();
                n2 = Utilities.getColumnFromOffset(textBuffer, n, n3, n4);
            }
            finally {
                basicDocument.readUnlock();
            }
            string = StatusBarPlugin.getLineColumnText(LINE_COLUMN, ++n, ++n2);
            this.lineNumberCell.setText(string);
        }
    }

    private void appendNumber(StringBuffer stringBuffer, int n) {
        if (n < 10) {
            stringBuffer.append(digitArray[n]);
            return;
        }
        int n2 = StatusBarPlugin.numDigits(n);
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append(' ');
            ++n3;
        }
        int n4 = n;
        int n5 = stringBuffer.length() + n2 - 1;
        while (n2-- > 0) {
            int n6 = n4 % 10;
            n4 /= 10;
            stringBuffer.setCharAt(n5--, digitArray[n6]);
        }
    }

    private static int numDigits(int n) {
        if (n < 100) {
            return n < 10 ? 1 : 2;
        }
        if (n < 10000) {
            return n < 1000 ? 3 : 4;
        }
        int n2 = 0;
        do {
            ++n2;
        } while ((n /= 10) != 0);
        return n2;
    }

    private void updateOtherCells() {
        if (this.editor != null) {
            String string;
            String string2;
            String string3;
            BasicCaret basicCaret;
            boolean bl;
            Caret caret;
            String string4 = BLANK_MESSAGE;
            String string5 = BLANK_MESSAGE;
            String string6 = BLANK_MESSAGE;
            BasicDocument basicDocument = (BasicDocument)this.editor.getDocument();
            TextBuffer textBuffer = basicDocument.getTextBuffer();
            boolean bl2 = textBuffer.isReadOnly();
            boolean bl3 = this.editor.isProtected();
            string4 = bl2 ? READ_ONLY : (bl3 ? PROTECTED : ((caret = this.editor.getCaret()) != null && caret instanceof BasicCaret ? ((bl = (basicCaret = (BasicCaret)caret).getInsertMode()) ? INSERT_MODE : OVERWRITE_MODE) : INSERT_MODE));
            String string7 = textBuffer.getEOLType();
            string6 = string7 == "\r\n" ? EOL_WINDOWS : (string7 == "\n" ? EOL_UNIX : EOL_MACINTOSH);
            if (textBuffer.isModified()) {
                string5 = MODIFIED;
            }
            if ((string3 = this.insertOverwriteCell.getText()) != string4) {
                this.insertOverwriteCell.setText(string4);
            }
            if ((string2 = this.eolTypeCell.getText()) != string6) {
                this.eolTypeCell.setText(string6);
            }
            if ((string = this.modifiedCell.getText()) != string5) {
                this.modifiedCell.setText(string5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getLineColumnText(String string, int n, int n2) {
        String string2;
        StringBuffer stringBuffer = scratchBuffer;
        synchronized (stringBuffer) {
            scratchBuffer.delete(0, scratchBuffer.length());
            scratchBuffer.append(LINE_COLUMN);
            int n3 = LINE_COLUMN.indexOf("{0}");
            int n4 = LINE_COLUMN.indexOf("{1}");
            if (n3 < n4) {
                if (n4 != -1) {
                    scratchBuffer.replace(n4, n4 + 3, Integer.toString(n2));
                }
                if (n3 != -1) {
                    scratchBuffer.replace(n3, n3 + 3, Integer.toString(n));
                }
            } else {
                if (n3 != -1) {
                    scratchBuffer.replace(n3, n3 + 3, Integer.toString(n));
                }
                if (n4 != -1) {
                    scratchBuffer.replace(n4, n4 + 3, Integer.toString(n2));
                }
            }
            string2 = scratchBuffer.toString();
        }
        return string2;
    }

    static void mav$updateAllCells(StatusBarPlugin statusBarPlugin) {
        statusBarPlugin.updateAllCells();
    }

    protected static class StatusBarCell
    extends JLabel {
        private String[] cellStrings;
        private int minimumHeight = 0;
        private int minimumWidth = 0;
        private int preferredWidth = 0;

        protected StatusBarCell(String string, Border border, String[] stringArray) {
            this.cellStrings = stringArray;
            this.setName(string);
            this.setBorder(border);
        }

        protected void updateSize() {
            Font font = this.getFont();
            if (font != null) {
                FontMetrics fontMetrics = this.getFontMetrics(font);
                int n = fontMetrics.stringWidth(this.getText());
                if (this.cellStrings != null) {
                    int n2 = this.cellStrings.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        n = Math.max(n, fontMetrics.stringWidth(this.cellStrings[n3]));
                        ++n3;
                    }
                }
                int n4 = fontMetrics.getHeight();
                int n5 = 0;
                int n6 = 0;
                Border border = this.getBorder();
                if (border != null) {
                    Insets insets = border.getBorderInsets(this);
                    n5 = insets.top + insets.bottom;
                    n6 = insets.left + insets.right;
                }
                this.minimumHeight = n4 + n5;
                this.minimumWidth = n + n6;
                this.preferredWidth = this.minimumWidth + fontMetrics.charWidth('m');
            }
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.minimumWidth, this.minimumHeight);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.preferredWidth, this.minimumHeight);
        }

        public void setFont(Font font) {
            super.setFont(font);
            this.updateSize();
        }

        public void setBorder(Border border) {
            super.setBorder(border);
            this.updateSize();
        }
    }

    private static final class StatusBarUpdater
    implements ActionListener {
        private static final StatusBarUpdater singleton = new StatusBarUpdater();
        private static final int UPDATE_DELAY = 1000;
        private List statusbarList = new ArrayList();
        private Timer updateTimer = new Timer(1000, this);

        private static StatusBarUpdater getUpdater() {
            return singleton;
        }

        private StatusBarUpdater() {
            this.updateTimer.setRepeats(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerStatusBar(StatusBarPlugin statusBarPlugin) {
            List list = this.statusbarList;
            synchronized (list) {
                WeakReference<StatusBarPlugin> weakReference = new WeakReference<StatusBarPlugin>(statusBarPlugin);
                this.statusbarList.add(weakReference);
            }
            this.updateTimer.restart();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unregisterStatusBar(StatusBarPlugin statusBarPlugin) {
            List list = this.statusbarList;
            synchronized (list) {
                int n = this.statusbarList.size();
                int n2 = 0;
                while (n2 < n) {
                    WeakReference weakReference;
                    Object e = this.statusbarList.get(n2);
                    if (e != null && (weakReference = (WeakReference)e).get() == statusBarPlugin) {
                        weakReference.clear();
                        this.statusbarList.set(n2, null);
                        break;
                    }
                    ++n2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            List list = this.statusbarList;
            synchronized (list) {
                int n = this.statusbarList.size();
                int n2 = n - 1;
                while (n2 >= 0) {
                    WeakReference weakReference;
                    Object e = this.statusbarList.get(n2);
                    if (e != null && (weakReference = (WeakReference)e).get() != null) {
                        StatusBarPlugin statusBarPlugin = (StatusBarPlugin)weakReference.get();
                        StatusBarPlugin.mav$updateAllCells(statusBarPlugin);
                    } else {
                        this.statusbarList.remove(n2);
                    }
                    --n2;
                }
                if (this.statusbarList.size() == 0) {
                    this.updateTimer.stop();
                }
            }
        }

        static StatusBarUpdater maS$getUpdater() {
            return StatusBarUpdater.getUpdater();
        }

        static void mav$unregisterStatusBar(StatusBarUpdater statusBarUpdater, StatusBarPlugin statusBarPlugin) {
            statusBarUpdater.unregisterStatusBar(statusBarPlugin);
        }

        static void mav$registerStatusBar(StatusBarUpdater statusBarUpdater, StatusBarPlugin statusBarPlugin) {
            statusBarUpdater.registerStatusBar(statusBarPlugin);
        }
    }
}

