/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.plugins;

import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.FontHelper;
import oracle.javatools.editor.plugins.EditorPlugin;

public class TrailingSpacePlugin
implements HierarchyListener,
ChangeListener,
EditorPlugin {
    private BasicEditorPane _editor;
    private int _oldHeight;
    private int _oldWidth;
    private JViewport _viewport;

    public void install(BasicEditorPane basicEditorPane) {
        this._oldHeight = -1;
        this._oldWidth = -1;
        this._editor = basicEditorPane;
        this._editor.addHierarchyListener(this);
        this.updateViewportTracking();
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        this._oldHeight = -1;
        this._oldWidth = -1;
        this._editor.removeHierarchyListener(this);
        this.clearViewportTracking();
        this._editor = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.updateTrailingCount();
    }

    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        this.updateViewportTracking();
    }

    void $init$() {
        this._oldHeight = -1;
        this._oldWidth = -1;
    }

    protected BasicEditorPane getEditorPane() {
        return this._editor;
    }

    protected int calculateTrailingRows(int n) {
        FontHelper fontHelper = this._editor.getFontHelper();
        FontMetrics fontMetrics = fontHelper.getFontMetrics(0, (Component)this._editor);
        int n2 = fontMetrics.getHeight();
        int n3 = (int)((double)n * 0.95);
        int n4 = n3 / n2 - 1;
        return Math.max(1, n4);
    }

    protected int calculateTrailingColumns(int n) {
        FontHelper fontHelper = this._editor.getFontHelper();
        FontMetrics fontMetrics = fontHelper.getFontMetrics(0, (Component)this._editor);
        int n2 = fontMetrics.charWidth('m');
        int n3 = (int)((double)n * 0.1);
        int n4 = n3 / n2 - 1;
        return Math.max(1, n4);
    }

    private void updateTrailingCount() {
        if (this._viewport != null && this._editor != null) {
            int n = this._viewport.getHeight();
            int n2 = this._viewport.getWidth();
            if (this._oldHeight != n) {
                int n3 = this.calculateTrailingRows(n);
                this._editor.putIntegerProperty("trailing-blank-rows", n3);
                this._oldHeight = n;
            }
            if (this._oldWidth != n2) {
                int n4 = this.calculateTrailingColumns(n2);
                this._editor.putIntegerProperty("trailing-blank-columns", n4);
                this._oldWidth = n2;
            }
        }
    }

    private void updateViewportTracking() {
        Container container;
        if (this._editor != null && (container = this._editor.getParent()) != this._viewport) {
            this.clearViewportTracking();
            if (container instanceof JViewport) {
                this._viewport = (JViewport)container;
                if (this._viewport != null) {
                    this._viewport.addChangeListener(this);
                    this.updateTrailingCount();
                }
            }
        }
    }

    private void clearViewportTracking() {
        if (this._viewport != null) {
            this._viewport.removeChangeListener(this);
            this._viewport = null;
            this._oldHeight = -1;
            this._oldWidth = -1;
        }
    }

    public TrailingSpacePlugin() {
        this.$init$();
    }
}

