/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.popup;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.popup.PopupWindow;
import oracle.javatools.editor.popup.PopupWindowListener;

public class PopupWindowManager
implements FocusListener,
EditorPlugin {
    private static final String PWM_KEY = "**PWM_KEY**";
    private BasicEditorPane editorPane;
    private List popupList;
    public static final int WEST = 1;
    public static final int EAST = 2;
    public static final int NORTH = 4;
    public static final int SOUTH = 8;
    private static final int SPACING = 5;
    private int[] LOCATION_COUNT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PopupWindowManager getPopupWindowManager(BasicEditorPane basicEditorPane) {
        String string = PWM_KEY;
        synchronized (PWM_KEY) {
            PopupWindowManager popupWindowManager = (PopupWindowManager)basicEditorPane.getProperty(PWM_KEY);
            if (popupWindowManager == null) {
                popupWindowManager = new PopupWindowManager();
                basicEditorPane.installPlugin(popupWindowManager);
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return popupWindowManager;
        }
    }

    private PopupWindowManager() {
        this.$init$();
    }

    protected BasicEditorPane getEditorPane() {
        return this.editorPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(BasicEditorPane basicEditorPane) {
        String string = PWM_KEY;
        synchronized (PWM_KEY) {
            basicEditorPane.putProperty(PWM_KEY, this);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            basicEditorPane.addFocusListener(this);
            this.editorPane = basicEditorPane;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deinstall(BasicEditorPane basicEditorPane) {
        PopupWindow[] popupWindowArray = this.getPopupWindows();
        int n = popupWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            PopupWindow popupWindow = popupWindowArray[n2];
            this.dismissPopup(popupWindow);
            popupWindow.listener.popupClosed(popupWindow, 2);
            popupWindow.listener = null;
            ++n2;
        }
        String string = PWM_KEY;
        synchronized (PWM_KEY) {
            basicEditorPane.putProperty(PWM_KEY, null);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            basicEditorPane.removeFocusListener(this);
            this.editorPane = null;
            return;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public PopupWindow createPopup(Component component, boolean bl) {
        BasicEditorPane basicEditorPane = this.getEditorPane();
        Window window = SwingUtilities.getWindowAncestor(basicEditorPane);
        JWindow jWindow = new JWindow(window);
        Dimension dimension = component.getPreferredSize();
        jWindow.getContentPane().add(component);
        jWindow.setSize(dimension);
        jWindow.validate();
        PopupWindow popupWindow = new PopupWindow(component, jWindow, bl);
        this.setFocusable(jWindow, bl);
        return popupWindow;
    }

    protected void setFocusable(JWindow jWindow, boolean bl) {
        try {
            Method method;
            Class<?> clazz = jWindow.getClass();
            if (clazz != null && (method = clazz.getMethod("setFocusableWindowState", Boolean.TYPE)) != null) {
                method.invoke((Object)jWindow, new Boolean(bl));
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showPopup(PopupWindow popupWindow, PopupWindowListener popupWindowListener) {
        List list = this.popupList;
        synchronized (list) {
            popupWindow.listener = popupWindowListener;
            popupWindow.visible = true;
            this.popupList.add(popupWindow);
        }
        popupWindow.window.setVisible(true);
        this.transferFocusToEditor();
    }

    void $init$() {
        this.popupList = new ArrayList();
        this.LOCATION_COUNT = new int[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4};
    }

    public void positionPopup(PopupWindow popupWindow, Rectangle rectangle, int[] nArray) {
        Rectangle rectangle2 = this.convertToAbsolute(rectangle);
        Point point = new Point(rectangle2.x, rectangle2.y);
        Object[] objectArray = this.getScreenInfo(point);
        Rectangle rectangle3 = (Rectangle)objectArray[0];
        Dimension dimension = (Dimension)objectArray[1];
        Insets insets = (Insets)objectArray[2];
        insets.top += 5;
        insets.left += 5;
        insets.right += 5;
        insets.bottom += 5;
        rectangle2 = this.ensureOnScreen(rectangle3, insets, rectangle2);
        JWindow jWindow = popupWindow.window;
        Dimension dimension2 = new Dimension(jWindow.getWidth(), jWindow.getHeight());
        int[] nArray2 = this.getAvailableLocations(rectangle3, insets, dimension2, rectangle2, nArray);
        int n = nArray2[0];
        Point point2 = this.calculateLocation(rectangle3, insets, rectangle2, dimension2, n);
        PopupWindow popupWindow2 = popupWindow.visible ? popupWindow : null;
        Point point3 = this.adjustForCollisions(popupWindow2, rectangle3, insets, point2, dimension2, n);
        jWindow.setLocation(point3);
    }

    public void changePopupContent(PopupWindow popupWindow, Component component, boolean bl) {
        Component component2 = popupWindow.content;
        JWindow jWindow = popupWindow.window;
        jWindow.getContentPane().remove(component2);
        popupWindow.content = component;
        popupWindow.focusable = bl;
        jWindow.getContentPane().add(component);
        this.setFocusable(jWindow, bl);
        Dimension dimension = component.getPreferredSize();
        jWindow.setSize(dimension);
        jWindow.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dismissPopup(PopupWindow popupWindow) {
        List list = this.popupList;
        synchronized (list) {
            this.popupList.remove(popupWindow);
        }
        JWindow jWindow = popupWindow.window;
        if (jWindow != null) {
            jWindow.dispose();
            popupWindow.window = null;
            popupWindow.visible = false;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        PopupWindow[] popupWindowArray = this.getPopupWindows();
        int n = popupWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            PopupWindow popupWindow = popupWindowArray[n2];
            popupWindow.listener.editorFocusGained(popupWindow);
            ++n2;
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        boolean bl = focusEvent.isTemporary();
        PopupWindow[] popupWindowArray = this.getPopupWindows();
        int n = popupWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            PopupWindow popupWindow = popupWindowArray[n2];
            popupWindow.listener.editorFocusLost(popupWindow, bl);
            ++n2;
        }
    }

    private int[] getAvailableLocations(Rectangle rectangle, Insets insets, Dimension dimension, Rectangle rectangle2, int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = 0;
        while (n4 < n3) {
            n2 |= nArray[n4];
            ++n4;
        }
        if ((n2 & 0xC) != 0) {
            int n5;
            int n6;
            int n7 = dimension.height;
            int n8 = 5;
            boolean bl = true;
            int n9 = rectangle.y + insets.top;
            int n10 = rectangle.y + rectangle.height - insets.bottom;
            int n11 = rectangle2.y - n9 - n7;
            if (n11 >= 0) {
                n |= 4;
                bl = false;
            }
            if ((n6 = n10 - (n5 = rectangle2.y + rectangle2.height) - n7) >= 0) {
                n |= 8;
                bl = false;
            }
            if (bl) {
                n |= n6 > n11 ? 4 : 8;
            }
        }
        if ((n2 & 3) != 0) {
            int n12;
            int n13;
            int n14 = dimension.width;
            boolean bl = true;
            int n15 = rectangle.x + insets.left;
            int n16 = rectangle.x + rectangle.width - insets.right;
            int n17 = rectangle2.x - n15 - n14;
            if (n17 >= 0) {
                n |= 1;
                bl = false;
            }
            if ((n13 = n16 - (n12 = rectangle2.x + rectangle2.width) - n14) >= 0) {
                n |= 2;
                bl = false;
            }
            if (bl) {
                n |= n13 > n17 ? 2 : 1;
            }
        }
        int n18 = this.LOCATION_COUNT[n];
        int n19 = 0;
        int[] nArray2 = new int[n18];
        int n20 = 0;
        while (n20 < n3) {
            if ((nArray[n20] & n) != 0) {
                nArray2[n19++] = nArray[n20];
            }
            ++n20;
        }
        return nArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PopupWindow[] getPopupWindows() {
        PopupWindow[] popupWindowArray;
        List list = this.popupList;
        synchronized (list) {
            popupWindowArray = this.popupList.toArray(new PopupWindow[this.popupList.size()]);
        }
        return popupWindowArray;
    }

    private Point adjustForCollisions(PopupWindow popupWindow, Rectangle rectangle, Insets insets, Point point, Dimension dimension, int n) {
        Rectangle rectangle2 = new Rectangle(point, dimension);
        PopupWindow[] popupWindowArray = this.getPopupWindows();
        PopupWindow[] popupWindowArray2 = this.findPopupsInRegion(popupWindow, rectangle2, n, popupWindowArray);
        PopupWindow[] popupWindowArray3 = this.findCollidingPopups(rectangle2, popupWindowArray2);
        if (popupWindowArray3.length > 0) {
            int n2 = popupWindowArray3.length;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n3 + 1;
                PopupWindow[] popupWindowArray4 = new PopupWindow[n4];
                System.arraycopy(popupWindowArray3, 0, popupWindowArray4, 0, n4);
                Rectangle rectangle3 = this.getPopupSpace(popupWindowArray4);
                Point point2 = this.avoidCollision(rectangle3, rectangle, insets, point, dimension, n);
                if (point2 == null) break;
                Rectangle rectangle4 = new Rectangle(point2, dimension);
                if (this.findCollidingPopups(rectangle4, popupWindowArray2).length == 0) {
                    return point2;
                }
                ++n3;
            }
        }
        return point;
    }

    private Point avoidCollision(Rectangle rectangle, Rectangle rectangle2, Insets insets, Point point, Dimension dimension, int n) {
        int[] nArray;
        int n2 = rectangle2.x + insets.left;
        int n3 = rectangle2.y + insets.top;
        int n4 = rectangle2.x + rectangle2.width - insets.right;
        int n5 = rectangle2.y + rectangle2.height - insets.bottom;
        int n6 = rectangle.y - n3 - 5;
        int n7 = n5 - (rectangle.y + rectangle.height) - 5;
        int n8 = rectangle.x - n2 - 5;
        int n9 = n4 - (rectangle.x + rectangle.width) - 5;
        int n10 = dimension.width;
        int n11 = dimension.height;
        switch (n) {
            case 4: {
                nArray = new int[]{2, 1, 4};
                break;
            }
            case 8: {
                nArray = new int[]{2, 1, 8};
                break;
            }
            case 1: {
                nArray = new int[]{4, 8, 1};
                break;
            }
            case 2: {
                nArray = new int[]{4, 8, 2};
                break;
            }
            default: {
                throw new IllegalStateException("unknown loc: " + n);
            }
        }
        int n12 = nArray.length;
        int n13 = 0;
        while (n13 < n12) {
            int n14 = nArray[n13];
            switch (n14) {
                case 4: {
                    if (n6 <= n11) break;
                    int n15 = rectangle.y - n11 - 1;
                    return new Point(point.x, n15);
                }
                case 8: {
                    if (n7 <= n11) break;
                    int n16 = rectangle.y + rectangle.height + 1;
                    return new Point(point.x, n16);
                }
                case 1: {
                    if (n8 <= n10) break;
                    int n17 = rectangle.x - n10 - 1;
                    return new Point(n17, point.y);
                }
                case 2: {
                    if (n9 <= n10) break;
                    int n18 = rectangle.x + rectangle.width + 1;
                    return new Point(n18, point.y);
                }
            }
            ++n13;
        }
        return null;
    }

    private Rectangle getPopupSpace(PopupWindow[] popupWindowArray) {
        Rectangle rectangle = null;
        int n = popupWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            PopupWindow popupWindow = popupWindowArray[n2];
            JWindow jWindow = popupWindow.window;
            rectangle = rectangle == null ? (rectangle = jWindow.getBounds()) : rectangle.union(jWindow.getBounds());
            ++n2;
        }
        if (rectangle != null) {
            this.addPadding(rectangle);
        }
        return rectangle;
    }

    private void addPadding(Rectangle rectangle) {
        rectangle.x -= 5;
        rectangle.y -= 5;
        rectangle.width += 10;
        rectangle.height += 10;
    }

    private PopupWindow[] findCollidingPopups(Rectangle rectangle, PopupWindow[] popupWindowArray) {
        Rectangle rectangle2 = new Rectangle();
        ArrayList<PopupWindow> arrayList = new ArrayList<PopupWindow>();
        int n = popupWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            PopupWindow popupWindow = popupWindowArray[n2];
            JWindow jWindow = popupWindow.window;
            jWindow.getBounds(rectangle2);
            this.addPadding(rectangle2);
            if (rectangle2.intersects(rectangle)) {
                arrayList.add(popupWindow);
            }
            ++n2;
        }
        int n3 = arrayList.size();
        return arrayList.toArray(new PopupWindow[n3]);
    }

    private PopupWindow[] findPopupsInRegion(PopupWindow popupWindow, Rectangle rectangle, int n, PopupWindow[] popupWindowArray) {
        Rectangle rectangle2 = new Rectangle();
        ArrayList<PopupWindow> arrayList = new ArrayList<PopupWindow>();
        int n2 = popupWindowArray.length;
        int n3 = 0;
        while (n3 < n2) {
            PopupWindow popupWindow2 = popupWindowArray[n3];
            if (popupWindow2 != popupWindow) {
                JWindow jWindow = popupWindow2.window;
                jWindow.getBounds(rectangle2);
                boolean bl = false;
                switch (n) {
                    case 4: {
                        int n4 = rectangle.y + rectangle.height;
                        if (rectangle2.y >= n4) break;
                        bl = true;
                        break;
                    }
                    case 8: {
                        int n5 = rectangle2.y + rectangle2.height;
                        if (rectangle.y >= n5) break;
                        bl = true;
                        break;
                    }
                    case 2: {
                        int n6 = rectangle2.x + rectangle2.width;
                        if (rectangle.x >= n6) break;
                        bl = true;
                        break;
                    }
                    case 1: {
                        int n7 = rectangle.x + rectangle.width;
                        if (rectangle2.x >= n7) break;
                        bl = true;
                    }
                }
                if (bl) {
                    arrayList.add(popupWindow2);
                }
            }
            ++n3;
        }
        int n8 = arrayList.size();
        return arrayList.toArray(new PopupWindow[n8]);
    }

    private int adjustXForEditor(int n, int n2) {
        Point point = this.getEditorPane().getLocationOnScreen();
        int n3 = point.x;
        Rectangle rectangle = this.getEditorPane().getVisibleRect();
        int n4 = rectangle.width;
        int n5 = rectangle.x;
        int n6 = n3 + n5;
        int n7 = n6 + n4;
        int n8 = 2;
        if (n2 > n4 - n8 * 2) {
            n = n3 - (n2 - n4) / 2;
        } else if (n < n6 + n8) {
            n = n6 + n8;
        } else if (n + n2 > n7 - n8) {
            n = n7 - n8 - n2;
        }
        return n;
    }

    private int adjustYForEditor(int n, int n2) {
        Point point = this.getEditorPane().getLocationOnScreen();
        int n3 = point.y;
        Rectangle rectangle = this.getEditorPane().getVisibleRect();
        int n4 = rectangle.height;
        int n5 = rectangle.y;
        int n6 = n3 + n5;
        int n7 = n3 + n5 + n4;
        int n8 = 2;
        if (n2 > n4 - n8 * 2) {
            n = n3 - (n2 - n4) / 2;
        } else if (n < n6 + n8) {
            n = n6 + n8;
        } else if (n + n2 > n7 - n8) {
            n = n7 - n8 - n2;
        }
        return n;
    }

    private Point calculateLocation(Rectangle rectangle, Insets insets, Rectangle rectangle2, Dimension dimension, int n) {
        int n2;
        int n3;
        int n4 = dimension.height;
        int n5 = dimension.width;
        switch (n) {
            default: {
                n3 = rectangle2.x - n5 / 2;
                n3 = this.adjustXForEditor(n3, n5);
                break;
            }
            case 2: {
                n3 = rectangle2.x + rectangle2.width + 5;
                break;
            }
            case 1: {
                n3 = rectangle2.x - 5 - n5;
            }
        }
        switch (n) {
            case 1: 
            case 2: {
                n2 = rectangle2.y - n4 / 2;
                n2 = this.adjustYForEditor(n2, n4);
                break;
            }
            case 4: {
                n2 = rectangle2.y - n4 - 5;
                break;
            }
            default: {
                n2 = rectangle2.y + rectangle2.height + 5;
            }
        }
        Point point = new Point(n3, n2);
        Rectangle rectangle3 = new Rectangle(point, dimension);
        rectangle3 = this.ensureOnScreen(rectangle, insets, rectangle3);
        return new Point(rectangle3.x, rectangle3.y);
    }

    private Object[] getScreenInfo(Point point) {
        Rectangle rectangle;
        Insets insets;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration graphicsConfiguration = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        int n = 0;
        while (n < graphicsDeviceArray.length) {
            GraphicsConfiguration graphicsConfiguration2;
            if (graphicsDeviceArray[n].getType() == 0 && (graphicsConfiguration2 = graphicsDeviceArray[n].getDefaultConfiguration()).getBounds().contains(point)) {
                graphicsConfiguration = graphicsConfiguration2;
                break;
            }
            ++n;
        }
        if (graphicsConfiguration == null) {
            BasicEditorPane basicEditorPane = this.getEditorPane();
            graphicsConfiguration = basicEditorPane.getGraphicsConfiguration();
        }
        if (graphicsConfiguration != null) {
            insets = toolkit.getScreenInsets(graphicsConfiguration);
            rectangle = graphicsConfiguration.getBounds();
        } else {
            insets = new Insets(0, 0, 0, 0);
            rectangle = new Rectangle(toolkit.getScreenSize());
        }
        Dimension dimension = new Dimension(rectangle.width, rectangle.height);
        return new Object[]{rectangle, dimension, insets};
    }

    private Rectangle ensureOnScreen(Rectangle rectangle, Insets insets, Rectangle rectangle2) {
        Rectangle rectangle3 = new Rectangle(rectangle2);
        int n = rectangle.x + insets.left;
        int n2 = rectangle.y + insets.top;
        int n3 = rectangle.x + rectangle.width - insets.right;
        int n4 = rectangle.y + rectangle.height - insets.bottom;
        if (rectangle3.x < n) {
            rectangle3.x = n;
        }
        if (rectangle3.y < n2) {
            rectangle3.y = n2;
        }
        if (rectangle3.x + rectangle3.width > n3) {
            rectangle3.x = n3 - rectangle3.width;
        }
        if (rectangle3.y + rectangle3.height > n4) {
            rectangle3.y = n4 - rectangle3.height;
        }
        return rectangle3;
    }

    private Rectangle convertToAbsolute(Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        Point point = this.getEditorPane().getLocationOnScreen();
        rectangle2.x = (int)((double)rectangle2.x + point.getX());
        rectangle2.y = (int)((double)rectangle2.y + point.getY());
        return rectangle2;
    }

    private void transferFocusToEditor() {
        BasicEditorPane basicEditorPane = this.getEditorPane();
        1 var2_2 = new 1(this, basicEditorPane);
        SwingUtilities.invokeLater(var2_2);
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ BasicEditorPane v$editorToFocus;
        final /* synthetic */ PopupWindowManager this$0;

        public void run() {
            this.v$editorToFocus.requestFocus();
        }

        public 1(PopupWindowManager popupWindowManager, BasicEditorPane basicEditorPane) {
            this.v$editorToFocus = basicEditorPane;
            this.this$0 = popupWindowManager;
        }
    }
}

