/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.print;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.Utilities;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.editor.print.EditorPageable;
import oracle.javatools.editor.print.HTMLGeneratorOptions;

public class DocumentToHTMLGenerator {
    private BasicDocument _document;
    private String _filepath;
    private StyleRegistry _registry;
    private int _tabSize;
    private static final int PREFETCH_LINE_COUNT = 100;
    private static final String LINE_TO_SOURCE_PADDING = "  ";
    private static final String SOURCE_TO_WRAP_PADDING = "  ";

    public DocumentToHTMLGenerator(BasicDocument basicDocument, String string) {
        this.$init$();
        this._document = basicDocument;
        this._filepath = string;
    }

    void $init$() {
        this._registry = null;
        this._tabSize = -1;
    }

    public void setStyleRegistry(StyleRegistry styleRegistry) {
        this._registry = styleRegistry;
    }

    public void setTabSize(int n) {
        if (n > 0) {
            this._tabSize = n;
        }
    }

    public void generateHTML(OutputStream outputStream, HTMLGeneratorOptions hTMLGeneratorOptions) throws UnsupportedEncodingException, IOException {
        String string = hTMLGeneratorOptions.getCharsetEncoding();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        this.generateHTML(bufferedWriter, hTMLGeneratorOptions);
    }

    public void generateHTML(Writer writer, HTMLGeneratorOptions hTMLGeneratorOptions) throws IOException {
        writer.write("<html>\n");
        Map map = this.generateHead(writer, hTMLGeneratorOptions);
        this.generateBody(writer, hTMLGeneratorOptions, map);
        writer.write("</html>\n");
        writer.close();
    }

    private void generateBody(Writer writer, HTMLGeneratorOptions hTMLGeneratorOptions, Map map) throws IOException {
        writer.write("<body>\n");
        this.generateFileHeader(writer, hTMLGeneratorOptions, map);
        writer.write("<pre>\n");
        this.generateSource(writer, hTMLGeneratorOptions, map);
        writer.write("</pre>\n");
        writer.write("</body>\n");
    }

    /*
     * Unable to fully structure code
     */
    private void generateSource(Writer var1_1, HTMLGeneratorOptions var2_2, Map var3_3) throws IOException {
        var4_4 = this._document.getTextBuffer();
        var5_5 = var4_4.getLineMap();
        var6_6 = this._document.getDocumentRenderer();
        var7_7 = var2_2.getUseAnchors();
        var8_8 = var2_2.getPrintLineNumbers() == 1;
        var9_9 = var7_7 != false || var8_8 != false;
        var10_10 = var2_2.getPrintColors() != false || var2_2.getPrintFontStyles() != false || var2_2.getUseFontInfo() != false;
        var11_11 = var2_2.getWrapBehavior() == 1;
        var12_12 = var2_2.getWrapColumn();
        var13_13 = var2_2.getWrapSymbol();
        var14_14 = this.getTabSize();
        var15_15 = var5_5.getLineCount();
        var16_16 = EditorPageable.numDigits(var15_15);
        if (var9_9) {
            var17_17 = new char[var16_16];
            EditorPageable.setNumber(var17_17, 0);
            var18_18 = new char[var16_16];
            var19_19 = 0;
            while (var19_19 < var16_16) {
                var18_18[var19_19] = 32;
                ++var19_19;
            }
        } else {
            var17_17 = null;
            var18_18 = null;
        }
        var20_20 = "base-plain-style";
        var21_21 = var10_10 != false ? (String)var3_3.get("base-plain-style") : null;
        var22_22 = null;
        var23_23 = null;
        var24_24 = 0;
        var25_25 = 0;
        var26_26 = 0;
        while (var26_26 < var15_15) {
            if (var9_9) {
                EditorPageable.incrementNumber(var17_17);
            }
            if (var7_7) {
                var27_27 = EditorPageable.numDigits(var26_26 + 1);
                var1_1.write("<a name=\"");
                var1_1.write(var17_17, var16_16 - var27_27, var27_27);
                var1_1.write("\">");
            }
            var31_31 = (var28_28 = var5_5.getLineStartOffset(var26_26)) == (var30_30 = this.getLineEndBeforeTrailing(var4_4, var28_28, var29_29 = var5_5.getLineEndOffset(var26_26))) ? Math.min(var28_28 + 1, var29_29) : var30_30;
            var32_32 = var28_28;
            var33_33 = true;
            while (var32_32 < var31_31) {
                var34_34 = this.getGeneratedLineEnd(var4_4, var32_32, var31_31, var11_11, var12_12, var14_14);
                if (var8_8) {
                    if (var10_10) {
                        this.generateFontStart(var1_1, var21_21);
                    }
                    if (var33_33) {
                        var1_1.write(var17_17);
                        var33_33 = false;
                    } else {
                        var1_1.write(var18_18);
                    }
                    var1_1.write("  ");
                    if (var10_10) {
                        this.generateFontEnd(var1_1);
                    }
                }
                var35_35 = 0;
                ** GOTO lbl108
                {
                    if (var24_24 >= var25_25) {
                        if (var23_23 != null) {
                            var6_6.recycleFragmentsList(var23_23);
                        }
                        if ((var25_25 = this.getFragmentsCount(var23_23 = var6_6.renderLines(var36_36 = var26_26, var37_37 = Math.min(var26_26 + 100, var15_15 - 1)))) == 0) {
                            throw new IllegalStateException("empty fragment list");
                        }
                        var24_24 = 0;
                    }
                    var22_22 = var23_23.get(var24_24++);
                    do {
                        if (var22_22 == null || var32_32 < var22_22.startOffset || var22_22.endOffset <= var32_32) continue block11;
                        var38_38 = var22_22.styleName;
                        var39_39 = var38_38.equals("base-plain-style");
                        if (var10_10 && !var39_39) {
                            var40_40 = (String)var3_3.get(var38_38);
                            this.generateFontStart(var1_1, var40_40);
                        }
                        while (var32_32 < var22_22.endOffset && var32_32 < var34_34) {
                            var41_41 = var4_4.getChar(var32_32++);
                            switch (var41_41) {
                                case '\t': {
                                    var42_42 = Utilities.getNextTabStop(var14_14, var35_35);
                                    var43_43 = var42_42 - var35_35;
                                    if (var11_11 && var42_42 >= var12_12) {
                                        var43_43 = var12_12 - var42_42;
                                    }
                                    var44_44 = 0;
                                    while (var44_44 < var43_43) {
                                        var1_1.write(32);
                                        ++var44_44;
                                    }
                                    var35_35 = var42_42;
                                    break;
                                }
                                case '<': {
                                    var1_1.write("&lt;");
                                    break;
                                }
                                case '>': {
                                    var1_1.write("&gt;");
                                    break;
                                }
                                case '\"': {
                                    var1_1.write("&quot;");
                                    break;
                                }
                                case '&': {
                                    var1_1.write("&amp;");
                                    break;
                                }
                                case '\n': 
                                case '\r': {
                                    break;
                                }
                                default: {
                                    var1_1.write(var41_41);
                                    ++var35_35;
                                }
                            }
                        }
                        if (!var10_10 || var39_39) continue;
                        this.generateFontEnd(var1_1);
lbl108:
                        // 3 sources

                    } while (var32_32 < var34_34);
                }
                v0 = var45_45 = var34_34 != var31_31;
                if (!var11_11 || !var45_45) continue;
                var1_1.write("  ");
                var1_1.write(var13_13);
                var1_1.write("\n");
            }
            if (var7_7) {
                var1_1.write("</a>");
            }
            var1_1.write("\n");
            ++var26_26;
        }
    }

    private void generateFontStart(Writer writer, String string) throws IOException {
        writer.write("<font class=\"");
        writer.write(string);
        writer.write("\">");
    }

    private void generateFontEnd(Writer writer) throws IOException {
        writer.write("</font>");
    }

    private int getLineEndBeforeTrailing(TextBuffer textBuffer, int n, int n2) {
        int n3 = n2;
        while (n3 > n) {
            char c = textBuffer.getChar(n3 - 1);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    --n3;
                    break;
                }
                default: {
                    return n3;
                }
            }
        }
        return n3;
    }

    private int getGeneratedLineEnd(TextBuffer textBuffer, int n, int n2, boolean bl, int n3, int n4) {
        if (!bl) {
            return n2;
        }
        int n5 = 0;
        int n6 = n;
        while (n5 < n3 && n6 < n2) {
            char c = textBuffer.getChar(n6++);
            switch (c) {
                case '\t': {
                    n5 = Utilities.getNextTabStop(n4, n5);
                    break;
                }
                default: {
                    ++n5;
                }
            }
        }
        return n6;
    }

    private int getTabSize() {
        if (this._tabSize > 0) {
            return this._tabSize;
        }
        EditorProperties editorProperties = EditorProperties.getProperties();
        return editorProperties.getIntegerProperty("tab-size");
    }

    private int getFragmentsCount(StyledFragmentsList styledFragmentsList) {
        return styledFragmentsList == null ? 0 : styledFragmentsList.size();
    }

    private void generateFileHeader(Writer writer, HTMLGeneratorOptions hTMLGeneratorOptions, Map map) throws IOException {
        boolean bl = hTMLGeneratorOptions.getPrintFileHeader();
        boolean bl2 = hTMLGeneratorOptions.getPrintTimeStamp();
        if (bl) {
            boolean bl3 = hTMLGeneratorOptions.getPrintColors() || hTMLGeneratorOptions.getPrintFontStyles() || hTMLGeneratorOptions.getUseFontInfo();
            String string = "base-plain-style";
            String string2 = bl3 ? (String)map.get("base-plain-style") : null;
            writer.write("<pre>\n");
            if (string2 != null) {
                this.generateFontStart(writer, string2);
            }
            if (this._filepath != null) {
                writer.write(this._filepath);
                writer.write("\n");
            }
            if (string2 != null) {
                this.generateFontEnd(writer);
            }
            if (bl2) {
                Date date = new Date();
                DateFormat dateFormat = DateFormat.getDateTimeInstance();
                writer.write(dateFormat.format(date));
                writer.write("\n");
            }
            writer.write("</pre>\n");
        }
    }

    private Map generateHead(Writer writer, HTMLGeneratorOptions hTMLGeneratorOptions) throws IOException {
        writer.write("<head>\n");
        String string = hTMLGeneratorOptions.getCharsetEncoding();
        writer.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=");
        writer.write(string);
        writer.write("\">\n");
        writer.write("<title>\n");
        if (this._filepath != null) {
            writer.write(this._filepath);
            writer.write("\n");
        }
        writer.write("</title>\n");
        Map map = this.generateStyles(writer, hTMLGeneratorOptions);
        writer.write("</head>\n");
        return map;
    }

    private Map generateStyles(Writer writer, HTMLGeneratorOptions hTMLGeneratorOptions) throws IOException {
        boolean bl = hTMLGeneratorOptions.getPrintColors();
        boolean bl2 = hTMLGeneratorOptions.getPrintFontStyles();
        boolean bl3 = hTMLGeneratorOptions.getPrintFileHeader();
        boolean bl4 = hTMLGeneratorOptions.getUseFontInfo();
        String string = hTMLGeneratorOptions.getFontFamily();
        int n = hTMLGeneratorOptions.getFontSize();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        writer.write("<style type=\"text/css\">\n");
        writer.write("<!--\n");
        StyleRegistry styleRegistry = this._registry;
        if (styleRegistry == null) {
            EditorProperties editorProperties = EditorProperties.getProperties();
            styleRegistry = editorProperties.getStyleRegistry();
        }
        Color color = null;
        if (bl) {
            writer.write("body {");
            BaseStyle baseStyle = styleRegistry.lookupStyle("base-plain-style");
            if (baseStyle != null) {
                Color color2;
                Color color3 = baseStyle.getForegroundColor();
                color = color2 = baseStyle.getBackgroundColor();
                writer.write("color: ");
                this.generateColor(writer, color3);
                writer.write("; background-color: ");
                this.generateColor(writer, color2);
            }
            writer.write("}\n");
        }
        if (bl || bl4 || bl2) {
            int n2 = 0;
            Iterator iterator = styleRegistry.getStyleIterator();
            while (iterator.hasNext()) {
                BaseStyle baseStyle = (BaseStyle)iterator.next();
                if (baseStyle == null) continue;
                String string2 = "s" + n2;
                ++n2;
                writer.write(".");
                writer.write(string2);
                writer.write(" {");
                boolean bl5 = false;
                if (bl) {
                    Color color4 = baseStyle.getForegroundColor();
                    Color color5 = baseStyle.getBackgroundColor();
                    writer.write("color: ");
                    this.generateColor(writer, color4);
                    writer.write("; background-color: ");
                    if (color5.equals(color)) {
                        writer.write("transparent");
                    } else {
                        this.generateColor(writer, color5);
                    }
                    bl5 = true;
                }
                if (bl4) {
                    if (bl5) {
                        writer.write("; ");
                    }
                    writer.write("font-family: ");
                    writer.write(string);
                    writer.write("; font-size: ");
                    writer.write(Integer.toString(n));
                    bl5 = true;
                }
                if (bl2) {
                    boolean bl6;
                    boolean bl7;
                    int n3 = baseStyle.getFontStyle();
                    boolean bl8 = bl7 = (n3 & 1) == 1;
                    if (bl7) {
                        if (bl5) {
                            writer.write("; ");
                        }
                        writer.write("font-weight: bold");
                        bl5 = true;
                    }
                    boolean bl9 = bl6 = (n3 & 2) == 2;
                    if (bl6) {
                        if (bl5) {
                            writer.write("; ");
                        }
                        writer.write("font-style: italic");
                        bl5 = true;
                    }
                }
                writer.write("}\n");
                hashMap.put(baseStyle.getName(), string2);
            }
        }
        writer.write("-->\n");
        writer.write("</style>\n");
        return hashMap;
    }

    private void generateColor(Writer writer, Color color) throws IOException {
        int n = color.getRGB() & 0xFFFFFF;
        String string = Integer.toHexString(n);
        writer.write("#");
        int n2 = string.length();
        int n3 = 6 - n2;
        int n4 = 0;
        while (n4 < n3) {
            writer.write(48);
            ++n4;
        }
        writer.write(string);
    }
}

