/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.print;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.text.Segment;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.FontHelper;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.DocumentRenderer;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.StyledFragment;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.editor.print.PageInfo;
import oracle.javatools.editor.print.PrintOptions;

public class EditorPageable
implements Printable,
Pageable {
    private BasicDocument document;
    private Component randomComponent;
    private String fileName;
    private PageFormat pageFormat;
    private Segment segment;
    private PrintOptions printOptions;
    private FontHelper fontHelper;
    private String wrapSymbol;
    private int numPages;
    private int linesPerPage;
    private int gutterWidth;
    private int wrapSymbolWidth;
    private int headerHeight;
    private char[] digitArray;
    private FontMetrics fontMetrics;
    private int fontHeight;
    private int fontAscent;
    private int tabSize;
    private int bufferLines;
    private int printedLines;
    private PageInfo[] pageArray;
    private static final int GUTTER_SPACING = 20;
    private static final int WRAP_SYMBOL_SPACING = 10;
    private static final int HEADER_SPACING = 20;
    private static final boolean DEBUG = false;

    public EditorPageable(String string, BasicDocument basicDocument, PrintOptions printOptions, PageFormat pageFormat) {
        this.document = basicDocument;
        this.fileName = string;
        this.setPrintOptions(printOptions);
        this.setPageFormat(pageFormat);
        this.numPages = -1;
        this.linesPerPage = -1;
        this.segment = new Segment();
    }

    public void setPrintOptions(PrintOptions printOptions) {
        this.printOptions = (PrintOptions)printOptions.clone();
        this.invalidate();
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
        this.invalidate();
    }

    public void repaginate() {
        boolean bl;
        int n;
        this.randomComponent = new JPanel();
        this.fontHelper = new FontHelper(this.printOptions.getFontFamily(), this.printOptions.getFontSize());
        Font font = this.fontHelper.getBaseFont();
        this.fontMetrics = this.fontHelper.getFontMetrics(font, this.randomComponent);
        this.fontHeight = this.fontMetrics.getHeight();
        this.fontAscent = this.fontMetrics.getAscent();
        int n2 = (int)this.pageFormat.getImageableWidth();
        int n3 = n = (int)this.pageFormat.getImageableHeight();
        int n4 = n2;
        if (this.printOptions.getPrintFileHeader() || this.printOptions.getPrintPageNumbers()) {
            this.headerHeight = this.fontHeight;
            n3 -= this.headerHeight + 20;
        } else {
            this.headerHeight = 0;
        }
        LineMap lineMap = this.document.getLineMap();
        this.bufferLines = lineMap.getLineCount();
        if (this.printOptions.getPrintLineNumbers() != 0) {
            int n5 = EditorPageable.digitWidth(this.fontMetrics);
            int n6 = EditorPageable.numDigits(this.bufferLines);
            this.digitArray = new char[n6 + 1];
            this.gutterWidth = n5 * n6;
            n4 -= this.gutterWidth + 20;
        } else {
            this.gutterWidth = 0;
        }
        boolean bl2 = bl = this.printOptions.getWrapBehavior() != 0;
        if (bl) {
            this.wrapSymbol = this.printOptions.getWrapSymbol().trim();
            int n7 = this.wrapSymbolWidth = this.wrapSymbol.length() > 0 ? this.fontMetrics.stringWidth(this.wrapSymbol) : 0;
            if (this.wrapSymbolWidth > 0) {
                n4 -= this.wrapSymbolWidth + 10;
            }
        } else {
            this.wrapSymbolWidth = 0;
            this.wrapSymbol = "";
        }
        int n8 = n3 / this.fontHeight;
        EditorProperties editorProperties = EditorProperties.getProperties();
        this.tabSize = editorProperties.getIntegerProperty("tab-size");
        if (!bl) {
            this.printedLines = this.bufferLines;
            this.numPages = this.bufferLines / n8;
            if (n8 * this.numPages < this.bufferLines) {
                ++this.numPages;
            }
            this.pageArray = new PageInfo[this.numPages];
            int n9 = 0;
            while (n9 < this.numPages) {
                PageInfo pageInfo;
                this.pageArray[n9] = pageInfo = new PageInfo(n8);
                int n10 = n9 * n8;
                int n11 = 0;
                pageInfo.firstLine = n10 + 1;
                while (n10 < this.bufferLines && n11 < n8) {
                    pageInfo.wrappedArray[n11] = false;
                    pageInfo.startOffsetArray[n11] = lineMap.getLineStartOffset(n10);
                    pageInfo.endOffsetArray[n11] = lineMap.getLineEndOffset(n10);
                    pageInfo.lineNumberArray[n11++] = ++n10;
                }
                pageInfo.printedLines = n11;
                ++n9;
            }
        } else {
            StyleRegistry styleRegistry = editorProperties.getStyleRegistry();
            DocumentRenderer documentRenderer = this.document.getDocumentRenderer();
            ArrayList<PageInfo> arrayList = new ArrayList<PageInfo>();
            StyledFragmentsList styledFragmentsList = null;
            TextBuffer textBuffer = this.document.getTextBuffer();
            int n12 = this.document.getLength();
            int n13 = 0;
            int n14 = 0;
            int n15 = 0;
            boolean bl3 = this.printOptions.getPrintFontStyles();
            FontMetrics fontMetrics = this.fontMetrics;
            do {
                PageInfo pageInfo = new PageInfo(n8);
                if (n14 == n12) {
                    pageInfo.firstLine = 1;
                    pageInfo.lineNumberArray[0] = 1;
                    pageInfo.startOffsetArray[0] = 0;
                    pageInfo.endOffsetArray[0] = 0;
                    pageInfo.wrappedArray[0] = false;
                    pageInfo.printedLines = 0;
                    arrayList.add(pageInfo);
                    break;
                }
                StyledFragment styledFragment = null;
                BaseStyle baseStyle = null;
                int n16 = 0;
                int n17 = 0;
                if (bl3) {
                    int n18 = Math.min(this.bufferLines - 1, n13 + n8 - 1);
                    styledFragmentsList = documentRenderer.renderLines(n13, n18);
                    if (styledFragmentsList == null) {
                        throw new IllegalStateException("empty fragments list");
                    }
                    n16 = styledFragmentsList.size();
                    while (n17 < n16) {
                        styledFragment = styledFragmentsList.get(n17);
                        if (styledFragment.endOffset > n14) break;
                        ++n17;
                    }
                    baseStyle = this.lookupStyle(styleRegistry, styledFragment.styleName);
                    int n19 = baseStyle.getFontStyle();
                    Font font2 = this.fontHelper.getFont(n19);
                    fontMetrics = this.fontHelper.getFontMetrics(font2, this.randomComponent);
                }
                pageInfo.printedLines = n8;
                pageInfo.firstLine = n13 + 1;
                int n20 = 0;
                while (n20 < n8) {
                    pageInfo.wrappedArray[n20] = false;
                    pageInfo.startOffsetArray[n20] = n14;
                    int n21 = lineMap.getLineStartOffset(n13);
                    int n22 = lineMap.getLineEndOffset(n13);
                    pageInfo.lineNumberArray[n20] = n14 == n21 ? n13 + 1 : -1;
                    int n23 = n22;
                    while (n23 > n21) {
                        char c = textBuffer.getChar(n23 - 1);
                        if (c != ' ' && c != '\t' && c != '\n' && c != '\r') break;
                        --n23;
                    }
                    int n24 = 0;
                    int n25 = n14;
                    boolean bl4 = false;
                    block11: while (n25 < n12) {
                        if (n25 >= n23) {
                            n25 = n22;
                            bl4 = true;
                            break;
                        }
                        if (bl3 && styledFragment.endOffset <= n25) {
                            styledFragment = styledFragmentsList.get(++n17);
                            baseStyle = this.lookupStyle(styleRegistry, styledFragment.styleName);
                            int n26 = baseStyle.getFontStyle();
                            Font font3 = this.fontHelper.getFont(n26);
                            fontMetrics = this.fontHelper.getFontMetrics(font3, this.randomComponent);
                        }
                        char c = textBuffer.getChar(n25);
                        switch (c) {
                            case '\n': {
                                bl4 = true;
                                break block11;
                            }
                            case '\t': {
                                ++n25;
                                n24 = EditorPageable.getNextTabStop(this.fontMetrics, this.tabSize, n24);
                                if (n24 < n4) continue block11;
                                break block11;
                            }
                            case ' ': {
                                ++n25;
                                if ((n24 += fontMetrics.charWidth(' ')) < n4) continue block11;
                                break block11;
                            }
                            default: {
                                if ((n24 += fontMetrics.charWidth(c)) > n4) break block11;
                                ++n25;
                            }
                        }
                    }
                    pageInfo.endOffsetArray[n20] = n14 = ++n25;
                    if (bl4) {
                        ++n13;
                    } else {
                        pageInfo.wrappedArray[n20] = true;
                    }
                    if (n14 == n12) {
                        pageInfo.wrappedArray[n20] = false;
                        pageInfo.printedLines = n20 + 1;
                        break;
                    }
                    ++n20;
                }
                if (bl3) {
                    documentRenderer.recycleFragmentsList(styledFragmentsList);
                }
                n15 += pageInfo.printedLines;
                arrayList.add(pageInfo);
            } while (n14 != n12);
            this.printedLines = n15;
            this.numPages = arrayList.size();
            this.pageArray = arrayList.toArray(new PageInfo[this.numPages]);
        }
    }

    private BaseStyle lookupStyle(StyleRegistry styleRegistry, String string) {
        BaseStyle baseStyle = styleRegistry.lookupStyle(string);
        if (baseStyle == null) {
            throw new IllegalStateException("style not found: " + string);
        }
        return baseStyle;
    }

    protected void invalidate() {
        this.numPages = -1;
    }

    protected void repaginateIfNeeded() {
        if (this.numPages == -1) {
            this.repaginate();
        }
    }

    protected boolean isPageIndexValid(int n) {
        return n >= 0 && n < this.numPages;
    }

    protected void verifyPageIndexValid(int n) throws IndexOutOfBoundsException {
        if (!this.isPageIndexValid(n)) {
            throw new IndexOutOfBoundsException("bad index: " + n);
        }
    }

    public int getNumberOfPages() {
        this.repaginateIfNeeded();
        return this.numPages;
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        this.repaginateIfNeeded();
        this.verifyPageIndexValid(n);
        return this.pageFormat;
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        this.repaginateIfNeeded();
        this.verifyPageIndexValid(n);
        return this;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (!this.isPageIndexValid(n)) {
            return 1;
        }
        this.printHeader(graphics, pageFormat, n);
        this.printLineNumbers(graphics, pageFormat, n);
        this.printWrappedSymbols(graphics, pageFormat, n);
        this.printText(graphics, pageFormat, n);
        return 0;
    }

    protected void printHeader(Graphics graphics, PageFormat pageFormat, int n) {
        if (this.headerHeight > 0) {
            int n2 = (int)pageFormat.getImageableX();
            int n3 = (int)pageFormat.getImageableY();
            int n4 = (int)pageFormat.getImageableWidth();
            Font font = this.fontHelper.getBaseFont();
            graphics.setFont(font);
            graphics.setColor(Color.black);
            if (this.printOptions.getPrintFileHeader()) {
                int n5 = this.fileName.lastIndexOf(47);
                int n6 = this.fileName.lastIndexOf(58);
                int n7 = this.fileName.lastIndexOf(92);
                int n8 = Math.max(Math.max(n5, n6), n7);
                String string = this.fileName.substring(n8 + 1);
                graphics.drawString(string, n2, n3 + this.fontAscent);
            }
            if (this.printOptions.getPrintPageNumbers()) {
                int n9 = n + 1;
                String string = n9 + "/" + this.numPages;
                int n10 = this.fontMetrics.stringWidth(string);
                graphics.drawString(string, n2 + n4 - n10, n3 + this.fontAscent);
            }
        }
    }

    protected void printLineNumbers(Graphics graphics, PageFormat pageFormat, int n) {
        if (this.gutterWidth > 0) {
            int n2 = (int)pageFormat.getImageableX();
            int n3 = (int)pageFormat.getImageableY();
            Font font = this.fontHelper.getBaseFont();
            graphics.setFont(font);
            graphics.setColor(Color.black);
            int n4 = n3 + this.fontAscent;
            if (this.headerHeight > 0) {
                n4 += this.headerHeight + 20;
            }
            int n5 = n2 + this.gutterWidth;
            PageInfo pageInfo = this.pageArray[n];
            EditorPageable.setNumber(this.digitArray, pageInfo.firstLine);
            int n6 = pageInfo.printedLines;
            int[] nArray = pageInfo.lineNumberArray;
            int n7 = this.digitArray.length;
            int n8 = 0;
            while (n8 < n6) {
                if (nArray[n8] == -1) {
                    if (n8 == 0) {
                        EditorPageable.incrementNumber(this.digitArray);
                    }
                } else {
                    int n9 = this.fontMetrics.charsWidth(this.digitArray, 0, n7);
                    graphics.drawChars(this.digitArray, 0, n7, n5 - n9, n4);
                    EditorPageable.incrementNumber(this.digitArray);
                }
                n4 += this.fontHeight;
                ++n8;
            }
        }
    }

    protected void printWrappedSymbols(Graphics graphics, PageFormat pageFormat, int n) {
        if (this.wrapSymbolWidth > 0) {
            int n2 = (int)pageFormat.getImageableX();
            int n3 = (int)pageFormat.getImageableY();
            int n4 = (int)pageFormat.getImageableWidth();
            Font font = this.fontHelper.getBaseFont();
            graphics.setFont(font);
            graphics.setColor(Color.black);
            int n5 = n3 + this.fontAscent;
            if (this.headerHeight > 0) {
                n5 += this.headerHeight + 20;
            }
            int n6 = n2 + n4 - this.wrapSymbolWidth;
            PageInfo pageInfo = this.pageArray[n];
            int n7 = pageInfo.printedLines;
            boolean[] blArray = pageInfo.wrappedArray;
            int n8 = 0;
            while (n8 < n7) {
                if (blArray[n8]) {
                    graphics.drawString(this.wrapSymbol, n6, n5);
                }
                n5 += this.fontHeight;
                ++n8;
            }
        }
    }

    protected void printText(Graphics graphics, PageFormat pageFormat, int n) {
        int n2 = (int)pageFormat.getImageableX();
        int n3 = (int)pageFormat.getImageableY();
        int n4 = (int)pageFormat.getImageableWidth();
        int n5 = n2;
        if (this.gutterWidth > 0) {
            n5 += this.gutterWidth + 20;
        }
        int n6 = n5;
        int n7 = n3 + this.fontAscent;
        if (this.headerHeight > 0) {
            n7 += this.headerHeight + 20;
        }
        PageInfo pageInfo = this.pageArray[n];
        int n8 = pageInfo.printedLines;
        int[] nArray = pageInfo.startOffsetArray;
        int[] nArray2 = pageInfo.endOffsetArray;
        if (n8 == 0) {
            return;
        }
        LineMap lineMap = this.document.getLineMap();
        TextBuffer textBuffer = this.document.getTextBuffer();
        DocumentRenderer documentRenderer = this.document.getDocumentRenderer();
        EditorProperties editorProperties = EditorProperties.getProperties();
        StyleRegistry styleRegistry = editorProperties.getStyleRegistry();
        StyledFragmentsList styledFragmentsList = null;
        StyledFragment styledFragment = null;
        BaseStyle baseStyle = null;
        int n9 = 0;
        int n10 = 0;
        FontMetrics fontMetrics = this.fontMetrics;
        boolean bl = this.printOptions.getPrintColors();
        boolean bl2 = this.printOptions.getPrintFontStyles();
        if (bl || bl2) {
            int n11;
            int n12 = nArray[0];
            int n13 = nArray2[n8 - 1];
            int n14 = lineMap.getLineFromOffset(n12);
            styledFragmentsList = documentRenderer.renderLines(n14, n11 = lineMap.getLineFromOffset(n13));
            if (styledFragmentsList == null) {
                throw new IllegalStateException("empty fragments list");
            }
            n9 = styledFragmentsList.size();
            while (n10 < n9) {
                styledFragment = styledFragmentsList.get(n10);
                if (styledFragment.endOffset > n12) break;
                ++n10;
            }
            baseStyle = this.lookupStyle(styleRegistry, styledFragment.styleName);
        }
        if (bl2) {
            int n15 = baseStyle.getFontStyle();
            Font font = this.fontHelper.getFont(n15);
            fontMetrics = this.fontHelper.getFontMetrics(font, this.randomComponent);
            graphics.setFont(font);
        } else {
            Font font = this.fontHelper.getBaseFont();
            graphics.setFont(font);
        }
        if (bl) {
            Color color = baseStyle.getForegroundColor();
            if (color.equals(Color.white)) {
                color = Color.black;
            }
            graphics.setColor(color);
        } else {
            graphics.setColor(Color.black);
        }
        int n16 = 0;
        while (n16 < n8) {
            n6 = n5;
            int n17 = nArray[n16];
            int n18 = nArray2[n16];
            textBuffer.getText(n17, n18 - n17, this.segment);
            char[] cArray = this.segment.array;
            int n19 = this.segment.offset;
            int n20 = this.segment.offset + this.segment.count;
            int n21 = n19;
            int n22 = n19;
            int n23 = n19 - n17;
            int n24 = 0;
            int n25 = 0;
            block6: while (n21 < n20) {
                if ((bl2 || bl) && styledFragment.endOffset <= n21 - n23) {
                    if (n24 > 0) {
                        graphics.drawChars(cArray, n22, n24, n6, n7);
                        n6 += n25;
                        n24 = 0;
                        n25 = 0;
                        n22 = n21;
                    }
                    styledFragment = styledFragmentsList.get(++n10);
                    baseStyle = this.lookupStyle(styleRegistry, styledFragment.styleName);
                    if (bl) {
                        Color color = baseStyle.getForegroundColor();
                        if (color.equals(Color.white)) {
                            color = Color.black;
                        }
                        graphics.setColor(color);
                    }
                    if (bl2) {
                        int n26 = baseStyle.getFontStyle();
                        Font font = this.fontHelper.getFont(n26);
                        fontMetrics = this.fontHelper.getFontMetrics(font, this.randomComponent);
                        graphics.setFont(font);
                    }
                }
                char c = cArray[n21];
                switch (c) {
                    case '\t': {
                        if (n24 > 0) {
                            graphics.drawChars(cArray, n22, n24, n6, n7);
                            n6 += n25;
                            n24 = 0;
                            n25 = 0;
                        }
                        n22 = n21 + 1;
                        int n27 = n6 - n5;
                        n6 = EditorPageable.getNextTabStop(this.fontMetrics, this.tabSize, n27) + n5;
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        break block6;
                    }
                    default: {
                        ++n24;
                        n25 += fontMetrics.charWidth(c);
                    }
                }
                ++n21;
            }
            if (n24 > 0) {
                graphics.drawChars(cArray, n22, n24, n6, n7);
            }
            n7 += this.fontHeight;
            ++n16;
        }
        if (styledFragmentsList != null) {
            documentRenderer.recycleFragmentsList(styledFragmentsList);
        }
    }

    private static int getNextTabStop(FontMetrics fontMetrics, int n, int n2) {
        int n3 = fontMetrics.charWidth(' ');
        int n4 = n * n3;
        int n5 = n2 / n4;
        int n6 = n4 * (n5 + 1);
        return n6;
    }

    private static int digitWidth(FontMetrics fontMetrics) {
        int n = 0;
        char c = '0';
        while (c <= '9') {
            int n2 = fontMetrics.charWidth(c);
            n = Math.max(n2, n);
            c = (char)(c + '\u0001');
        }
        return n;
    }

    static int numDigits(int n) {
        if (n < 10) {
            return 1;
        }
        if (n < 100) {
            return 2;
        }
        if (n < 1000) {
            return 3;
        }
        int n2 = 0;
        do {
            ++n2;
        } while ((n /= 10) != 0);
        return n2;
    }

    static void setNumber(char[] cArray, int n) {
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3] = 32;
            ++n3;
        }
        String string = Integer.toString(n);
        char[] cArray2 = string.toCharArray();
        int n4 = cArray2.length;
        int n5 = n2 - n4;
        System.arraycopy(cArray2, 0, cArray, n5, n4);
    }

    static void incrementNumber(char[] cArray) {
        int n = cArray.length;
        int n2 = 1;
        int n3 = n - 1;
        while (n3 >= 0) {
            char c = cArray[n3];
            int n4 = c == ' ' ? 0 : c - 48;
            n2 = 0;
            if ((n4 += n2) > 9) {
                n2 = 1;
                n4 -= 10;
            }
            cArray[n3] = (char)(n4 + 48);
            if (n2 == 0) break;
            --n3;
        }
    }
}

