/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.print;

public class HTMLGeneratorOptions {
    private String charsetEncoding;
    private boolean printColors;
    private boolean printFontStyles;
    private int wrapBehavior;
    public static final int WRAP_NONE = 0;
    public static final int WRAP_FILL_WIDTH = 1;
    private int wrapColumn;
    private static final int WRAP_COLUMN_MINIMUM = 10;
    private String wrapSymbol;
    private boolean useAnchors;
    private int printLineNumbers;
    public static final int LINE_NUMBERS_NONE = 0;
    public static final int LINE_NUMBERS_EVERY = 1;
    private boolean printFileHeader;
    private boolean printTimeStamp;
    private boolean useFontInfo;
    private String fontFamily;
    private int fontSize;

    public HTMLGeneratorOptions() {
        this.setCharsetEncoding("utf-8");
        this.setPrintColors(true);
        this.setPrintFontStyles(true);
        this.setWrapBehavior(0);
        this.setWrapColumn(80);
        this.setWrapSymbol("\\");
        this.setUseAnchors(true);
        this.setPrintLineNumbers(1);
        this.setPrintFileHeader(true);
        this.setPrintTimeStamp(true);
        this.setUseFontInfo(false);
        this.setFontFamily("DialogInput");
        this.setFontSize(12);
    }

    public Object copyTo(Object object) {
        HTMLGeneratorOptions hTMLGeneratorOptions = object != null ? (HTMLGeneratorOptions)object : new HTMLGeneratorOptions();
        hTMLGeneratorOptions.charsetEncoding = this.charsetEncoding;
        hTMLGeneratorOptions.printColors = this.printColors;
        hTMLGeneratorOptions.printFontStyles = this.printFontStyles;
        hTMLGeneratorOptions.wrapBehavior = this.wrapBehavior;
        hTMLGeneratorOptions.wrapColumn = this.wrapColumn;
        hTMLGeneratorOptions.wrapSymbol = this.wrapSymbol;
        hTMLGeneratorOptions.useAnchors = this.useAnchors;
        hTMLGeneratorOptions.printLineNumbers = this.printLineNumbers;
        hTMLGeneratorOptions.printFileHeader = this.printFileHeader;
        hTMLGeneratorOptions.printTimeStamp = this.printTimeStamp;
        hTMLGeneratorOptions.useFontInfo = this.useFontInfo;
        hTMLGeneratorOptions.fontFamily = this.fontFamily;
        hTMLGeneratorOptions.fontSize = this.fontSize;
        return hTMLGeneratorOptions;
    }

    public Object clone() {
        return this.copyTo(null);
    }

    public String getCharsetEncoding() {
        return this.charsetEncoding;
    }

    public void setCharsetEncoding(String string) {
        this.charsetEncoding = string;
    }

    public boolean getPrintColors() {
        return this.printColors;
    }

    public void setPrintColors(boolean bl) {
        this.printColors = bl;
    }

    public boolean getPrintFontStyles() {
        return this.printFontStyles;
    }

    public void setPrintFontStyles(boolean bl) {
        this.printFontStyles = bl;
    }

    public int getWrapBehavior() {
        return this.wrapBehavior;
    }

    public void setWrapBehavior(int n) {
        this.wrapBehavior = n;
    }

    public int getWrapColumn() {
        return this.wrapColumn;
    }

    public void setWrapColumn(int n) {
        this.wrapColumn = Math.max(n, 10);
    }

    public String getWrapSymbol() {
        return this.wrapSymbol;
    }

    public void setWrapSymbol(String string) {
        this.wrapSymbol = string;
    }

    public boolean getUseAnchors() {
        return this.useAnchors;
    }

    public void setUseAnchors(boolean bl) {
        this.useAnchors = bl;
    }

    public int getPrintLineNumbers() {
        return this.printLineNumbers;
    }

    public void setPrintLineNumbers(int n) {
        this.printLineNumbers = n;
    }

    public boolean getPrintFileHeader() {
        return this.printFileHeader;
    }

    public void setPrintFileHeader(boolean bl) {
        this.printFileHeader = bl;
    }

    public boolean getPrintTimeStamp() {
        return this.printTimeStamp;
    }

    public void setPrintTimeStamp(boolean bl) {
        this.printTimeStamp = bl;
    }

    public boolean getUseFontInfo() {
        return this.useFontInfo;
    }

    public void setUseFontInfo(boolean bl) {
        this.useFontInfo = bl;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String string) {
        this.fontFamily = string;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int n) {
        this.fontSize = n;
    }
}

