/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.controls.nicetable.NiceTableCellRenderer;
import oracle.javatools.controls.nicetable.NiceTableViewport;
import oracle.javatools.history.HeaderRenderer;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryModel;
import oracle.javatools.history.HistoryProperty;
import oracle.javatools.history.TableModelAdapter;

public class HistoryComponent
extends JPanel {
    public static final Date LIVE_DATE = new LiveDate();
    private NiceTable _table;
    private JScrollPane _scrollPane;
    private HistoryModel _model;
    private boolean m_tableInitialized;
    private boolean _useScrollPane;
    private boolean _useAutoSizeMaximums;

    void $init$() {
        this._table = new NiceTable();
        this.m_tableInitialized = false;
        this._useScrollPane = true;
        this._useAutoSizeMaximums = false;
    }

    public void setUseScrollPane(boolean bl) {
        this._useScrollPane = bl;
    }

    public void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        if (this._scrollPane != null) {
            this._scrollPane.addMouseListener(mouseListener);
        }
        this._table.addMouseListener(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        super.removeMouseListener(mouseListener);
        if (this._scrollPane != null) {
            this._scrollPane.removeMouseListener(mouseListener);
        }
        this._table.removeMouseListener(mouseListener);
    }

    public NiceTable getTable() {
        return this._table;
    }

    private JScrollPane getScrollPane() {
        return this._scrollPane;
    }

    public HistoryProperty getSortProperty() {
        if (this.getModel() == null) {
            return null;
        }
        if (this.getTable().isSorted()) {
            int n = this.getTable().getSortColumn();
            return this.getModel().getProperties()[n];
        }
        return null;
    }

    public void sortTableByProperty(HistoryProperty historyProperty, boolean bl) {
        if (this.getModel() == null) {
            throw new IllegalStateException("No Model");
        }
        HistoryProperty[] historyPropertyArray = this.getModel().getProperties();
        int n = 0;
        while (n < historyPropertyArray.length) {
            if (historyProperty == historyPropertyArray[n]) {
                this.getTable().setSortColumn(n, bl);
                return;
            }
            ++n;
        }
        throw new IllegalArgumentException("Unknown property: " + historyProperty);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.getTable().getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.getTable().getSelectionModel().removeListSelectionListener(listSelectionListener);
    }

    public void setSingleSelection(boolean bl) {
        if (bl) {
            this.getTable().setSelectionMode(0);
        } else {
            this.getTable().setSelectionMode(2);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.getTable().setEnabled(bl);
    }

    public String getSelectionCopyString() {
        StringBuffer stringBuffer = new StringBuffer();
        HistoryEntry[] historyEntryArray = this.getSelection();
        int n = 0;
        while (n < historyEntryArray.length) {
            int n2 = 0;
            while (n2 < this.getTable().getColumnModel().getColumnCount()) {
                int n3 = this.getTable().convertColumnIndexToModel(n2);
                Object object = historyEntryArray[n].getValue(this.getModel().getProperties()[n3]);
                stringBuffer.append(String.valueOf(object));
                if (n2 < this.getTable().getColumnModel().getColumnCount() - 1) {
                    stringBuffer.append(",\t");
                }
                ++n2;
            }
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public HistoryModel getModel() {
        return this._model;
    }

    public void selectAll() {
        this.getTable().getSelectionModel().setSelectionInterval(0, this.getTable().getModel().getRowCount() - 1);
    }

    public void selectFirst() {
        if (this.getTable().getModel().getRowCount() > 0) {
            this.getTable().getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void initTable() {
        this.getTable().getTableHeader().setReorderingAllowed(false);
        this.getTable().setDefaultRenderer(String.class, new StringCellRenderer(null));
        this.getTable().setDefaultRenderer(Date.class, new DateCellRenderer(null));
        this.setLayout(new BorderLayout());
        this.getTable().setAutoResizeMode(0);
        if (this._useScrollPane) {
            this._scrollPane = this.getTable().getScrollPaneForTable();
            this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.add((Component)this._scrollPane, "Center");
        } else {
            NiceTableViewport niceTableViewport = new NiceTableViewport();
            niceTableViewport.setView(this.getTable());
            niceTableViewport.setBackground(this.getTable().getBackground());
            this.add((Component)this.getTable().getTableHeader(), "North");
            this.add((Component)niceTableViewport, "Center");
        }
        this.m_tableInitialized = true;
    }

    public HistoryProperty[] getHiddenProperties() {
        TableModelAdapter tableModelAdapter = (TableModelAdapter)this._table.getBaseModel();
        LinkedHashSet<HistoryProperty> linkedHashSet = new LinkedHashSet<HistoryProperty>(Arrays.asList(this._model.getProperties()));
        int n = 0;
        while (n < this._table.getColumnCount()) {
            linkedHashSet.remove(tableModelAdapter.getProperty(this._table.convertColumnIndexToModel(n)));
            ++n;
        }
        return linkedHashSet.toArray(new HistoryProperty[0]);
    }

    public void setUseAutoSizeMaximums(boolean bl) {
        this._useAutoSizeMaximums = bl;
    }

    public void setModel(HistoryModel historyModel) {
        if (!this.m_tableInitialized) {
            this.initTable();
        }
        this._model = historyModel;
        TableModelAdapter tableModelAdapter = new TableModelAdapter(historyModel);
        tableModelAdapter.setUseAutoSizeMaximums(this._useAutoSizeMaximums);
        this._table.getSelectionModel().setValueIsAdjusting(true);
        this._table.setModel(tableModelAdapter);
        this._table.getTableHeader().setDefaultRenderer(new HeaderRenderer());
        this._table.setSorted(true);
        this._table.setSortColumn(0, true);
        this._table.getSelectionModel().setValueIsAdjusting(false);
        this._table.setSelectedRowsInModel(new int[0]);
        HistoryProperty[] historyPropertyArray = historyModel.getProperties();
        Object[] objectArray = new Object[historyPropertyArray.length];
        int n = 0;
        while (n < historyPropertyArray.length) {
            objectArray[n] = historyPropertyArray[n].getPrototypeValue();
            ++n;
        }
        this._table.autoSizeColumnsToFit(objectArray);
        List<HistoryProperty> list = Arrays.asList(historyModel.getDefaultProperties());
        int[] nArray = new int[historyPropertyArray.length - list.size()];
        int n2 = 0;
        int n3 = 0;
        while (n2 < historyPropertyArray.length) {
            if (!list.contains(historyPropertyArray[n2])) {
                nArray[n3++] = n2;
            }
            ++n2;
        }
        this._table.setHiddenColumns(nArray);
    }

    public HistoryEntry getSingleSelection() {
        HistoryEntry[] historyEntryArray = this.getSelection();
        if (historyEntryArray == null) {
            return null;
        }
        if (historyEntryArray.length == 0) {
            return null;
        }
        return historyEntryArray[0];
    }

    public void setSingleSelection(HistoryEntry historyEntry) {
        int n = 0;
        while (n < this.getTable().getModel().getRowCount()) {
            if (historyEntry.equals(this._model.getEntry(n))) {
                this.getTable().setSelectedRowsInModel(new int[]{n});
                return;
            }
            ++n;
        }
    }

    public HistoryEntry[] getSelection() {
        if (this._table == null) {
            return new HistoryEntry[0];
        }
        int n = this._table.getSelectedRowCount();
        if (n == -1) {
            return new HistoryEntry[0];
        }
        HistoryEntry[] historyEntryArray = new HistoryEntry[n];
        int[] nArray = this._table.getSelectedRowsInModel();
        int n2 = 0;
        while (n2 < n) {
            historyEntryArray[n2] = this._model.getEntry(nArray[n2]);
            ++n2;
        }
        return historyEntryArray;
    }

    public void dispose() {
        this.removeAll();
        this._scrollPane = null;
        this._table = null;
        this.m_tableInitialized = false;
        this._model = null;
    }

    public void setEditorMode(boolean bl) {
        if (this._scrollPane != null && bl) {
            this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this._scrollPane.setPreferredSize(new Dimension(0, 0));
        }
    }

    public HistoryComponent() {
        this.$init$();
    }

    private class StringCellRenderer
    extends NiceTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof String) {
                object = this.formatStringForRendering(object.toString());
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        private String formatStringForRendering(String string) {
            if (string.indexOf(10) < 0 && string.indexOf(13) < 0 && string.indexOf(12) < 0) {
                return string;
            }
            string = string.trim();
            StringBuffer stringBuffer = new StringBuffer();
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append("\\ ");
                    }
                    stringBuffer.append(string2.trim());
                }
                String string3 = stringBuffer.toString();
                return string3;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                String string4 = string;
                return string4;
            }
        }

        private StringCellRenderer() {
        }

        StringCellRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DateCellRenderer
    extends NiceTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof Date) {
                if (object == LIVE_DATE) {
                    this.setText(object.toString());
                } else {
                    DateFormat dateFormat = DateFormat.getDateTimeInstance();
                    this.setText(dateFormat.format((Date)object));
                }
            }
            return component;
        }

        private DateCellRenderer() {
        }

        DateCellRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class LiveDate
    extends Date {
        public LiveDate() {
            super(Long.MAX_VALUE);
        }

        public String toString() {
            return "";
        }

        public String toLocaleString() {
            return this.toString();
        }

        public String toGMTString() {
            return this.toString();
        }
    }
}

