/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.internal.ui;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.PrintStream;
import java.util.Timer;
import java.util.TimerTask;

public final class EventThreadHangMonitor
extends EventQueue {
    private static final EventQueue INSTANCE = new EventThreadHangMonitor();
    private static final long CHECK_INTERVAL_MS = 100L;
    private static final long UNREASONABLE_DISPATCH_DURATION_MS = 500L;
    private static final long NO_CURRENT_EVENT = 0L;
    private long startedLastEventDispatchAt;
    private boolean reportedHang;
    private Thread eventDispatchThread;

    void $init$() {
        this.startedLastEventDispatchAt = 0L;
        this.reportedHang = false;
        this.eventDispatchThread = null;
    }

    private EventThreadHangMonitor() {
        this.$init$();
        this.initTimer();
    }

    private void initTimer() {
        long l = 0L;
        boolean bl = true;
        Timer timer = new Timer("EventDispatchThreadHangMonitor", true);
        timer.schedule((TimerTask)new HangChecker(null), 0L, (long)100);
    }

    private long timeSoFar() {
        long l = System.currentTimeMillis();
        return l - this.startedLastEventDispatchAt;
    }

    public static void initMonitoring() {
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(INSTANCE);
    }

    protected void dispatchEvent(AWTEvent aWTEvent) {
        this.preDispatchEvent();
        super.dispatchEvent(aWTEvent);
        this.postDispatchEvent();
    }

    private synchronized void preDispatchEvent() {
        if (this.eventDispatchThread == null) {
            this.eventDispatchThread = Thread.currentThread();
        }
        this.reportedHang = false;
        this.startedLastEventDispatchAt = System.currentTimeMillis();
    }

    private synchronized void postDispatchEvent() {
        if (this.reportedHang) {
            System.out.println("--- event dispatch thread unstuck after " + this.timeSoFar() + " ms.");
        }
        this.startedLastEventDispatchAt = 0L;
    }

    static boolean ra$reportedHang(EventThreadHangMonitor eventThreadHangMonitor) {
        return eventThreadHangMonitor.reportedHang;
    }

    static void wa$reportedHang(EventThreadHangMonitor eventThreadHangMonitor, boolean bl) {
        eventThreadHangMonitor.reportedHang = bl;
    }

    static long mav$timeSoFar(EventThreadHangMonitor eventThreadHangMonitor) {
        return eventThreadHangMonitor.timeSoFar();
    }

    static Thread ra$eventDispatchThread(EventThreadHangMonitor eventThreadHangMonitor) {
        return eventThreadHangMonitor.eventDispatchThread;
    }

    static long ra$startedLastEventDispatchAt(EventThreadHangMonitor eventThreadHangMonitor) {
        return eventThreadHangMonitor.startedLastEventDispatchAt;
    }

    static EventQueue ra$INSTANCE() {
        return INSTANCE;
    }

    private class HangChecker
    extends TimerTask {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            EventQueue eventQueue = EventThreadHangMonitor.ra$INSTANCE();
            synchronized (eventQueue) {
                this.checkForHang();
            }
        }

        private void checkForHang() {
            if (EventThreadHangMonitor.ra$startedLastEventDispatchAt(EventThreadHangMonitor.this) == 0L) {
                return;
            }
            if (EventThreadHangMonitor.mav$timeSoFar(EventThreadHangMonitor.this) > 500L) {
                this.reportHang();
            }
        }

        private void reportHang() {
            if (EventThreadHangMonitor.ra$reportedHang(EventThreadHangMonitor.this)) {
                return;
            }
            EventThreadHangMonitor.wa$reportedHang(EventThreadHangMonitor.this, true);
            System.out.println("--- event dispatch thread stuck processing event for " + EventThreadHangMonitor.mav$timeSoFar(EventThreadHangMonitor.this) + " ms:");
            StackTraceElement[] stackTraceElementArray = EventThreadHangMonitor.ra$eventDispatchThread(EventThreadHangMonitor.this).getStackTrace();
            this.printStackTrace(System.out, stackTraceElementArray);
        }

        private void printStackTrace(PrintStream printStream, StackTraceElement[] stackTraceElementArray) {
            String string = EventThreadHangMonitor.class.getName();
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
            int n = 0;
            while (n < stackTraceElementArray2.length) {
                StackTraceElement stackTraceElement = stackTraceElementArray2[n];
                if (stackTraceElement.getClassName().equals(string)) {
                    return;
                }
                printStream.println("    " + stackTraceElement);
                ++n;
            }
        }

        private HangChecker() {
        }

        HangChecker(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

