/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.jndi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import oracle.javatools.jndi.DefaultNameParser;
import oracle.javatools.jndi.FlatContext;

final class HashContext
extends FlatContext {
    private final HashMap _bindings;
    private final HashMap _envMap;
    private final String _namePrefix;
    private static final Object SUBCONTEXT = new Object();

    HashContext(Hashtable hashtable) {
        this._bindings = new HashMap();
        this._envMap = new HashMap();
        this._namePrefix = "";
        if (hashtable != null) {
            this._envMap.put(this._namePrefix, new HashMap(hashtable));
        }
    }

    private HashContext(HashContext hashContext, String string) {
        this._bindings = hashContext._bindings;
        this._envMap = hashContext._envMap;
        this._namePrefix = string != null ? string : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookup(String string) throws NamingException {
        this.checkNameIsNotNull(string);
        if (string.length() == 0) {
            return new HashContext(this, this._namePrefix);
        }
        String string2 = this.getAbsoluteName(string);
        HashMap hashMap = this._bindings;
        synchronized (hashMap) {
            if (this._bindings.containsKey(string2)) {
                Object v = this._bindings.get(string2);
                Object object = v != SUBCONTEXT ? v : new HashContext(this, string2);
                return object;
            }
        }
        throw new NameNotFoundException("The name '" + string + "' is not bound in this context");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(String string, Object object) throws NamingException {
        this.checkNameIsNotEmpty(string);
        HashMap hashMap = this._bindings;
        synchronized (hashMap) {
            String string2 = this.getAbsoluteName(string);
            this.checkSubcontexts(string2);
            if (this._bindings.containsKey(string2)) {
                throw new NameAlreadyBoundException("JNDI spec requires the use of rebind() to overwrite an existing binding.");
            }
            this._bindings.put(string2, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebind(String string, Object object) throws NamingException {
        this.checkNameIsNotEmpty(string);
        HashMap hashMap = this._bindings;
        synchronized (hashMap) {
            String string2 = this.getAbsoluteName(string);
            this.checkSubcontexts(string2);
            Object v = this._bindings.get(string2);
            if (v == SUBCONTEXT) {
                throw new OperationNotSupportedException("The object bound to the name '" + string + "' is a subcontext, and rebinding of a subcontext is not supported by this Context implementation.");
            }
            this._bindings.put(string2, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(String string) throws NamingException {
        this.checkNameIsNotEmpty(string);
        HashMap hashMap = this._bindings;
        synchronized (hashMap) {
            String string2 = this.getAbsoluteName(string);
            Object v = this._bindings.get(string2);
            if (v == SUBCONTEXT) {
                this.checkSubcontextIsEmpty(string2);
            }
            this._bindings.remove(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String string, String string2) throws NamingException {
        this.checkNameIsNotEmpty(string);
        this.checkNameIsNotEmpty(string2);
        HashMap hashMap = this._bindings;
        synchronized (hashMap) {
            String string3 = this.getAbsoluteName(string);
            String string4 = this.getAbsoluteName(string2);
            this.checkSubcontexts(string4);
            if (!this._bindings.containsKey(string3)) {
                throw new NameNotFoundException("The name '" + string + "' is not bound in this context, so it cannot be renamed.");
            }
            if (this._bindings.containsKey(string4)) {
                throw new NameAlreadyBoundException("The name '" + string2 + "' is already bound in this context, so '" + string + "' cannot be renamed to '" + string2 + "'.");
            }
            this._bindings.put(string4, this._bindings.remove(string3));
        }
    }

    public NamingEnumeration list(String string) throws NamingException {
        return new NameEnum(string, false);
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        return new NameEnum(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySubcontext(String string) throws NamingException {
        this.checkNameIsNotEmpty(string);
        HashMap hashMap = this._bindings;
        synchronized (hashMap) {
            String string2 = this.getAbsoluteName(string);
            if (!this._bindings.containsKey(string2)) {
                throw new NameNotFoundException("The name '" + string + "' is not bound in this context, so there is no subcontext to destroy.");
            }
            if (this._bindings.get(string2) != SUBCONTEXT) {
                throw new NotContextException("The name '" + string + "' is bound to an object, not a subcontext.");
            }
            this.checkSubcontextIsEmpty(string2);
            this._bindings.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context createSubcontext(String string) throws NamingException {
        this.checkNameIsNotEmpty(string);
        HashMap hashMap = this._bindings;
        synchronized (hashMap) {
            String string2 = this.getAbsoluteName(string);
            this.checkSubcontexts(string2);
            if (this._bindings.containsKey(string2)) {
                throw new NameAlreadyBoundException("The name '" + string + "' is already bound in this context, so a subcontext with that name cannot be created.");
            }
            this._bindings.put(string2, SUBCONTEXT);
            HashMap hashMap2 = this._envMap;
            synchronized (hashMap2) {
                String string3;
                int n = string2.lastIndexOf("/");
                String string4 = string3 = n >= 0 ? string2.substring(0, n) : "";
                if (this._envMap.containsKey(string3)) {
                    HashMap hashMap3 = (HashMap)this._envMap.get(string3);
                    this._envMap.put(string2, new HashMap(hashMap3));
                }
            }
            HashContext hashContext = new HashContext(this, string2);
            return hashContext;
        }
    }

    public Object lookupLink(String string) throws NamingException {
        return this.lookup(string);
    }

    public NameParser getNameParser(String string) throws NamingException {
        return new DefaultNameParser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addToEnvironment(String string, Object object) throws NamingException {
        HashMap hashMap;
        if (string == null) {
            throw new NullPointerException("JNDI spec does not allow the context environment to have a property with a null name.");
        }
        HashMap hashMap2 = hashMap = this.findOrCreateContextEnv();
        synchronized (hashMap2) {
            Object object2 = hashMap.put(string, object);
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeFromEnvironment(String string) throws NamingException {
        HashMap hashMap = this.findContextEnv();
        if (hashMap == null) {
            return null;
        }
        HashMap hashMap2 = hashMap;
        synchronized (hashMap2) {
            Object v = hashMap.remove(string);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getEnvironment() throws NamingException {
        HashMap hashMap = this.findContextEnv();
        if (hashMap == null) {
            return new Hashtable(0);
        }
        HashMap hashMap2 = hashMap;
        synchronized (hashMap2) {
            Hashtable hashtable = new Hashtable(hashMap);
            return hashtable;
        }
    }

    public void close() throws NamingException {
    }

    public String getNameInNamespace() throws NamingException {
        return this._namePrefix;
    }

    private void checkNameIsNotNull(String string) throws InvalidNameException {
        if (string == null) {
            throw new InvalidNameException("A null name is not allowed for JNDI operations.");
        }
    }

    private void checkNameIsNotEmpty(String string) throws InvalidNameException {
        this.checkNameIsNotNull(string);
        if (string.length() == 0) {
            throw new InvalidNameException("An empty name is not allowed for this JNDI operation.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSubcontextIsEmpty(String string) throws ContextNotEmptyException {
        if (string == null || string.length() == 0) {
            throw new IllegalStateException("****  INTERNAL ERROR: empty subcontext name in checkSubcontextIsEmpty");
        }
        HashMap hashMap = this._bindings;
        synchronized (hashMap) {
            Iterator iterator = this._bindings.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next().toString();
                if (!string2.startsWith(string) || string2.equals(string)) continue;
                throw new ContextNotEmptyException("This JNDI operation requires the subcontext to be empty before proceeding.");
            }
        }
    }

    private void checkSubcontexts(String string) throws NamingException {
        int n = string.indexOf(47);
        while (n >= 0) {
            String string2 = string.substring(0, n);
            if (!this._bindings.containsKey(string2)) {
                throw new NameNotFoundException("There is no subcontext named '" + string2 + "'.  The JNDI spec requires that subcontexts be created first with the createSubcontext() method before binding objects.");
            }
            Object v = this._bindings.get(string2);
            if (v != SUBCONTEXT) {
                throw new NotContextException("Expecting a subcontext but found an object bound to the name '" + string2 + "'.");
            }
            n = string.indexOf(47, n + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap findContextEnv() {
        HashMap hashMap = this._envMap;
        synchronized (hashMap) {
            HashMap hashMap2 = (HashMap)this._envMap.get(this._namePrefix);
            return hashMap2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap findOrCreateContextEnv() {
        HashMap hashMap = this._envMap;
        synchronized (hashMap) {
            HashMap hashMap2 = this.findContextEnv();
            if (hashMap2 == null) {
                hashMap2 = new HashMap();
                this._envMap.put(this._namePrefix, hashMap2);
            }
            HashMap hashMap3 = hashMap2;
            return hashMap3;
        }
    }

    private String getAbsoluteName(String string) {
        if (string == null) {
            throw new IllegalStateException("****  INTERNAL ERROR: getAbsoluteName() received a null name.");
        }
        if (string.length() == 0) {
            return this._namePrefix;
        }
        return this._namePrefix.length() > 0 ? this._namePrefix + "/" + string : string;
    }

    private static HashContext newHashContext(HashContext hashContext, String string) {
        return new HashContext(hashContext, string);
    }

    static HashMap ra$_bindings(HashContext hashContext) {
        return hashContext._bindings;
    }

    static Object ra$SUBCONTEXT() {
        return SUBCONTEXT;
    }

    static HashContext maS$newHashContext(HashContext hashContext, String string) {
        return HashContext.newHashContext(hashContext, string);
    }

    private class NameEnum
    implements NamingEnumeration {
        private final int _absNamePrefixOffset;
        private final Iterator _names;
        private final boolean _wantBindings;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        NameEnum(String string, boolean bl) {
            int n = string.length();
            this._absNamePrefixOffset = n > 0 ? n + 1 : 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            HashMap hashMap = HashContext.ra$_bindings(HashContext.this);
            synchronized (hashMap) {
                Iterator iterator = HashContext.ra$_bindings(HashContext.this).keySet().iterator();
                while (iterator.hasNext()) {
                    String string2 = iterator.next().toString();
                    if ((n != 0 || string2.indexOf(47) >= 0) && (!string2.startsWith(string) || string2.equals(string) || string2.charAt(n) != '/' || string2.indexOf(47, this._absNamePrefixOffset) >= 0)) continue;
                    arrayList.add(string2);
                }
            }
            this._names = arrayList.iterator();
            this._wantBindings = bl;
        }

        public boolean hasMoreElements() {
            return this._names.hasNext();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            String string = this._names.next().toString();
            String string2 = string.substring(this._absNamePrefixOffset);
            Object v = HashContext.ra$_bindings(HashContext.this).get(string);
            if (this._wantBindings) {
                return new Binding(string2, v != HashContext.ra$SUBCONTEXT() ? v : HashContext.maS$newHashContext(HashContext.this, string2));
            }
            String string3 = v == HashContext.ra$SUBCONTEXT() ? HashContext.class.getName() : (v != null ? v.getClass().getName() : "null");
            return new NameClassPair(string2, string3);
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() {
        }
    }
}

