/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.jndi;

import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;

public final class Names {
    private static final InitialContext _templateContext;

    static {
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
        }
        catch (Exception exception) {
            initialContext = null;
        }
        _templateContext = initialContext;
    }

    public static InitialContext newInitialContext() {
        try {
            InitialContext initialContext = new InitialContext(_templateContext.getEnvironment());
            return initialContext;
        }
        catch (NoInitialContextException noInitialContextException) {
            throw Names.internalEx(noInitialContextException, "Unable to create an InitialContext.");
        }
        catch (NamingException namingException) {
            throw Names.internalEx(namingException, "Unexpected exception while trying to create InitialContext");
        }
    }

    public static Object lookup(Context context, String string) {
        try {
            Object object = context.lookup(string);
            return object;
        }
        catch (NameNotFoundException nameNotFoundException) {
            Object var5_4 = null;
            return var5_4;
        }
        catch (NamingException namingException) {
            throw Names.internalEx(namingException, "Unexpected exception while looking up object whose name is \"" + string + "\".");
        }
    }

    public static void bind(Context context, String string, Object object) {
        try {
            context.rebind(string, object);
        }
        catch (NameNotFoundException nameNotFoundException) {
            Names.ensureSubcontexts(context, string, 1);
            try {
                context.rebind(string, object);
            }
            catch (NamingException namingException) {
                throw Names.internalEx(namingException, "Unable to bind object whose name is \"" + string + "\" to the context.");
            }
        }
        catch (NamingException namingException) {
            throw Names.internalEx(namingException, "Unable to bind object whose name is \"" + string + "\" to the context.");
        }
    }

    public static void unbind(Context context, String string) {
        try {
            context.unbind(string);
        }
        catch (NamingException namingException) {
            throw Names.internalEx(namingException, "Unable to unbind object whose name is \"" + string + "\".");
        }
    }

    public static void createSubcontext(Context context, String string) {
        Names.ensureSubcontexts(context, string, 0);
    }

    private static void ensureSubcontexts(Context context, String string, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        int n2 = stringTokenizer.countTokens() - n;
        try {
            Context context2 = context;
            int n3 = 0;
            while (n3 < n2) {
                try {
                    context2 = context2.createSubcontext(stringTokenizer.nextToken());
                }
                catch (NameAlreadyBoundException nameAlreadyBoundException) {
                    // empty catch block
                }
                ++n3;
            }
        }
        catch (NamingException namingException) {
            throw Names.internalEx(namingException, "Unable to create necesary subcontexts for object \"" + string + "\".");
        }
    }

    private static IllegalStateException internalEx(Exception exception, String string) {
        IllegalStateException illegalStateException = new IllegalStateException(string);
        illegalStateException.initCause(exception);
        return illegalStateException;
    }

    private Names() {
    }
}

