/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.logging;

import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;

public class RegexLogFilter
implements Filter {
    private static final String _LOG_ALL = new String();
    private static final String _LOG_NONE = new String();

    public boolean isLoggable(LogRecord logRecord) {
        String string = this._getRegex(logRecord);
        if (string == _LOG_NONE) {
            return false;
        }
        if (string == _LOG_ALL) {
            return true;
        }
        String string2 = logRecord.getMessage();
        if (string2 == null) {
            return false;
        }
        Pattern pattern = Pattern.compile(string, 34);
        boolean bl = pattern.matcher(string2).matches();
        return bl;
    }

    private String _getRegex(LogRecord logRecord) {
        Level level = logRecord.getLevel();
        String string = logRecord.getLoggerName();
        String string2 = LogManager.getLogManager().getProperty(string + ".regex." + level);
        if (string2 == null) {
            return _LOG_ALL;
        }
        if (string2.length() == 0) {
            return _LOG_NONE;
        }
        return string2;
    }
}

