/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.marshal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.javatools.marshal.Character2String;
import oracle.javatools.marshal.Class2String;
import oracle.javatools.marshal.StringConversion;

public final class ToStringManager {
    private static final Class _stringClass = String.class;
    private static final Class _stringConversionClass = StringConversion.class;
    private static Map __fromStringMethodMap = new HashMap(23);
    private static Map __toStringMethodMap = new HashMap(23);
    private static Map __primitiveToWrapped = new HashMap(15);
    private static Set __stringConvertibles = new HashSet(23);

    static {
        __primitiveToWrapped.put(Integer.TYPE, Integer.class);
        __primitiveToWrapped.put(Long.TYPE, Long.class);
        __primitiveToWrapped.put(Short.TYPE, Short.class);
        __primitiveToWrapped.put(Float.TYPE, Float.class);
        __primitiveToWrapped.put(Double.TYPE, Double.class);
        __primitiveToWrapped.put(Character.TYPE, Character.class);
        __primitiveToWrapped.put(Byte.TYPE, Byte.class);
        __primitiveToWrapped.put(Boolean.TYPE, Boolean.class);
        ToStringManager.registerStringConvertible(_stringClass);
        ToStringManager.registerStringConvertible(Integer.class);
        ToStringManager.registerStringConvertible(Long.class);
        ToStringManager.registerStringConvertible(Short.class);
        ToStringManager.registerStringConvertible(Float.class);
        ToStringManager.registerStringConvertible(Double.class);
        ToStringManager.registerStringConvertible(Byte.class);
        ToStringManager.registerStringConvertible(Boolean.class);
        ToStringManager.registerStringConvertible(BigInteger.class);
        ToStringManager.registerStringConvertible(BigDecimal.class);
        ToStringManager.registerCustomConverter(Character2String.class);
        ToStringManager.registerCustomConverter(Class2String.class);
    }

    private ToStringManager() {
    }

    public static boolean registerStringConvertible(Class clazz) {
        if (clazz == null) {
            return false;
        }
        return __stringConvertibles.add(clazz);
    }

    public static boolean registerCustomConverter(Class clazz) {
        if (clazz == null) {
            return false;
        }
        Class clazz2 = null;
        try {
            if (!Modifier.isPublic(clazz.getModifiers())) {
                boolean bl = false;
                return bl;
            }
            Method method = clazz.getMethod("supportedClass", null);
            if (!Modifier.isPublic(method.getModifiers())) {
                boolean bl = false;
                return bl;
            }
            clazz2 = (Class)method.invoke(null, null);
            Class[] classArray = new Class[]{clazz2};
            Method method2 = clazz.getMethod("toString", classArray);
            int n = method2.getModifiers();
            if (!Modifier.isStatic(n) || !Modifier.isPublic(n)) {
                boolean bl = false;
                return bl;
            }
            if (method2.getReturnType() != _stringClass) {
                boolean bl = false;
                return bl;
            }
            Class[] classArray2 = new Class[]{_stringClass};
            Method method3 = clazz.getMethod("fromString", classArray2);
            int n2 = method3.getModifiers();
            if (!Modifier.isStatic(n2) || !Modifier.isPublic(n2)) {
                boolean bl = false;
                return bl;
            }
            if (method3.getReturnType() != clazz2) {
                boolean bl = false;
                return bl;
            }
            __toStringMethodMap.put(clazz2, method2);
            __fromStringMethodMap.put(clazz2, method3);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            boolean bl = false;
            return bl;
        }
        catch (InvocationTargetException invocationTargetException) {
            boolean bl = false;
            return bl;
        }
        catch (IllegalAccessException illegalAccessException) {
            boolean bl = false;
            return bl;
        }
        catch (NullPointerException nullPointerException) {
            boolean bl = false;
            return bl;
        }
        catch (ClassCastException classCastException) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public static Class wrapPrimitive(Class clazz) {
        if (clazz == null) {
            return null;
        }
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        return (Class)__primitiveToWrapped.get(clazz);
    }

    public static boolean converterAvailable(Object object) {
        if (object == null) {
            return false;
        }
        return ToStringManager.converterAvailable(object.getClass());
    }

    public static boolean converterAvailable(String string) {
        if (string == null) {
            return false;
        }
        try {
            boolean bl = ToStringManager.converterAvailable(Class.forName(string));
            return bl;
        }
        catch (ClassNotFoundException classNotFoundException) {
            boolean bl = false;
            return bl;
        }
    }

    public static boolean converterAvailable(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz.isPrimitive()) {
            return true;
        }
        if (__stringConvertibles.contains(clazz) || _stringConversionClass.isAssignableFrom(clazz)) {
            return true;
        }
        return __toStringMethodMap.containsKey(clazz) && __fromStringMethodMap.containsKey(clazz);
    }

    public static String toString(Object object) {
        if (object == null) {
            return null;
        }
        return ToStringManager.toString(object, object.getClass());
    }

    public static String toString(Object object, Class clazz) {
        if (object == null || clazz == null) {
            return null;
        }
        if (clazz.isPrimitive()) {
            clazz = (Class)__primitiveToWrapped.get(clazz);
        }
        if (!clazz.isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException("obj cannot be printed as objClass");
        }
        if (__stringConvertibles.contains(clazz) || _stringConversionClass.isAssignableFrom(clazz)) {
            return object.toString();
        }
        if (__toStringMethodMap.containsKey(clazz)) {
            Method method = (Method)__toStringMethodMap.get(clazz);
            Object[] objectArray = new Object[]{object};
            try {
                String string = (String)method.invoke(null, objectArray);
                return string;
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            return null;
        }
        throw new UnsupportedOperationException("Unable to convert the given object to a String: " + object != null ? object.getClass().getName() : "null");
    }

    public static Object fromString(String string, Class clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz == _stringClass) {
            return string;
        }
        if (clazz.isPrimitive()) {
            clazz = (Class)__primitiveToWrapped.get(clazz);
        }
        if (__stringConvertibles.contains(clazz) || _stringConversionClass.isAssignableFrom(clazz)) {
            try {
                Class[] classArray = new Class[]{_stringClass};
                Constructor constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{string};
                Object t = constructor.newInstance(objectArray);
                return t;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        if (__fromStringMethodMap.containsKey(clazz)) {
            Method method = (Method)__fromStringMethodMap.get(clazz);
            Object[] objectArray = new Object[]{string};
            try {
                Object object = method.invoke(null, objectArray);
                return object;
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            return null;
        }
        throw new UnsupportedOperationException("Unable to convert the String \"" + string + "\" to an Object of type " + clazz.getName());
    }
}

