/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.marshal.xml;

import java.lang.reflect.Method;
import oracle.javatools.marshal.ToStringManager;

public final class PropertyInfo
implements Comparable {
    private final String _xmlName;
    private final Method _readMethod;
    private final Method _writeMethod;
    private final boolean _isAttribute;
    private final boolean _isOmittedWhenNull;

    PropertyInfo(String string, Class clazz, String string2, String string3, boolean bl) {
        this(string, clazz, string2, string3, bl, false);
    }

    PropertyInfo(String string, Class clazz, String string2, String string3, boolean bl, boolean bl2) {
        this._xmlName = string;
        try {
            this._readMethod = clazz.getMethod(string2, null);
            Class<?> clazz2 = this._readMethod.getReturnType();
            Class[] classArray = new Class[]{clazz2};
            this._writeMethod = clazz.getMethod(string3, classArray);
        }
        catch (Exception exception) {
            String string4 = "\n#######  Error in " + (clazz != null ? clazz.getName() : "null") + " PropertyInfo with XML name = '" + string + "', getter = '" + string2 + "', setter = '" + string3 + "'  #######\n";
            System.err.println(string4);
            throw new IllegalArgumentException(string4);
        }
        this._isAttribute = this.initIsAttribute(bl);
        this._isOmittedWhenNull = bl2;
    }

    PropertyInfo(String string, Method method, Method method2, boolean bl, boolean bl2) {
        this._xmlName = string;
        this._readMethod = method;
        this._writeMethod = method2;
        this._isAttribute = this.initIsAttribute(bl);
        this._isOmittedWhenNull = bl2;
    }

    private boolean initIsAttribute(boolean bl) {
        if (bl) {
            Class<?> clazz = this._readMethod.getReturnType();
            if (ToStringManager.converterAvailable(clazz)) {
                return true;
            }
            System.err.println("***  Warning: There is no String converter for " + clazz.toString() + ", so this property will be saved as an element instead of an attribute.");
        }
        return false;
    }

    public String getXMLName() {
        return this._xmlName;
    }

    public Class getPropertyClass() {
        return this._readMethod.getReturnType();
    }

    public Object getPropertyValue(Object object) {
        try {
            Object object2 = this._readMethod.invoke(object, null);
            return object2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Object var4_4 = null;
            return var4_4;
        }
    }

    public void setPropertyValue(Object object, Object object2) throws Exception {
        Object[] objectArray = new Object[]{object2};
        this._writeMethod.invoke(object, objectArray);
    }

    Method getReadMethod() {
        return this._readMethod;
    }

    Method getWriteMethod() {
        return this._writeMethod;
    }

    public boolean isAttribute() {
        return this._isAttribute;
    }

    public boolean isOmittedWhenNull() {
        return this._isOmittedWhenNull;
    }

    public int compareTo(Object object) {
        if (object == null) {
            return 1;
        }
        PropertyInfo propertyInfo = (PropertyInfo)object;
        if (this.equalsImpl(propertyInfo)) {
            return 0;
        }
        return this._xmlName.compareTo(propertyInfo._xmlName);
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((PropertyInfo)object);
    }

    private boolean equalsImpl(PropertyInfo propertyInfo) {
        return PropertyInfo.areEqual(this._xmlName, propertyInfo._xmlName) && PropertyInfo.areEqual(this._readMethod, propertyInfo._readMethod) && PropertyInfo.areEqual(this._writeMethod, propertyInfo._writeMethod) && this._isAttribute == propertyInfo._isAttribute && this._isOmittedWhenNull == propertyInfo._isOmittedWhenNull;
    }

    private static boolean areEqual(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }
}

