/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.marshal.xml;

import java.beans.Introspector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import oracle.javatools.marshal.AttributeMarker;
import oracle.javatools.marshal.OmittedWhenNullMarker;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.marshal.xml.PropertyInfo;

public final class PropertyIterator {
    private static final HashMap _infoCache = new HashMap();
    private final PropertyInfo[] _propertyInfos;
    private int _curIndex;

    void $init$() {
        this._curIndex = 0;
    }

    public PropertyIterator(Object object) {
        this.$init$();
        this._propertyInfos = object != null ? PropertyIterator.getPropertyInfos(object.getClass()) : null;
    }

    public boolean hasNext() {
        return this._propertyInfos == null ? false : this._curIndex < this._propertyInfos.length;
    }

    public PropertyInfo next() {
        return this._propertyInfos[this._curIndex++];
    }

    private static PropertyInfo[] getPropertyInfos(Class clazz) {
        Object v = _infoCache.get(clazz);
        if (v != null) {
            return (PropertyInfo[])v;
        }
        PropertyInfo[] propertyInfoArray = PropertyIterator.getExplicitPropertyInfos(clazz);
        if (propertyInfoArray != null) {
            _infoCache.put(clazz, propertyInfoArray);
            return propertyInfoArray;
        }
        Method[] methodArray = clazz.getMethods();
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        int n = methodArray.length - 1;
        while (n >= 0) {
            Method method = methodArray[n];
            String string = method.getName();
            if (string.startsWith("get") && PropertyIterator.hasNoParameters(method) && PropertyIterator.isPersistent(method)) {
                String string2 = string.substring(3);
                hashMap.put(string2, method);
            } else if (string.startsWith("is") && PropertyIterator.hasNoParameters(method) && PropertyIterator.hasBooleanReturnType(method) && PropertyIterator.isPersistent(method)) {
                String string3 = string.substring(2);
                hashMap.put(string3, method);
            }
            --n;
        }
        ArrayList<PropertyInfo> arrayList = new ArrayList<PropertyInfo>();
        int n2 = methodArray.length - 1;
        while (n2 >= 0) {
            Method method;
            Class<?> clazz2;
            Method method2;
            Class<?> clazz3;
            String string;
            Method method3 = methodArray[n2];
            String string4 = method3.getName();
            if (string4.startsWith("set") && PropertyIterator.hasOneParameter(method3) && PropertyIterator.hasVoidReturnType(method3) && hashMap.containsKey(string = string4.substring(3)) && (clazz3 = (method2 = (Method)hashMap.get(string)).getReturnType()) == (clazz2 = (method = method3).getParameterTypes()[0])) {
                String string5 = Introspector.decapitalize(string);
                boolean bl = PropertyIterator.isAttribute(method2);
                boolean bl2 = PropertyIterator.isOmittedWhenNull(method2);
                PropertyInfo propertyInfo = new PropertyInfo(string5, method2, method, bl, bl2);
                arrayList.add(propertyInfo);
            }
            --n2;
        }
        Object[] objectArray = arrayList.toArray(new PropertyInfo[0]);
        Arrays.sort(objectArray);
        _infoCache.put(clazz, objectArray);
        return objectArray;
    }

    private static PropertyInfo[] getExplicitPropertyInfos(Class clazz) {
        try {
            Method method = clazz.getMethod("getPropertyInfos", null);
            PropertyInfo[] propertyInfoArray = (PropertyInfo[])method.invoke(null, null);
            return propertyInfoArray;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static boolean hasNoParameters(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        return classArray.length == 0;
    }

    private static boolean hasOneParameter(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        return classArray.length == 1;
    }

    private static boolean hasBooleanReturnType(Method method) {
        Class<?> clazz = method.getReturnType();
        return clazz == Boolean.TYPE;
    }

    private static boolean hasVoidReturnType(Method method) {
        Class<?> clazz = method.getReturnType();
        return clazz == Void.TYPE;
    }

    private static boolean isPersistent(Method method) {
        return PropertyIterator.throwsException(method, TransientMarker.class) ^ true;
    }

    private static boolean isOmittedWhenNull(Method method) {
        return PropertyIterator.throwsException(method, OmittedWhenNullMarker.class);
    }

    private static boolean isAttribute(Method method) {
        return PropertyIterator.throwsException(method, AttributeMarker.class);
    }

    private static boolean throwsException(Method method, Class clazz) {
        Class<?>[] classArray = method.getExceptionTypes();
        int n = classArray.length - 1;
        while (n >= 0) {
            if (classArray[n] == clazz) {
                return true;
            }
            --n;
        }
        return false;
    }
}

