/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.BitSet;

public class EncoderUtils {
    private static final int _MAX_BYTES_PER_CHAR = 10;
    private static final BitSet _DONT_ENCODE_SET = new BitSet(256);
    private static final BitSet _DONT_ENCODE_SET_SMALL = new BitSet(256);

    public static String encodeURL(String string, String string2, boolean bl) throws UnsupportedEncodingException {
        StringWriter stringWriter = new StringWriter(string.length());
        try {
            EncoderUtils.writeURL(stringWriter, string, string2, bl);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw unsupportedEncodingException;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public static void writeURL(Writer writer, String string, String string2, boolean bl) throws IOException, UnsupportedEncodingException {
        EncoderUtils._writeURL(writer, string, string2, bl, 0, false);
    }

    public static void writeQueryParameters(Writer writer, String string, String string2, int n) throws IOException, UnsupportedEncodingException {
        EncoderUtils._encodeString(writer, string, string2, n, _DONT_ENCODE_SET, true);
    }

    public static String encodeUIXQueryParameter(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (EncoderUtils._isSpecialQueryParameterChar(c)) {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.setLength(n2);
                EncoderUtils._appendUIXQueryParameter(stringBuffer, string, n2);
                return new String(stringBuffer);
            }
            ++n2;
        }
        return string;
    }

    public static void appendUIXQueryParameter(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string);
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (EncoderUtils._isSpecialQueryParameterChar(c)) {
                stringBuffer.setLength(stringBuffer.length() - (n - n2));
                EncoderUtils._appendUIXQueryParameter(stringBuffer, string, n2);
                break;
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void _writeURL(Writer writer, String string, String string2, boolean bl, int n, boolean bl2) throws IOException, UnsupportedEncodingException {
        int n2 = string.length();
        int n3 = n;
        while (n3 < n2) {
            block10: {
                char c;
                block11: {
                    block13: {
                        block12: {
                            c = string.charAt(n3);
                            if (c >= '!' && c <= '~') break block11;
                            if (!bl) break block12;
                            EncoderUtils._writeDoubleHex(writer, c);
                            break block10;
                        }
                        if (c > '\u007f') break block13;
                        EncoderUtils._writeDoubleHex(writer, c);
                        break block10;
                    }
                    if (c <= '\u07ff') {
                        int n4 = c >> 6 | 0xC0;
                        int n5 = c & 0x3F | 0x80;
                        EncoderUtils._writeDoubleHex(writer, n4);
                        EncoderUtils._writeDoubleHex(writer, n5);
                        break block10;
                    } else if ((c & 0xFC00) == 55296) {
                        int n6 = c & 0x3FF;
                        int n7 = (n6 & 0x3C0) >> 6;
                        int n8 = n7 + 1;
                        int n9 = (n6 & 0x3C) >> 2;
                        int n10 = (n6 & 3) << 4 & 0x30;
                        c = ++n3 < n2 ? string.charAt(n3) : (char)'\u0000';
                        int n11 = c & 0x3FF;
                        int n12 = n11 & 0x3F;
                        int n13 = 0xF0 | n8 >> 2;
                        int n14 = 0x80 | (n8 & 3) << 4 & 0x30 | n9;
                        int n15 = 0x80 | (n10 |= (n11 & 0x3C0) >> 6);
                        int n16 = 0x80 | n12;
                        EncoderUtils._writeDoubleHex(writer, n13);
                        EncoderUtils._writeDoubleHex(writer, n14);
                        EncoderUtils._writeDoubleHex(writer, n15);
                        EncoderUtils._writeDoubleHex(writer, n16);
                        break block10;
                    } else {
                        int n17 = c >> 12 | 0xE0;
                        int n18 = (c & 0xFC0) >> 6 | 0x80;
                        int n19 = c & 0x3F | 0x80;
                        EncoderUtils._writeDoubleHex(writer, n17);
                        EncoderUtils._writeDoubleHex(writer, n18);
                        EncoderUtils._writeDoubleHex(writer, n19);
                    }
                    break block10;
                }
                if (c == '\"') {
                    writer.write("%22");
                } else if (c == '?') {
                    if (!bl2) {
                        writer.write(63);
                        EncoderUtils.writeQueryParameters(writer, string, string2, n3 + 1);
                        return;
                    }
                    writer.write("%3F");
                } else {
                    writer.write(c);
                }
            }
            ++n3;
        }
    }

    private static boolean _isSpecialQueryParameterChar(char c) {
        return c == '%' || c == '+' || c == '&' || c == '#';
    }

    private static void _appendUIXQueryParameter(StringBuffer stringBuffer, String string, int n) {
        int n2 = string.length();
        int n3 = n;
        while (n3 < n2) {
            char c = string.charAt(n3);
            switch (c) {
                case '#': {
                    stringBuffer.append("%23");
                    break;
                }
                case '&': {
                    stringBuffer.append("%26");
                    break;
                }
                case '%': {
                    stringBuffer.append("%25");
                    break;
                }
                case '+': {
                    stringBuffer.append("%2b");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n3;
        }
    }

    public static String encodeString(String string, String string2) throws UnsupportedEncodingException {
        StringWriter stringWriter = new StringWriter(string.length());
        try {
            EncoderUtils._encodeString(stringWriter, string, string2, 0, _DONT_ENCODE_SET_SMALL, false);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw unsupportedEncodingException;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public static String decodeString(String string, String string2) throws UnsupportedEncodingException {
        int n = string.indexOf(37);
        if (n < 0) {
            return string;
        }
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        stringBuffer.append(string);
        stringBuffer.setLength(n);
        byte[] byArray = null;
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            char c = string.charAt(n4);
            if (c != '%') {
                if (n3 > 0) {
                    stringBuffer.append(new String(byArray, 0, n3, string2));
                    n3 = 0;
                }
                stringBuffer.append(c);
            } else {
                if (n4 + 2 < n2) {
                    byte by = (byte)(EncoderUtils._fromHex(string.charAt(n4 + 1)) << 4 | EncoderUtils._fromHex(string.charAt(n4 + 2)));
                    if (string2 == null) {
                        stringBuffer.append((char)by);
                    } else {
                        if (byArray == null) {
                            byArray = new byte[10];
                        } else if (byArray.length == n3) {
                            byte[] byArray2 = new byte[n3 * 2];
                            System.arraycopy(byArray, 0, byArray2, 0, n3);
                            byArray = byArray2;
                        }
                        byArray[n3] = by;
                        ++n3;
                    }
                }
                n4 += 2;
            }
            ++n4;
        }
        if (n3 > 0) {
            stringBuffer.append(new String(byArray, 0, n3, string2));
        }
        return new String(stringBuffer);
    }

    private static void _encodeString(Writer writer, String string, String string2, int n, BitSet bitSet, boolean bl) throws IOException, UnsupportedEncodingException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        char[] cArray = null;
        int n2 = string.length();
        int n3 = n;
        while (n3 < n2) {
            block8: {
                char c = string.charAt(n3);
                if (bl && '#' == c) {
                    writer.write(c);
                    EncoderUtils._writeURL(writer, string, string2, false, n3 + 1, true);
                    return;
                }
                if (bitSet.get(c)) {
                    writer.write(c);
                } else {
                    if (byteArrayOutputStream == null) {
                        byteArrayOutputStream = new ByteArrayOutputStream(10);
                        outputStreamWriter = string2 != null ? new OutputStreamWriter((OutputStream)byteArrayOutputStream, string2) : new OutputStreamWriter(byteArrayOutputStream);
                        cArray = new char[1];
                    }
                    try {
                        cArray[0] = c;
                        outputStreamWriter.write(cArray, 0, 1);
                        outputStreamWriter.flush();
                    }
                    catch (IOException iOException) {
                        byteArrayOutputStream.reset();
                        break block8;
                    }
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    int n4 = 0;
                    while (n4 < byArray.length) {
                        EncoderUtils._writeDoubleHex(writer, byArray[n4] + 256);
                        ++n4;
                    }
                    byteArrayOutputStream.reset();
                }
            }
            ++n3;
        }
    }

    private static void _writeDoubleHex(Writer writer, int n) throws IOException {
        writer.write(37);
        writer.write(EncoderUtils._getHex((n >> 4) % 16));
        writer.write(EncoderUtils._getHex(n % 16));
    }

    private static char _getHex(int n) {
        if (n < 10) {
            return (char)(48 + n);
        }
        return (char)(65 + (n - 10));
    }

    private static byte _fromHex(char c) {
        if (c >= '0' && c <= '9') {
            return (byte)(c - 48);
        }
        if (c >= 'a' && c <= 'f') {
            return (byte)(10 + (c - 97));
        }
        return (byte)(10 + (c - 65));
    }

    static {
        int n = 97;
        while (n <= 122) {
            _DONT_ENCODE_SET.set(n);
            _DONT_ENCODE_SET_SMALL.set(n);
            ++n;
        }
        int n2 = 65;
        while (n2 <= 90) {
            _DONT_ENCODE_SET.set(n2);
            _DONT_ENCODE_SET_SMALL.set(n2);
            ++n2;
        }
        int n3 = 48;
        while (n3 <= 57) {
            _DONT_ENCODE_SET.set(n3);
            _DONT_ENCODE_SET_SMALL.set(n3);
            ++n3;
        }
        _DONT_ENCODE_SET.set(37);
        _DONT_ENCODE_SET.set(43);
        _DONT_ENCODE_SET.set(35);
        _DONT_ENCODE_SET.set(38);
        _DONT_ENCODE_SET.set(61);
        _DONT_ENCODE_SET.set(45);
        _DONT_ENCODE_SET_SMALL.set(45);
        _DONT_ENCODE_SET.set(95);
        _DONT_ENCODE_SET_SMALL.set(95);
        _DONT_ENCODE_SET.set(46);
        _DONT_ENCODE_SET_SMALL.set(46);
        _DONT_ENCODE_SET.set(42);
        _DONT_ENCODE_SET.set(126);
        _DONT_ENCODE_SET.set(47);
        _DONT_ENCODE_SET_SMALL.set(47);
        _DONT_ENCODE_SET.set(39);
        _DONT_ENCODE_SET.set(33);
        _DONT_ENCODE_SET.set(40);
        _DONT_ENCODE_SET.set(41);
    }
}

