/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.editor.resource.BundleHelper;
import oracle.javatools.parser.GrammarProduction;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.SyntaxListener;
import oracle.javatools.parser.SyntaxStack;

public abstract class AbstractSyntaxRecognizer {
    private static final boolean DEBUG_PRINT_STACK_ON_INTERNAL = true;
    private static final int SYNTAX_ERROR_THRESHOLD = 1000;
    private static final int kEofThreshold = 25;
    public static final int SYNTAX_EOF = 0;
    public static final int SYNTAX_ERROR = 1;
    public static final int SYNTAX_ROOT = 10;
    public static final int TK_EOF = 0;
    protected int debugLevel;
    public static final boolean DEBUG_OUTPUT = false;
    protected Lexer lexer;
    protected LexerToken curLexerToken;
    protected LexerToken peekingToken;
    protected int curToken;
    private int lastTokenOffset;
    private int lastErrorCheckpoint;
    private int lastErrorOffset;
    protected SyntaxListener listener;
    private SyntaxStack stack;
    private GrammarProduction top;
    private int inheritStartOffset;
    private int lastEndOffset;
    private int syntaxErrorCount;
    private int eofCount;
    public static final int DEBUGLEVEL_MINIMAL = 0;
    public static final int DEBUGLEVEL_HIGH = 1;
    protected static final String INTERNALERR_BACKUP_NOT_IMPLEMENTED_YET = "backup() not implemented yet";
    protected static final String INTERNALERR_BACKEDUP_TWICE = "Called prevToken twice";
    protected static final String INTERNALERR_CANT_ACCESS_LEXER_TOKEN_ON_BACKUP = "Can't access the lexer token if we've backed up";
    public static final String SYNTAXERR_SKIPPING;
    private static final String SYNTAXERR_EOF;
    private static final String SYNTAXERR_EXITING;
    private static final String SYNTAXERR_UNEXPECTED;
    private static final String SYNTAXERR_UNIMPLEMENTED;
    protected static final BundleHelper resources;

    static {
        resources = new BundleHelper("oracle.javatools.parser.resource.ParserBundle");
        SYNTAXERR_SKIPPING = resources.getString("PARSER_ERROR_SKIPPING");
        SYNTAXERR_EOF = resources.getString("PARSER_ERROR_EOF");
        SYNTAXERR_EXITING = resources.getString("PARSER_ERROR_EXITING");
        SYNTAXERR_UNEXPECTED = resources.getString("PARSER_ERROR_UNEXPECTED");
        SYNTAXERR_UNIMPLEMENTED = resources.getString("PARSER_ERROR_UNIMPLEMENTED");
    }

    void $init$() {
        this.debugLevel = 0;
        this.listener = null;
        this.inheritStartOffset = -1;
        this.lastEndOffset = -1;
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public void setDebugLevel(int n) {
        this.debugLevel = n;
    }

    public Lexer getLexer() {
        return this.lexer;
    }

    public void initialize(Lexer lexer) {
        this.stack = new SyntaxStack();
        this.top = this.stack.pushNewGP();
        this.lexer = lexer;
        this.curLexerToken = lexer.createLexerToken();
        this.peekingToken = lexer.createLexerToken();
        this.curToken = lexer.lex(this.curLexerToken);
        this.syntaxErrorCount = 0;
        this.eofCount = 0;
        this.lastTokenOffset = 0;
        this.lastErrorCheckpoint = -1;
        this.lastErrorOffset = -1;
    }

    public void initialize(ReadTextBuffer readTextBuffer) {
        Lexer lexer = this.instantiatePreferredLexer();
        lexer.setTextBuffer(readTextBuffer);
        this.initialize(lexer);
    }

    public void initialize(ReadTextBuffer readTextBuffer, int n) {
        Lexer lexer = this.instantiatePreferredLexer();
        lexer.setTextBuffer(readTextBuffer);
        lexer.setPosition(n);
        this.initialize(lexer);
    }

    public void setListener(SyntaxListener syntaxListener) {
        this.listener = syntaxListener;
    }

    public abstract void parse();

    public abstract Lexer instantiatePreferredLexer();

    protected int getCode() {
        return this.top.syntaxCode;
    }

    protected int getDataValue() {
        return this.top.data;
    }

    protected void setDataValue(int n) {
        this.top.data = n;
    }

    protected String getContextString() {
        return this.top.contextString;
    }

    protected void setContextString(String string) {
        this.top.contextString = string;
    }

    protected void copyStartOffset() {
        this.inheritStartOffset = this.top.startOffset;
    }

    protected String curTokenToString() {
        int n = this.curLexerToken.getStartOffset();
        int n2 = this.curLexerToken.getEndOffset();
        return this.lexer.getTextBuffer().getString(n, n2 - n);
    }

    private void generateToken() {
        if (this.listener != null) {
            this.listener.receive(this.top, this.top.syntaxCode);
        }
    }

    private void newGrammarProduction(int n, boolean bl) {
        String string = this.top.contextString;
        this.top = this.stack.pushNewGP();
        this.top.syntaxCode = n;
        this.top.contextString = string;
        if (this.inheritStartOffset >= 0) {
            this.top.startOffset = this.inheritStartOffset;
            this.inheritStartOffset = -1;
        } else {
            this.top.startOffset = this.curLexerToken.getStartOffset();
        }
        if (bl) {
            this.generateToken();
        }
    }

    private void endGrammarProduction(boolean bl) {
        this.top.endOffset = bl ? this.lastEndOffset : this.curLexerToken.getEndOffset();
        this.lastEndOffset = this.top.endOffset;
        this.generateToken();
        this.stack.pop();
        this.top = this.stack.peek();
    }

    private void errorGrammarProduction(String string, int n, boolean bl) {
        this.startQuiet(1);
        this.setContextString(string);
        this.setDataValue(n);
        if (bl) {
            this.top.startOffset = this.lastTokenOffset;
            this.top.endOffset = this.lastTokenOffset + 1;
        }
        int n2 = this.top.startOffset;
        boolean bl2 = false;
        if (n != 0) {
            bl2 = n2 == this.lastErrorOffset;
        } else {
            boolean bl3 = bl2 = n2 <= this.lastErrorOffset;
        }
        if (bl2) {
            this.stack.pop();
            this.top = this.stack.peek();
            return;
        }
        this.lastErrorOffset = n2;
        if (bl) {
            this.generateToken();
            this.stack.pop();
            this.top = this.stack.peek();
        } else {
            this.finish();
        }
    }

    protected final int peekToken() {
        int n = this.lexer.lex(this.peekingToken);
        this.lexer.backup();
        return n;
    }

    protected final boolean nextToken(int n) {
        if (this.curToken == n) {
            this.skipToken();
            return true;
        }
        this.errorExpecting(n);
        return false;
    }

    protected final boolean nextToken(int n, int n2) {
        if (this.curToken == n2) {
            this.skipToken();
            return true;
        }
        this.nextToken(n);
        return false;
    }

    protected final boolean optionalToken(int n) {
        if (this.curToken == n) {
            this.skipToken();
            return true;
        }
        return false;
    }

    protected final void skipToken() {
        if (this.curToken == 0) {
            this.errorEof();
        }
        this.lastTokenOffset = this.curLexerToken.getEndOffset();
        this.curToken = this.lexer.lex(this.curLexerToken);
    }

    protected final void start(int n) {
        this.newGrammarProduction(n, true);
    }

    protected final void startQuiet(int n) {
        this.newGrammarProduction(n, false);
    }

    protected final void finishInherit() {
        this.endGrammarProduction(true);
    }

    protected final void finish() {
        this.endGrammarProduction(false);
    }

    protected final void finishToken() {
        this.endGrammarProduction(false);
        this.skipToken();
    }

    protected final void finishToken(int n) {
        if (this.curToken == n) {
            this.finishToken();
        } else {
            this.errorExpecting(n);
            this.endGrammarProduction(false);
        }
    }

    protected final void finishToken(int n, int n2) {
        if (this.curToken == n2) {
            this.finishToken();
        } else {
            this.finishToken(n);
        }
    }

    public String _codeToString(int n) {
        return "Unknown syntax code ( " + n + " )";
    }

    protected final boolean errorCheckpoint() {
        boolean bl;
        int n = this.top.startOffset;
        boolean bl2 = bl = this.lastErrorCheckpoint != n;
        if (!bl) {
            this.errorUnexpected();
        }
        this.lastErrorCheckpoint = n;
        return bl;
    }

    protected void notImplementedYet(String string) {
        int n = SYNTAXERR_UNIMPLEMENTED.indexOf("{0}");
        if (n == -1) {
            this.reportSyntaxError(SYNTAXERR_UNIMPLEMENTED);
        } else {
            StringBuffer stringBuffer = new StringBuffer(SYNTAXERR_UNIMPLEMENTED);
            stringBuffer.replace(n, n + 3, string);
            this.reportSyntaxError(stringBuffer.toString());
        }
    }

    protected void errorExpecting(int n) {
        this.reportSyntaxError("Expecting token " + n);
    }

    protected void errorUnexpected() {
        this.errorUnexpected(true);
    }

    protected void errorUnexpected(boolean bl) {
        this.reportSyntaxError(SYNTAXERR_UNEXPECTED);
        if (bl) {
            this.skipToken();
        }
    }

    protected final void errorEof() {
        if (this.eofCount++ > 25) {
            throw new EOFException("SyntaxRecognizer hit EOF", null);
        }
        this.reportSyntaxError(SYNTAXERR_EOF);
    }

    protected void reportSyntaxError(String string) {
        this.reportSyntaxError(string, 0, false);
    }

    protected void reportSyntaxError(String string, boolean bl) {
        this.reportSyntaxError(string, 0, bl);
    }

    protected void reportSyntaxError(String string, int n, boolean bl) {
        String string2 = this.top.contextString;
        String string3 = string2 + ": " + string;
        String string4 = this._codeToString(this.top.syntaxCode);
        if (this.debugLevel == 0) {
            String string5 = "Resolving " + string4 + ":\n\t- " + string3 + "\n\t- Current token is (" + this.curToken + ")";
            throw new RuntimeException(string5);
        }
        this.errorGrammarProduction(string3, n, bl);
        ++this.syntaxErrorCount;
        if (1000 < this.syntaxErrorCount) {
            this.startQuiet(1);
            this.setContextString(SYNTAXERR_EXITING);
            this.finish();
            throw new RuntimeException("Hit the max errors. Exiting.");
        }
    }

    protected void internalError(String string) {
        String string2 = this._codeToString(this.top.syntaxCode);
        String string3 = "JavaSyntaxRecognizer internal error, in " + string2 + ": " + string;
        this.reportSyntaxError(string3);
        RuntimeException runtimeException = new RuntimeException(string3);
        runtimeException.printStackTrace();
        throw new RuntimeException(string3);
    }

    protected void _assert(boolean bl) {
        if (!bl) {
            this.internalError("assertion fail");
        }
    }

    public AbstractSyntaxRecognizer() {
        this.$init$();
    }

    private class EOFException
    extends RuntimeException {
        private EOFException(String string) {
            super(string);
        }

        EOFException(String string, 1 var3_3) {
            this(string);
        }

        public final class 1 {
        }
    }
}

