/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.css;

import java.io.IOException;
import java.io.Reader;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.css.CSSTokens;
import oracle.javatools.parser.css.ParseException;
import oracle.javatools.parser.css.Tokenizer;

public class CSSLexer
extends AbstractLexer
implements CSSTokens {
    protected int _mLastToken;
    protected int _mStartOffset;
    protected int _mEndOffset;
    protected boolean _mUseLastToken;
    protected Tokenizer _mTokenizer;
    protected TextBufferReader _mReader;
    protected BasicDocument _mDocument;

    public void setDocument(BasicDocument basicDocument) {
        this._mDocument = basicDocument;
    }

    public void setPosition(int n) {
        super.setPosition(n);
        this.resetTokenizer();
    }

    public int lex(LexerToken lexerToken) {
        if (this._mUseLastToken) {
            this._mUseLastToken = false;
            return this.fillLexerToken(lexerToken);
        }
        this._mUseLastToken = false;
        this._mLastToken = 0;
        Tokenizer tokenizer = this.getTokenizer();
        switch (this.nextToken()) {
            case 18: {
                this.updateState();
                break;
            }
            case 17: {
                this.updateState();
                break;
            }
            case 21: 
            case 22: {
                this.updateState();
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 55: {
                this.updateState();
                this.skipAtRule();
                this._mEndOffset = tokenizer.getEnd();
                break;
            }
            case 20: {
                this._mStartOffset = tokenizer.getStart();
                this._mLastToken = this.skipStyleRule();
                this._mEndOffset = tokenizer.getEnd();
                break;
            }
            default: {
                this.updateState();
            }
        }
        return this.fillLexerToken(lexerToken);
    }

    public void backup() {
        this._mUseLastToken = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int skipStyleRule() {
        int n = 0;
        while (true) {
            switch (this.nextToken()) {
                case 1: {
                    ++n;
                    break;
                }
                case 2: {
                    if (--n > 0) break;
                    return 100;
                }
                case 0: {
                    return 100;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int skipBlock() {
        int n = 1;
        while (n > 0) {
            switch (this.nextToken()) {
                case 1: {
                    ++n;
                    break;
                }
                case 2: {
                    --n;
                    break;
                }
                case 0: {
                    return 101;
                }
            }
        }
        return 101;
    }

    protected int skipAtRule() {
        try {
            this._mTokenizer.scanAtRule();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        int n = this.nextToken();
        return 29;
    }

    protected int fillLexerToken(LexerToken lexerToken) {
        AbstractLexer.DefaultLexerToken defaultLexerToken = (AbstractLexer.DefaultLexerToken)lexerToken;
        defaultLexerToken.setToken(this._mLastToken);
        defaultLexerToken.setStartOffset(this._mStartOffset);
        defaultLexerToken.setEndOffset(this._mEndOffset);
        return this._mLastToken;
    }

    protected void resetTokenizer() {
        if (this._mTokenizer == null) {
            this.getTokenizer();
        }
        if (this.currentPos == 0) {
            this._mReader.current = 0;
            this._mTokenizer.reset();
            this._mUseLastToken = false;
        } else {
            int n = this.currentPos - 1;
            int n2 = 0;
            int n3 = 0;
            if (this._mDocument != null) {
                LineMap lineMap = this._mDocument.getLineMap();
                n2 = lineMap.getLineFromOffset(n);
                n3 = lineMap.getLineEndOffset(n2) - n;
            }
            this._mReader.current = n;
            this._mTokenizer.setPosition(n, n2, n3);
            this._mUseLastToken = false;
        }
    }

    protected int nextToken() {
        try {
            int n;
            int n2 = n = this._mTokenizer.next();
            return n2;
        }
        catch (ParseException parseException) {
            if (parseException.getException() != null && parseException.getException() instanceof IOException) {
                int n = 0;
                return n;
            }
            int n = -1;
            return n;
        }
    }

    protected Tokenizer getTokenizer() {
        if (this._mTokenizer == null) {
            this._mReader = new TextBufferReader(null);
            this._mTokenizer = new Tokenizer(this._mReader);
            this._mTokenizer.replaceEscaped(false);
            this._mTokenizer.returnErrorToken(true);
            this._mTokenizer.completeToken(true);
        }
        return this._mTokenizer;
    }

    protected void updateState() throws ParseException {
        this._mLastToken = this._mTokenizer.getType();
        this._mStartOffset = this._mTokenizer.getStart();
        this._mEndOffset = this._mTokenizer.getEnd();
        this.convertToken();
    }

    protected void convertToken() {
        this._mLastToken = this.TokenizerToLanguageToken(this._mLastToken);
    }

    protected int TokenizerToLanguageToken(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
        }
        return n;
    }

    static ReadTextBuffer ra$textBuffer(CSSLexer cSSLexer) {
        return cSSLexer.textBuffer;
    }

    private class TextBufferReader
    extends Reader {
        int current;

        void $init$() {
            this.current = 0;
        }

        public void close() {
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3 = CSSLexer.ra$textBuffer(CSSLexer.this).getLength();
            int n4 = n3 - (this.current + n2);
            if (n4 < 0) {
                n2 += n4;
            }
            if (n2 > 0) {
                int n5 = 0;
                while (n5 < n2) {
                    cArray[n + n5] = CSSLexer.ra$textBuffer(CSSLexer.this).getChar(this.current++);
                    ++n5;
                }
            }
            return n2;
        }

        private TextBufferReader() {
            this.$init$();
        }

        TextBufferReader(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

