/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.css;

import java.io.IOException;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import oracle.javatools.parser.css.CSSBundle;
import oracle.javatools.parser.css.ParseException;
import oracle.javatools.parser.css.TokenizerUtil;

public class Tokenizer {
    private static final int ERROR = -1;
    protected Reader reader;
    protected int line;
    protected int column;
    protected int current;
    protected char[] readBuffer;
    protected int readPosition;
    protected int readCount;
    protected char[] buffer;
    protected int position;
    protected int type;
    protected int start;
    protected int end;
    protected int blankCharacters;
    protected boolean replaceEscapedCharacters;
    protected boolean completeToken;
    protected int escapedCharacters;
    protected int currentEscapedCharacters;
    protected boolean returnErrorToken;
    protected String errorMessage;

    void $init$() {
        this.line = 1;
        this.buffer = new char[128];
    }

    public Tokenizer(Reader reader) throws ParseException {
        this.$init$();
        this.returnErrorToken(false);
        this.replaceEscaped(true);
        this.completeToken(false);
        try {
            this.reader = reader;
            this.readBuffer = new char[4096];
            this.current = this.nextChar();
        }
        catch (IOException iOException) {
            throw new ParseException(iOException);
        }
    }

    public Tokenizer(String string) throws ParseException {
        this.$init$();
        this.returnErrorToken(false);
        this.replaceEscaped(true);
        this.completeToken(false);
        try {
            this.reader = null;
            this.readBuffer = string.toCharArray();
            this.readPosition = 0;
            this.readCount = this.readBuffer.length;
            this.collapseCRNL(0);
            this.current = this.readCount == 0 ? -1 : this.nextChar();
        }
        catch (IOException iOException) {
            throw new ParseException(iOException);
        }
    }

    public void returnErrorToken(boolean bl) {
        this.returnErrorToken = bl;
    }

    public void replaceEscaped(boolean bl) {
        this.replaceEscapedCharacters = bl;
    }

    public void completeToken(boolean bl) {
        this.completeToken = bl;
    }

    public void reset() {
        try {
            this.escapedCharacters = 0;
            this.start = 0;
            this.end = 0;
            this.position = 0;
            this.column = 0;
            this.line = 1;
            this.type = 13;
            this.readPosition = 0;
            if (this.reader == null) {
                this.readCount = this.readBuffer.length;
                this.collapseCRNL(0);
                this.current = this.readCount == 0 ? -1 : this.nextChar();
            } else {
                this.readCount = 0;
                this.current = this.nextChar();
            }
        }
        catch (IOException iOException) {
            throw new ParseException(iOException);
        }
    }

    public void setPosition(int n, int n2, int n3) {
        if (this.replaceEscapedCharacters || !this.completeToken) {
            throw new IllegalStateException("Can't set Tokenizer's position");
        }
        try {
            this.escapedCharacters = 0;
            this.start = 0;
            this.end = n;
            this.position = n;
            this.column = n3;
            this.line = n2;
            this.type = 13;
            this.readPosition = 0;
            if (this.reader == null) {
                this.readCount = this.readBuffer.length;
                this.collapseCRNL(0);
                this.current = this.readCount == 0 ? -1 : this.nextChar();
            } else {
                this.readCount = 0;
                this.current = this.nextChar();
            }
        }
        catch (IOException iOException) {
            throw new ParseException(iOException);
        }
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public char[] getBuffer() {
        return this.buffer;
    }

    public int getStart() {
        return this.start + (this.escapedCharacters - this.currentEscapedCharacters);
    }

    public int getEnd() {
        return this.end + this.escapedCharacters;
    }

    public void clearBuffer() {
        if (this.position <= 0) {
            this.position = 0;
        } else {
            this.buffer[0] = this.buffer[this.position - 1];
            this.position = 1;
        }
    }

    public int getType() {
        return this.type;
    }

    public String getStringValue() {
        return new String(this.buffer, this.start, this.end - this.start);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void scanAtRule() throws ParseException {
        try {
            block11: while (true) {
                switch (this.current) {
                    case 123: {
                        int n = 1;
                        block12: while (true) {
                            this.nextChar();
                            switch (this.current) {
                                case 125: {
                                    if (--n > 0) continue block12;
                                }
                                case -1: {
                                    break block11;
                                }
                                case 123: {
                                    ++n;
                                }
                            }
                        }
                    }
                    case -1: 
                    case 59: {
                        break block11;
                    }
                    default: {
                        this.nextChar();
                    }
                }
            }
            this.end = this.position;
        }
        catch (IOException iOException) {
            throw new ParseException(iOException);
        }
    }

    public int next() throws ParseException {
        this.currentEscapedCharacters = 0;
        this.blankCharacters = 0;
        this.start = this.position - 1;
        this.type = 13;
        this.nextToken();
        this.escapedCharacters += this.currentEscapedCharacters;
        this.end = this.position - this.endGap();
        if (!this.returnErrorToken && this.type == -1) {
            throw new ParseException(this.errorMessage, this.line, this.column);
        }
        return this.type;
    }

    protected int endGap() {
        int n;
        int n2 = n = this.current == -1 ? 0 : 1;
        if (this.completeToken) {
            return n;
        }
        switch (this.type) {
            case 19: 
            case 42: 
            case 43: 
            case 52: {
                ++n;
                break;
            }
            case 18: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: {
                n += 2;
                break;
            }
            case 47: 
            case 48: 
            case 50: {
                n += 3;
                break;
            }
            case 49: {
                n += 4;
            }
        }
        return n + this.blankCharacters;
    }

    protected void nextToken() throws ParseException {
        try {
            switch (this.current) {
                case -1: {
                    this.type = 0;
                    return;
                }
                case 123: {
                    this.nextChar();
                    this.type = 1;
                    return;
                }
                case 125: {
                    this.nextChar();
                    this.type = 2;
                    return;
                }
                case 61: {
                    this.nextChar();
                    this.type = 3;
                    return;
                }
                case 43: {
                    this.nextChar();
                    this.type = 4;
                    return;
                }
                case 44: {
                    this.nextChar();
                    this.type = 6;
                    return;
                }
                case 59: {
                    this.nextChar();
                    this.type = 8;
                    return;
                }
                case 62: {
                    this.nextChar();
                    this.type = 9;
                    return;
                }
                case 91: {
                    this.nextChar();
                    this.type = 11;
                    return;
                }
                case 93: {
                    this.nextChar();
                    this.type = 12;
                    return;
                }
                case 42: {
                    this.nextChar();
                    this.type = 13;
                    return;
                }
                case 40: {
                    this.nextChar();
                    this.type = 14;
                    return;
                }
                case 41: {
                    this.nextChar();
                    this.type = 15;
                    return;
                }
                case 58: {
                    this.nextChar();
                    this.type = 16;
                    return;
                }
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 32: {
                    do {
                        this.nextChar();
                    } while (TokenizerUtil.isCSSSpace((char)this.current));
                    this.type = 17;
                    return;
                }
                case 47: {
                    this.nextChar();
                    if (this.current != 42) {
                        this.type = 10;
                        return;
                    }
                    this.nextChar();
                    if (!this.completeToken) {
                        this.start = this.position - 1;
                    }
                    while (true) {
                        if (this.current != -1 && this.current != 42) {
                            this.nextChar();
                            continue;
                        }
                        do {
                            this.nextChar();
                        } while (this.current != -1 && this.current == 42);
                        if (this.current == -1 || this.current == 47) break;
                    }
                    if (this.current == -1) {
                        this.type = -1;
                        this.errorMessage = Tokenizer.getBundle().getString("MSG_UNEXPECTED_EOF");
                        return;
                    }
                    this.nextChar();
                    this.type = 18;
                    return;
                }
                case 39: {
                    this.type = this.string1();
                    return;
                }
                case 34: {
                    this.type = this.string2();
                    return;
                }
                case 60: {
                    this.nextChar();
                    if (this.current != 33) {
                        this.type = -1;
                        this.errorMessage = Tokenizer.format("MSG_EXPECTING_INSTEAD_OF_CHAR", "!");
                        return;
                    }
                    this.nextChar();
                    if (this.current == 45) {
                        this.nextChar();
                        if (this.current == 45) {
                            this.nextChar();
                            this.type = 21;
                            return;
                        }
                    }
                    this.type = -1;
                    this.errorMessage = Tokenizer.format("MSG_EXPECTING_INSTEAD_OF_CHAR", "-");
                    return;
                }
                case 45: {
                    this.Ident();
                    if (this.type == -1) {
                        return;
                    }
                    if (this.type == 20) {
                        if (this.current == 40) {
                            this.nextChar();
                            this.type = 52;
                            return;
                        }
                        return;
                    }
                    if (this.current != 45) {
                        this.type = 5;
                        return;
                    }
                    this.nextChar();
                    if (this.current == 62) {
                        this.nextChar();
                        this.type = 22;
                        return;
                    }
                    this.type = -1;
                    this.errorMessage = Tokenizer.format("MSG_EXPECTING_INSTEAD_OF_CHAR", ">");
                    return;
                }
                case 124: {
                    this.nextChar();
                    if (this.current == 61) {
                        this.nextChar();
                        this.type = 25;
                        return;
                    }
                    this.type = 56;
                    return;
                }
                case 126: {
                    this.nextChar();
                    if (this.current == 61) {
                        this.nextChar();
                        this.type = 26;
                        return;
                    }
                    this.type = -1;
                    this.errorMessage = Tokenizer.format("MSG_EXPECTING_INSTEAD_OF_CHAR", "=");
                    return;
                }
                case 35: {
                    this.nextChar();
                    if (TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                        if (!this.completeToken) {
                            this.start = this.position - 1;
                        }
                        do {
                            this.nextChar();
                            if (this.current != 92) continue;
                            this.nextChar();
                            this.escape();
                            if (this.type != -1) continue;
                            return;
                        } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                        this.type = 27;
                        return;
                    }
                    this.type = -1;
                    this.errorMessage = Tokenizer.format("MSG_EXPECTING_INSTEAD_OF_CHAR", Tokenizer.getBundle().getString("NAME"));
                    return;
                }
                case 64: {
                    this.nextChar();
                    switch (this.current) {
                        case 67: 
                        case 99: {
                            if (!this.completeToken) {
                                this.start = this.position - 1;
                            }
                            if (!Tokenizer.isEqualIgnoreCase(this.nextChar(), 'h') || !Tokenizer.isEqualIgnoreCase(this.nextChar(), 'a') || !Tokenizer.isEqualIgnoreCase(this.nextChar(), 'r') || !Tokenizer.isEqualIgnoreCase(this.nextChar(), 's') || !Tokenizer.isEqualIgnoreCase(this.nextChar(), 'e') || !Tokenizer.isEqualIgnoreCase(this.nextChar(), 't')) break;
                            this.nextChar();
                            this.type = 30;
                            return;
                        }
                        case 70: 
                        case 102: {
                            if (!this.completeToken) {
                                this.start = this.position - 1;
                            }
                            if (!Tokenizer.isEqualIgnoreCase(this.nextChar(), 'o') || !Tokenizer.isEqualIgnoreCase(this.nextChar(), 'n') || !Tokenizer.isEqualIgnoreCase(this.nextChar(), 't') || !Tokenizer.isEqualIgnoreCase(this.nextChar(), '-') || !Tokenizer.isEqualIgnoreCase(this.nextChar(), 'f') || !Tokenizer.isEqualIgnoreCase(this.nextChar(), 'a') || !Tokenizer.isEqualIgnoreCase(this.nextChar(), 'c') || !Tokenizer.isEqualIgnoreCase(this.nextChar(), 'e')) break;
                            this.nextChar();
                            this.type = 31;
                            return;
                        }
                        case 73: 
                        case 105: {
                            if (!this.completeToken) {
                                this.start = this.position - 1;
                            }
                            if (!Tokenizer.isEqualIgnoreCase(this.nextChar(), 'm') || !Tokenizer.isEqualIgnoreCase(this.nextChar(), 'p') || !Tokenizer.isEqualIgnoreCase(this.nextChar(), 'o') || !Tokenizer.isEqualIgnoreCase(this.nextChar(), 'r') || !Tokenizer.isEqualIgnoreCase(this.nextChar(), 't')) break;
                            this.nextChar();
                            this.type = 28;
                            return;
                        }
                        case 77: 
                        case 109: {
                            if (!this.completeToken) {
                                this.start = this.position - 1;
                            }
                            if (!Tokenizer.isEqualIgnoreCase(this.nextChar(), 'e') || !Tokenizer.isEqualIgnoreCase(this.nextChar(), 'd') || !Tokenizer.isEqualIgnoreCase(this.nextChar(), 'i') || !Tokenizer.isEqualIgnoreCase(this.nextChar(), 'a')) break;
                            this.nextChar();
                            this.type = 32;
                            return;
                        }
                        case 78: 
                        case 110: {
                            if (!this.completeToken) {
                                this.start = this.position - 1;
                            }
                            if (!Tokenizer.isEqualIgnoreCase(this.nextChar(), 'a') || !Tokenizer.isEqualIgnoreCase(this.nextChar(), 'm') || !Tokenizer.isEqualIgnoreCase(this.nextChar(), 'e') || !Tokenizer.isEqualIgnoreCase(this.nextChar(), 's') || !Tokenizer.isEqualIgnoreCase(this.nextChar(), 'p') || !Tokenizer.isEqualIgnoreCase(this.nextChar(), 'a') || !Tokenizer.isEqualIgnoreCase(this.nextChar(), 'c') || !Tokenizer.isEqualIgnoreCase(this.nextChar(), 'e')) break;
                            this.nextChar();
                            this.type = 55;
                            return;
                        }
                        case 80: 
                        case 112: {
                            if (!this.completeToken) {
                                this.start = this.position - 1;
                            }
                            if (!Tokenizer.isEqualIgnoreCase(this.nextChar(), 'a') || !Tokenizer.isEqualIgnoreCase(this.nextChar(), 'g') || !Tokenizer.isEqualIgnoreCase(this.nextChar(), 'e')) break;
                            this.nextChar();
                            this.type = 33;
                            return;
                        }
                        default: {
                            if (!TokenizerUtil.isCSSIdentifierNMStartCharacter((char)this.current)) {
                                this.type = -1;
                                this.errorMessage = Tokenizer.format("MSG_EXPECTING_INSTEAD_OF_CHAR", Tokenizer.getBundle().getString("IDENTIFIER"));
                                return;
                            }
                            if (this.completeToken) break;
                            this.start = this.position - 1;
                        }
                    }
                    do {
                        this.nextChar();
                        if (this.current != 92) continue;
                        this.nextChar();
                        this.escape();
                        if (this.type != -1) continue;
                        return;
                    } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                    this.type = 29;
                    return;
                }
                case 33: {
                    do {
                        this.nextChar();
                    } while (this.current != -1 && TokenizerUtil.isCSSSpace((char)this.current));
                    if (Tokenizer.isEqualIgnoreCase(this.current, 'i') && Tokenizer.isEqualIgnoreCase(this.nextChar(), 'm') && Tokenizer.isEqualIgnoreCase(this.nextChar(), 'p') && Tokenizer.isEqualIgnoreCase(this.nextChar(), 'o') && Tokenizer.isEqualIgnoreCase(this.nextChar(), 'r') && Tokenizer.isEqualIgnoreCase(this.nextChar(), 't') && Tokenizer.isEqualIgnoreCase(this.nextChar(), 'a') && Tokenizer.isEqualIgnoreCase(this.nextChar(), 'n') && Tokenizer.isEqualIgnoreCase(this.nextChar(), 't')) {
                        this.nextChar();
                        this.type = 23;
                        return;
                    }
                    if (this.current == -1) {
                        this.type = -1;
                        this.errorMessage = Tokenizer.getBundle().getString("MSG_UNEXPECTED_EOF");
                        return;
                    }
                    this.type = -1;
                    this.errorMessage = Tokenizer.format("MSG_EXPECTING_INSTEAD_OF_CHAR", "!important");
                    return;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.type = this.number();
                    return;
                }
                case 46: {
                    switch (this.nextChar()) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            this.type = this.dotNumber();
                            return;
                        }
                    }
                    this.type = 7;
                    return;
                }
                case 85: 
                case 117: {
                    this.nextChar();
                    switch (this.current) {
                        case 43: {
                            boolean bl = false;
                            int n = 0;
                            while (n < 6) {
                                this.nextChar();
                                switch (this.current) {
                                    case 63: {
                                        bl = true;
                                        break;
                                    }
                                    default: {
                                        if (!bl || TokenizerUtil.isCSSHexadecimalCharacter((char)this.current)) break;
                                        this.type = -1;
                                        this.errorMessage = Tokenizer.format("MSG_EXPECTING_INSTEAD_OF_CHAR", Tokenizer.getBundle().getString("HEX"));
                                        return;
                                    }
                                }
                                ++n;
                            }
                            this.nextChar();
                            if (bl) {
                                this.type = 53;
                                return;
                            }
                            if (this.current == 45) {
                                this.nextChar();
                                if (!TokenizerUtil.isCSSHexadecimalCharacter((char)this.current)) {
                                    this.type = -1;
                                    this.errorMessage = Tokenizer.format("MSG_EXPECTING_INSTEAD_OF_CHAR", Tokenizer.getBundle().getString("HEX"));
                                    return;
                                }
                                this.nextChar();
                                if (!TokenizerUtil.isCSSHexadecimalCharacter((char)this.current)) {
                                    this.type = 53;
                                    return;
                                }
                                this.nextChar();
                                if (!TokenizerUtil.isCSSHexadecimalCharacter((char)this.current)) {
                                    this.type = 53;
                                    return;
                                }
                                this.nextChar();
                                if (!TokenizerUtil.isCSSHexadecimalCharacter((char)this.current)) {
                                    this.type = 53;
                                    return;
                                }
                                this.nextChar();
                                if (!TokenizerUtil.isCSSHexadecimalCharacter((char)this.current)) {
                                    this.type = 53;
                                    return;
                                }
                                this.nextChar();
                                if (!TokenizerUtil.isCSSHexadecimalCharacter((char)this.current)) {
                                    this.type = 53;
                                    return;
                                }
                                this.nextChar();
                                this.type = 53;
                                return;
                            }
                        }
                        case 82: 
                        case 114: {
                            this.nextChar();
                            switch (this.current) {
                                case 76: 
                                case 108: {
                                    this.nextChar();
                                    switch (this.current) {
                                        case 40: {
                                            do {
                                                this.nextChar();
                                            } while (this.current != -1 && TokenizerUtil.isCSSSpace((char)this.current));
                                            switch (this.current) {
                                                case 39: {
                                                    this.string1();
                                                    this.blankCharacters += 2;
                                                    while (this.current != -1 && TokenizerUtil.isCSSSpace((char)this.current)) {
                                                        ++this.blankCharacters;
                                                        this.nextChar();
                                                    }
                                                    if (this.current == -1) {
                                                        this.type = -1;
                                                        this.errorMessage = Tokenizer.getBundle().getString("MSG_UNEXPECTED_EOF");
                                                        return;
                                                    }
                                                    if (this.current != 41) {
                                                        this.type = -1;
                                                        this.errorMessage = Tokenizer.format("MSG_EXPECTING_INSTEAD_OF_CHAR", ")");
                                                        return;
                                                    }
                                                    this.nextChar();
                                                    this.type = 51;
                                                    return;
                                                }
                                                case 34: {
                                                    this.string2();
                                                    this.blankCharacters += 2;
                                                    while (this.current != -1 && TokenizerUtil.isCSSSpace((char)this.current)) {
                                                        ++this.blankCharacters;
                                                        this.nextChar();
                                                    }
                                                    if (this.current == -1) {
                                                        this.type = -1;
                                                        this.errorMessage = Tokenizer.getBundle().getString("MSG_UNEXPECTED_EOF");
                                                        return;
                                                    }
                                                    if (this.current != 41) {
                                                        this.type = -1;
                                                        this.errorMessage = Tokenizer.format("MSG_EXPECTING_INSTEAD_OF_CHAR", ")");
                                                        return;
                                                    }
                                                    this.nextChar();
                                                    this.type = 51;
                                                    return;
                                                }
                                                case 41: {
                                                    this.type = -1;
                                                    this.errorMessage = Tokenizer.format("MSG_UNEXPECTED_CHAR", ")");
                                                    return;
                                                }
                                            }
                                            if (!TokenizerUtil.isCSSURICharacter((char)this.current)) {
                                                this.type = -1;
                                                this.errorMessage = Tokenizer.format("MSG_EXPECTING_INSTEAD_OF_CHAR", Tokenizer.getBundle().getString("URI_CHAR"));
                                                return;
                                            }
                                            if (!this.completeToken) {
                                                this.start = this.position - 1;
                                            }
                                            do {
                                                this.nextChar();
                                            } while (this.current != -1 && TokenizerUtil.isCSSURICharacter((char)this.current));
                                            ++this.blankCharacters;
                                            while (this.current != -1 && TokenizerUtil.isCSSSpace((char)this.current)) {
                                                ++this.blankCharacters;
                                                this.nextChar();
                                            }
                                            if (this.current == -1) {
                                                this.type = -1;
                                                this.errorMessage = Tokenizer.getBundle().getString("MSG_UNEXPECTED_EOF");
                                                return;
                                            }
                                            if (this.current != 41) {
                                                this.type = -1;
                                                this.errorMessage = Tokenizer.format("MSG_EXPECTING_INSTEAD_OF_CHAR", ")");
                                                return;
                                            }
                                            this.nextChar();
                                            this.type = 51;
                                            return;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current) || this.current == 92) {
                        if (this.current == 92) {
                            this.nextChar();
                            this.escape();
                            if (this.type != -1) continue;
                            return;
                        }
                        this.nextChar();
                    }
                    if (this.current == 40) {
                        this.nextChar();
                        this.type = 52;
                        return;
                    }
                    this.type = 20;
                    return;
                }
                case 92: {
                    this.nextChar();
                    this.escape();
                    if (this.type != -1) break;
                    return;
                }
            }
            this.Ident();
            if (this.type == -1) {
                return;
            }
            if (this.type == 20) {
                if (this.current == 40) {
                    this.nextChar();
                    this.type = 52;
                    return;
                }
                return;
            }
            this.nextChar();
            this.type = -1;
            this.end = this.position - this.endGap();
            this.errorMessage = Tokenizer.format("MSG_EXPECTING_INSTEAD_OF_THE_CHAR", this.getStringValue(), Tokenizer.getBundle().getString("IDENTIFIER"));
            return;
        }
        catch (IOException iOException) {
            throw new ParseException(iOException);
        }
    }

    protected int string1() throws IOException {
        this.nextChar();
        if (!this.completeToken) {
            this.start = this.position - 1;
        }
        block9: while (true) {
            block0 : switch (this.nextChar()) {
                case -1: {
                    this.errorMessage = Tokenizer.getBundle().getString("MSG_UNEXPECTED_EOF");
                    return -1;
                }
                case 39: {
                    break block9;
                }
                case 34: {
                    break;
                }
                case 92: {
                    switch (this.nextChar()) {
                        case 10: 
                        case 12: {
                            break block0;
                        }
                    }
                    this.escape();
                    if (this.type != -1) continue block9;
                    return -1;
                }
                default: {
                    if (TokenizerUtil.isCSSStringCharacter((char)this.current)) continue block9;
                    this.errorMessage = Tokenizer.getBundle().getString("MSG_AN_UNEXPECTED_CHAR");
                    return -1;
                }
            }
        }
        this.nextChar();
        return 19;
    }

    protected int string2() throws IOException {
        this.nextChar();
        if (!this.completeToken) {
            this.start = this.position - 1;
        }
        block9: while (true) {
            block0 : switch (this.nextChar()) {
                case -1: {
                    this.errorMessage = Tokenizer.getBundle().getString("MSG_UNEXPECTED_EOF");
                    return -1;
                }
                case 39: {
                    break;
                }
                case 34: {
                    break block9;
                }
                case 92: {
                    switch (this.nextChar()) {
                        case 10: 
                        case 12: {
                            break block0;
                        }
                    }
                    this.escape();
                    if (this.type != -1) continue block9;
                    return -1;
                }
                default: {
                    if (TokenizerUtil.isCSSStringCharacter((char)this.current)) continue block9;
                    this.errorMessage = Tokenizer.getBundle().getString("MSG_AN_UNEXPECTED_CHAR");
                    return -1;
                }
            }
        }
        this.nextChar();
        return 19;
    }

    protected int number() throws IOException {
        block7: while (true) {
            switch (this.nextChar()) {
                case 46: {
                    switch (this.nextChar()) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            return this.dotNumber();
                        }
                    }
                    this.errorMessage = Tokenizer.format("MSG_EXPECTING_INSTEAD_OF_CHAR", Tokenizer.getBundle().getString("DIGIT"));
                    return -1;
                }
                default: {
                    break block7;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    continue block7;
                }
            }
            break;
        }
        return this.numberUnit(true);
    }

    protected int dotNumber() throws IOException {
        block3: while (true) {
            switch (this.nextChar()) {
                default: {
                    break block3;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    continue block3;
                }
            }
            break;
        }
        return this.numberUnit(false);
    }

    protected int numberUnit(boolean bl) throws IOException {
        switch (this.current) {
            case 37: {
                this.nextChar();
                return 42;
            }
            case 67: 
            case 99: {
                switch (this.nextChar()) {
                    case 77: 
                    case 109: {
                        this.nextChar();
                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 37;
                    }
                }
                while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 68: 
            case 100: {
                switch (this.nextChar()) {
                    case 69: 
                    case 101: {
                        switch (this.nextChar()) {
                            case 71: 
                            case 103: {
                                this.nextChar();
                                if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                                    do {
                                        this.nextChar();
                                    } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                                    return 34;
                                }
                                return 47;
                            }
                        }
                    }
                }
                while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 69: 
            case 101: {
                switch (this.nextChar()) {
                    case 77: 
                    case 109: {
                        this.nextChar();
                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 36;
                    }
                    case 88: 
                    case 120: {
                        this.nextChar();
                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 35;
                    }
                }
                while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 71: 
            case 103: {
                switch (this.nextChar()) {
                    case 82: 
                    case 114: {
                        switch (this.nextChar()) {
                            case 65: 
                            case 97: {
                                switch (this.nextChar()) {
                                    case 68: 
                                    case 100: {
                                        this.nextChar();
                                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                                            do {
                                                this.nextChar();
                                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                                            return 34;
                                        }
                                        return 49;
                                    }
                                }
                            }
                        }
                    }
                }
                while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 72: 
            case 104: {
                this.nextChar();
                switch (this.current) {
                    case 90: 
                    case 122: {
                        this.nextChar();
                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 41;
                    }
                }
                while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 73: 
            case 105: {
                switch (this.nextChar()) {
                    case 78: 
                    case 110: {
                        this.nextChar();
                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 39;
                    }
                }
                while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 75: 
            case 107: {
                switch (this.nextChar()) {
                    case 72: 
                    case 104: {
                        switch (this.nextChar()) {
                            case 90: 
                            case 122: {
                                this.nextChar();
                                if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                                    do {
                                        this.nextChar();
                                    } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                                    return 34;
                                }
                                return 50;
                            }
                        }
                    }
                }
                while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 77: 
            case 109: {
                switch (this.nextChar()) {
                    case 77: 
                    case 109: {
                        this.nextChar();
                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 38;
                    }
                    case 83: 
                    case 115: {
                        this.nextChar();
                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 40;
                    }
                }
                while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 80: 
            case 112: {
                switch (this.nextChar()) {
                    case 67: 
                    case 99: {
                        this.nextChar();
                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 44;
                    }
                    case 84: 
                    case 116: {
                        this.nextChar();
                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 45;
                    }
                    case 88: 
                    case 120: {
                        this.nextChar();
                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 46;
                    }
                }
                while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 82: 
            case 114: {
                switch (this.nextChar()) {
                    case 65: 
                    case 97: {
                        switch (this.nextChar()) {
                            case 68: 
                            case 100: {
                                this.nextChar();
                                if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                                    do {
                                        this.nextChar();
                                    } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                                    return 34;
                                }
                                return 48;
                            }
                        }
                    }
                }
                while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 83: 
            case 115: {
                this.nextChar();
                return 43;
            }
        }
        if (this.current != -1 && TokenizerUtil.isCSSIdentifierNMStartCharacter((char)this.current)) {
            do {
                this.nextChar();
            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
            return 34;
        }
        return bl ? 24 : 54;
    }

    protected void escape() throws IOException {
        int n = this.position - 2;
        if (TokenizerUtil.isCSSHexadecimalCharacter((char)this.current)) {
            this.nextChar();
            if (!TokenizerUtil.isCSSHexadecimalCharacter((char)this.current)) {
                if (TokenizerUtil.isCSSSpace((char)this.current)) {
                    this.replaceEscapeSequance(n, this.position);
                    this.nextChar();
                } else {
                    this.replaceEscapeSequance(n, this.position - 1);
                }
                return;
            }
            this.nextChar();
            if (!TokenizerUtil.isCSSHexadecimalCharacter((char)this.current)) {
                if (TokenizerUtil.isCSSSpace((char)this.current)) {
                    this.replaceEscapeSequance(n, this.position);
                    this.nextChar();
                } else {
                    this.replaceEscapeSequance(n, this.position - 1);
                }
                return;
            }
            this.nextChar();
            if (!TokenizerUtil.isCSSHexadecimalCharacter((char)this.current)) {
                if (TokenizerUtil.isCSSSpace((char)this.current)) {
                    this.replaceEscapeSequance(n, this.position);
                    this.nextChar();
                } else {
                    this.replaceEscapeSequance(n, this.position - 1);
                }
                return;
            }
            this.nextChar();
            if (!TokenizerUtil.isCSSHexadecimalCharacter((char)this.current)) {
                if (TokenizerUtil.isCSSSpace((char)this.current)) {
                    this.replaceEscapeSequance(n, this.position);
                    this.nextChar();
                } else {
                    this.replaceEscapeSequance(n, this.position - 1);
                }
                return;
            }
            this.nextChar();
            if (!TokenizerUtil.isCSSHexadecimalCharacter((char)this.current)) {
                if (TokenizerUtil.isCSSSpace((char)this.current)) {
                    this.replaceEscapeSequance(n, this.position);
                    this.nextChar();
                } else {
                    this.replaceEscapeSequance(n, this.position - 1);
                }
                return;
            }
            this.replaceEscapeSequance(n, this.position);
            this.nextChar();
            return;
        }
        if (this.current >= 32 && this.current <= 126 || this.current >= 128) {
            this.replaceEscapeSequance(n, this.position);
            this.nextChar();
            return;
        }
        this.type = -1;
        this.errorMessage = Tokenizer.getBundle().getString("MSG_AN_UNEXPECTED_CHAR");
    }

    protected void replaceEscapeSequance(int n, int n2) {
        int n3;
        if (!this.replaceEscapedCharacters) {
            return;
        }
        int n4 = n3 = n2 != this.position ? this.current : -1;
        if (TokenizerUtil.isCSSSpace(this.buffer[n2 - 1])) {
            --n2;
        }
        int n5 = 0;
        int n6 = this.buffer[n + 1];
        if (TokenizerUtil.isCSSHexadecimalCharacter((char)n6)) {
            int n7 = n + 1;
            while (n7 < n2) {
                int n8 = Character.digit(this.buffer[n7], 16);
                n5 = (n5 << 4) + n8;
                ++n7;
            }
        } else {
            n5 = n6;
        }
        this.buffer[n] = (char)n5;
        if (n3 != -1) {
            this.buffer[n + 1] = (char)n3;
            int n9 = n + 2;
            this.currentEscapedCharacters += this.position - n9;
            this.position = n9;
        } else {
            int n10 = n + 1;
            this.currentEscapedCharacters += this.position - n10;
            this.position = n10;
        }
    }

    protected static boolean isEqualIgnoreCase(int n, char c) {
        return n == -1 ? false : Character.toLowerCase((char)n) == c;
    }

    protected int nextChar() throws IOException {
        if (this.readPosition == this.readCount && !this.fillReadBuffer()) {
            this.current = -1;
            return -1;
        }
        if (this.current != 10) {
            ++this.column;
        } else {
            ++this.line;
            this.column = 1;
        }
        this.current = this.readBuffer[this.readPosition++];
        if (this.position == this.buffer.length) {
            char[] cArray = new char[this.position * 3 / 2];
            System.arraycopy(this.buffer, 0, cArray, 0, this.position);
            this.buffer = cArray;
        } else if (this.position > this.buffer.length) {
            this.buffer = new char[this.position * 3 / 2];
        }
        char c = (char)this.current;
        this.buffer[this.position++] = c;
        return c;
    }

    private void Ident() throws IOException {
        if (this.current == 45) {
            this.nextChar();
        }
        if (TokenizerUtil.isCSSIdentifierNMStartCharacter((char)this.current)) {
            do {
                this.nextChar();
                if (this.current != 92) continue;
                this.nextChar();
                this.escape();
                if (this.type != -1) continue;
                return;
            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
            this.type = 20;
        }
    }

    private boolean fillReadBuffer() throws IOException {
        int n;
        if (this.readCount != 0) {
            if (this.readPosition == this.readCount) {
                this.readBuffer[0] = this.readBuffer[this.readCount - 1];
                this.readCount = 1;
                this.readPosition = 1;
            } else {
                System.arraycopy(this.readBuffer, this.readPosition - 1, this.readBuffer, 0, this.readCount - this.readPosition + 1);
                this.readCount = this.readCount - this.readPosition + 1;
                this.readPosition = 1;
            }
        }
        if (this.reader == null) {
            return this.readCount != this.readPosition;
        }
        int n2 = this.readCount - 1;
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = this.reader.read(this.readBuffer, this.readCount, this.readBuffer.length - this.readCount)) == -1) {
            return this.readCount != this.readPosition;
        }
        this.readCount += n;
        this.collapseCRNL(n2);
        return this.readCount != this.readPosition;
    }

    private void collapseCRNL(int n) {
        while (n < this.readCount) {
            if (this.readBuffer[n] != '\r') {
                ++n;
                continue;
            }
            this.readBuffer[n] = 10;
            if (++n >= this.readCount) break;
            if (this.readBuffer[n] != '\n') continue;
            int n2 = n++;
            while (n < this.readCount) {
                if (this.readBuffer[n] == '\r') {
                    this.readBuffer[n2++] = 10;
                    if (++n >= this.readCount) break;
                    if (this.readBuffer[n] != '\n') continue;
                    ++n;
                    continue;
                }
                this.readBuffer[n2++] = this.readBuffer[n++];
            }
            this.readCount = n2;
            break;
        }
    }

    private static String format(String string, Object object) {
        return Tokenizer.format(string, new Object[]{object});
    }

    private static String format(String string, Object object, Object object2) {
        return Tokenizer.format(string, new Object[]{object, object2});
    }

    private static String format(String string, Object[] objectArray) {
        String string2 = Tokenizer.getBundle().getString(string);
        return MessageFormat.format(string2, objectArray);
    }

    private static ResourceBundle getBundle() {
        return ResourceBundle.getBundle(CSSBundle.class.getName());
    }
}

