/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.diff;

import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.diff.DiffTokens;

public class DiffLexer
extends AbstractLexer
implements DiffTokens {
    private int lastToken = -1;
    private int startOffset = -1;
    private int endOffset = -1;
    private boolean useLastToken = false;

    public DiffLexer() {
        this.setTextBuffer(null);
        this.setPosition(0);
    }

    public int lex(LexerToken lexerToken) {
        block10: {
            if (this.useLastToken) {
                this.useLastToken = false;
                return this.fillLexerToken(lexerToken);
            }
            this.lastToken = 0;
            try {
                while (true) {
                    char c = this.textBuffer.getChar(this.currentPos++);
                    this.startOffset = this.currentPos - 1;
                    if (c == '\n') continue;
                    if (c == '@') {
                        if (!this.peekChars(2).equals("@ ")) {
                            this.skipLine();
                            continue;
                        }
                        this.lastToken = 11;
                        this.skipLine();
                        break;
                    }
                    if (c == '+') {
                        if (this.peekChars(3).equals("++ ")) {
                            this.skipLine();
                            continue;
                        }
                        this.lastToken = 12;
                        this.skipLine();
                        break;
                    }
                    if (c == '-') {
                        if (this.peekChars(3).equals("-- ")) {
                            this.skipLine();
                            continue;
                        }
                        this.lastToken = 13;
                        this.skipLine();
                        break;
                    }
                    this.skipLine();
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.currentPos = this.textBuffer.getLength();
                if (this.lastToken != 0) break block10;
                this.startOffset = this.currentPos;
            }
        }
        this.endOffset = this.currentPos;
        this.useLastToken = false;
        return this.fillLexerToken(lexerToken);
    }

    public void backup() {
        this.useLastToken = true;
    }

    public void setPosition(int n) {
        super.setPosition(n);
        this.useLastToken = false;
    }

    private String peekChars(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.currentPos;
        int n3 = Math.min(this.currentPos + n, this.textBuffer.getLength());
        while (n2 < n3) {
            stringBuffer.append(this.textBuffer.getChar(n2));
            ++n2;
        }
        return stringBuffer.toString();
    }

    private void skipLine() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos);
            switch (c) {
                case '\n': 
                case '\r': {
                    return;
                }
            }
            ++this.currentPos;
        }
    }

    private int fillLexerToken(LexerToken lexerToken) {
        AbstractLexer.DefaultLexerToken defaultLexerToken = (AbstractLexer.DefaultLexerToken)lexerToken;
        defaultLexerToken.setToken(this.lastToken);
        defaultLexerToken.setStartOffset(this.startOffset);
        defaultLexerToken.setEndOffset(this.endOffset);
        return this.lastToken;
    }

    public static String tokenToString(int n) {
        switch (n) {
            case 11: {
                return "TK_HEADER";
            }
            case 12: {
                return "TK_ADDITION";
            }
            case 13: {
                return "TK_REMOVAL";
            }
        }
        return "**UNKNOWN**";
    }

    public static String tokenToText(int n) {
        switch (n) {
            case 11: {
                return "Diff Header";
            }
            case 12: {
                return "Diff Addition";
            }
            case 13: {
                return "Diff Removal";
            }
        }
        return "**UNKNOWN**";
    }
}

