/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.generic;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.generic.Language;

public final class BraceHelper {
    private static final int CLOSE_ADJUSTMENT = 10000;
    public static final int INVALID_BRACE = -1;
    private String[] openBraceArray;
    private String[] closeBraceArray;

    public BraceHelper(Language language) {
        this(language.getBraces());
    }

    public BraceHelper(String[][] stringArray) {
        int n = stringArray != null ? stringArray.length : 0;
        this.openBraceArray = new String[n];
        this.closeBraceArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            String[] stringArray2 = stringArray[n2];
            boolean bl = stringArray2 != null && stringArray2.length > 0;
            boolean bl2 = stringArray2 != null && stringArray2.length > 1;
            this.openBraceArray[n2] = bl ? stringArray2[0] : "";
            this.closeBraceArray[n2] = bl2 ? stringArray2[1] : "";
            ++n2;
        }
    }

    private int findBrace(String[] stringArray, ReadTextBuffer readTextBuffer, int n, int n2) {
        int n3 = stringArray.length;
        int n4 = 0;
        while (n4 < n3) {
            if (this.matchPattern(stringArray[n4], readTextBuffer, n, n2)) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    private boolean matchPattern(String string, ReadTextBuffer readTextBuffer, int n, int n2) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string.length() != n2 - n) {
            return false;
        }
        int n3 = string.length();
        int n4 = 0;
        int n5 = n;
        while (n4 < n3) {
            char c;
            char c2;
            if ((c2 = readTextBuffer.getChar(n5++)) == (c = string.charAt(n4++))) continue;
            return false;
        }
        return true;
    }

    public boolean isOpenIndex(int n) {
        return n >= 0 && n < this.openBraceArray.length;
    }

    public boolean isCloseIndex(int n) {
        int n2 = n - 10000;
        return this.isOpenIndex(n2);
    }

    public int getBraceLength(int n) {
        if (this.isOpenIndex(n)) {
            return this.openBraceArray[n].length();
        }
        if (this.isCloseIndex(n)) {
            return this.closeBraceArray[n - 10000].length();
        }
        return -1;
    }

    public int getBracePairsCount() {
        return this.openBraceArray.length;
    }

    public int getBraceIndex(ReadTextBuffer readTextBuffer, int n, int n2) {
        int n3 = this.findBrace(this.openBraceArray, readTextBuffer, n, n2);
        if (n3 == -1) {
            n3 = this.findBrace(this.closeBraceArray, readTextBuffer, n, n2) + 10000;
        }
        return n3;
    }

    public int getMatchingBraceIndex(int n) {
        if (this.isOpenIndex(n)) {
            return n + 10000;
        }
        if (this.isCloseIndex(n)) {
            return n - 10000;
        }
        return -1;
    }
}

