/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.generic;

import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.generic.GenericTokens;
import oracle.javatools.parser.generic.Language;
import oracle.javatools.parser.util.KeywordTable;

public class GenericLexer
extends AbstractLexer
implements GenericTokens {
    protected int lastToken = -1;
    protected int startOffset = -1;
    protected int endOffset = -1;
    protected boolean useLastToken = false;
    protected boolean skipComments = false;
    protected KeywordTable keywordTable;
    protected Language language;
    private static final String[] FLOAT_PATTERNS = new String[]{".0", ".1", ".2", ".3", ".4", ".5", ".6", ".7", ".8", ".9"};
    private static final String[] EXPONENT_PATTERNS = new String[]{"e+0", "e+1", "e+2", "e+3", "e+4", "e+5", "e+6", "e+7", "e+8", "e+9", "e-0", "e-1", "e-2", "e-3", "e-4", "e-5", "e-6", "e-7", "e-8", "e-9", "e0", "e1", "e2", "e3", "e4", "e5", "e6", "e7", "e8", "e9"};

    public GenericLexer(Language language) {
        this.setTextBuffer(null);
        this.setPosition(0);
        this.language = language;
        this.keywordTable = language.getKeywordTable();
    }

    public void setSkipComments(boolean bl) {
        this.skipComments = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int lex(LexerToken lexerToken) {
        block23: {
            if (this.useLastToken) {
                this.useLastToken = false;
                return this.fillLexerToken(lexerToken);
            }
            this.lastToken = 0;
            try {
                int n;
                block25: {
                    int n2;
                    block24: {
                        int n3;
                        char c;
                        block5: while (true) {
                            c = this.textBuffer.getChar(this.currentPos++);
                            switch (c) {
                                case '\t': 
                                case '\n': 
                                case '\f': 
                                case '\r': 
                                case ' ': {
                                    continue block5;
                                }
                            }
                            this.startOffset = this.currentPos - 1;
                            int n4 = this.isSingleLineCommentStart(this.startOffset);
                            if (n4 != -1) {
                                this.lastToken = 12;
                                this.skipSingleLineComment(this.startOffset, n4);
                                if (this.skipComments) {
                                    this.lastToken = 0;
                                    continue;
                                }
                                break block23;
                            }
                            int n5 = this.isMultiLineCommentStart(this.startOffset);
                            if (n5 != -1) {
                                this.lastToken = 13;
                                this.skipMultiLineComment(this.startOffset, n5);
                                if (this.skipComments) {
                                    this.lastToken = 0;
                                    continue;
                                }
                                break block23;
                            }
                            int n6 = this.isQuotesStart(this.startOffset);
                            if (n6 != -1) {
                                this.lastToken = 14;
                                this.skipQuotes(this.startOffset, n6);
                                break block23;
                            }
                            int n7 = this.isOpenBraceStart(this.startOffset);
                            if (n7 != -1) {
                                this.lastToken = 17;
                                this.skipOpenBrace(this.startOffset, n7);
                                break block23;
                            }
                            int n8 = this.isCloseBraceStart(this.startOffset);
                            if (n8 != -1) {
                                this.lastToken = 18;
                                this.skipCloseBrace(this.startOffset, n8);
                                break block23;
                            }
                            int n9 = this.isHexadecimalStart(this.startOffset);
                            if (n9 != -1) {
                                this.lastToken = 15;
                                this.skipHexadecimal(this.startOffset, n9);
                                break block23;
                            }
                            int n10 = this.isOctalStart(this.startOffset);
                            if (n10 != -1) {
                                this.lastToken = 15;
                                this.skipOctal(this.startOffset, n10);
                                break block23;
                            }
                            boolean bl = this.isDecimalStart(this.startOffset);
                            if (bl) {
                                this.lastToken = 15;
                                this.skipDecimal(this.startOffset);
                                break block23;
                            }
                            boolean bl2 = this.isDecimalPointStart(this.startOffset);
                            if (bl2) {
                                this.lastToken = 16;
                                this.skipFloat(this.startOffset);
                                break block23;
                            }
                            boolean bl3 = this.isOperatorStart(this.startOffset);
                            if (bl3) {
                                this.lastToken = 19;
                                this.skipOperator(this.startOffset);
                                break block23;
                            }
                            if (this.language.isIdentifierCharacter(c)) break;
                        }
                        int n11 = n3 = this.language.isCaseSensitive() ? KeywordTable.computePartialHash(c, 0) : KeywordTable.computeInsensitivePartialHash(c, 0);
                        while (true) {
                            if (!this.language.isIdentifierCharacter(c = this.textBuffer.getChar(this.currentPos))) {
                                n2 = this.keywordTable.lookupKeyword(this.textBuffer, this.startOffset, this.currentPos, n3);
                                if (n2 == -1) {
                                    break;
                                }
                                break block24;
                            }
                            n3 = this.language.isCaseSensitive() ? KeywordTable.computePartialHash(c, n3) : KeywordTable.computeInsensitivePartialHash(c, n3);
                            ++this.currentPos;
                        }
                        n = 11;
                        break block25;
                    }
                    n = n2;
                }
                this.lastToken = n;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.currentPos = this.textBuffer.getLength();
                if (this.lastToken == 0) {
                    this.startOffset = this.currentPos;
                }
                if (!this.skipComments || this.lastToken != 12 && this.lastToken != 13) break block23;
                this.lastToken = 0;
                this.startOffset = this.currentPos;
            }
        }
        this.endOffset = this.currentPos;
        this.useLastToken = false;
        return this.fillLexerToken(lexerToken);
    }

    public void backup() {
        this.useLastToken = true;
    }

    public void setPosition(int n) {
        super.setPosition(n);
        this.useLastToken = false;
    }

    private int isSingleLineCommentStart(int n) {
        String[] stringArray = this.language.getSingleLineComments();
        return this.getMatchingPattern(n, stringArray);
    }

    private void skipSingleLineComment(int n, int n2) {
        String[] stringArray = this.language.getSingleLineComments();
        int n3 = stringArray[n2].length();
        this.currentPos = n + n3;
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case '\n': 
                case '\r': {
                    return;
                }
            }
        }
    }

    private int isMultiLineCommentStart(int n) {
        String[][] stringArray = this.language.getMultiLineComments();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String[] stringArray2 = stringArray[n3];
            if (this.matchPattern(n, stringArray2[0]) != -1) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private void skipMultiLineComment(int n, int n2) {
        String[][] stringArray = this.language.getMultiLineComments();
        String[] stringArray2 = stringArray[n2];
        int n3 = stringArray2[0].length();
        String string = stringArray2[1];
        this.currentPos = n + n3;
        while (true) {
            int n4;
            if ((n4 = this.matchPattern(this.currentPos, string)) != -1) {
                this.currentPos += n4;
                return;
            }
            ++this.currentPos;
        }
    }

    private int isQuotesStart(int n) {
        String[][] stringArray = this.language.getQuotes();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String[] stringArray2 = stringArray[n3];
            if (this.matchPattern(n, stringArray2[0]) != -1) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private void skipQuotes(int n, int n2) {
        String[][] stringArray = this.language.getQuotes();
        String[] stringArray2 = stringArray[n2];
        int n3 = stringArray2[0].length();
        String string = stringArray2[1];
        int n4 = stringArray2.length;
        this.currentPos = n + n3;
        block0: while (true) {
            int n5 = 2;
            while (n5 < n4) {
                int n6 = this.matchPattern(this.currentPos, stringArray2[n5]);
                if (n6 != -1) {
                    this.currentPos += n6;
                    continue block0;
                }
                ++n5;
            }
            int n7 = this.matchPattern(this.currentPos, string);
            if (n7 != -1) {
                this.currentPos += n7;
                return;
            }
            ++this.currentPos;
        }
    }

    private int isOpenBraceStart(int n) {
        String[][] stringArray = this.language.getBraces();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String[] stringArray2 = stringArray[n3];
            if (this.matchPattern(n, stringArray2[0]) != -1) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private void skipOpenBrace(int n, int n2) {
        String[][] stringArray = this.language.getBraces();
        String[] stringArray2 = stringArray[n2];
        int n3 = stringArray2[0].length();
        this.currentPos = n + n3;
    }

    private int isCloseBraceStart(int n) {
        String[][] stringArray = this.language.getBraces();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String[] stringArray2 = stringArray[n3];
            if (this.matchPattern(n, stringArray2[1]) != -1) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private void skipCloseBrace(int n, int n2) {
        String[][] stringArray = this.language.getBraces();
        String[] stringArray2 = stringArray[n2];
        int n3 = stringArray2[0].length();
        this.currentPos = n + n3;
    }

    private boolean isOperatorStart(int n) {
        String[] stringArray = this.language.getOperators();
        int n2 = stringArray != null ? stringArray.length : 0;
        char c = this.textBuffer.getChar(n);
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray[n3];
            if (string.length() > 0 && string.charAt(0) == c) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    private void skipOperator(int n) {
        String[] stringArray = this.language.getOperators();
        int n2 = stringArray != null ? stringArray.length : 0;
        int n3 = 2;
        boolean bl = true;
        while (bl) {
            this.currentPos = n + n3 - 1;
            bl = false;
            int n4 = 0;
            while (n4 < n2) {
                String string = stringArray[n4];
                if (string.length() == n3 && this.matchPattern(n, string) != -1) {
                    bl = true;
                    break;
                }
                ++n4;
            }
            ++n3;
        }
    }

    private int isHexadecimalStart(int n) {
        if (this.language.usesIntegers()) {
            String[] stringArray = this.language.getHexadecimals();
            return this.getMatchingPattern(n, stringArray);
        }
        return -1;
    }

    private void skipHexadecimal(int n, int n2) {
        String[] stringArray = this.language.getHexadecimals();
        int n3 = stringArray[n2].length();
        this.currentPos = n + n3;
        char c;
        while (this.isHexDigit(c = this.textBuffer.getChar(this.currentPos))) {
            ++this.currentPos;
        }
        return;
    }

    private int isOctalStart(int n) {
        String[] stringArray;
        int n2;
        if (this.language.usesIntegers() && (n2 = this.getMatchingPattern(n, stringArray = this.language.getOctals())) != -1 && stringArray[n2].equals("0")) {
            return -1;
        }
        return -1;
    }

    private void skipOctal(int n, int n2) {
        String[] stringArray = this.language.getOctals();
        int n3 = stringArray[n2].length();
        this.currentPos = n + n3;
        char c;
        while (this.isOctalDigit(c = this.textBuffer.getChar(this.currentPos))) {
            ++this.currentPos;
        }
        return;
    }

    private boolean isDecimalStart(int n) {
        char c;
        return this.language.usesIntegers() && this.isDecimalDigit(c = this.textBuffer.getChar(n));
    }

    private void skipDecimal(int n) {
        this.skipDecimalDigits(n);
        char c = this.textBuffer.getChar(this.currentPos);
        if (this.language.usesFloats()) {
            if (c == '.') {
                this.lastToken = 16;
                this.skipFloat(this.currentPos);
            } else {
                int n2 = this.isExponentStart(this.currentPos);
                if (n2 != -1) {
                    this.lastToken = 16;
                    this.skipExponent(this.currentPos, n2);
                }
            }
        }
    }

    private void skipDecimalDigits(int n) {
        char c;
        while (this.isDecimalDigit(c = this.textBuffer.getChar(this.currentPos))) {
            ++this.currentPos;
        }
        return;
    }

    private boolean isDecimalPointStart(int n) {
        if (this.language.usesFloats()) {
            int n2 = this.getMatchingPattern(n, FLOAT_PATTERNS);
            return n2 != -1;
        }
        return false;
    }

    private int isExponentStart(int n) {
        if (this.language.usesFloats()) {
            return this.getMatchingPattern(n, EXPONENT_PATTERNS);
        }
        return -1;
    }

    private void skipFloat(int n) {
        this.skipDecimalDigits(n);
        char c = this.textBuffer.getChar(this.currentPos);
        if (c == '.') {
            ++this.currentPos;
        }
        this.skipDecimalDigits(this.currentPos);
        int n2 = this.isExponentStart(this.currentPos);
        if (n2 != -1) {
            this.skipExponent(this.currentPos, n2);
        }
    }

    private void skipExponent(int n, int n2) {
        int n3 = EXPONENT_PATTERNS[n2].length();
        this.currentPos += n3;
        this.skipDecimalDigits(this.currentPos);
    }

    private int getMatchingPattern(int n, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return -1;
        }
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (this.matchPattern(n, stringArray[n3]) != -1) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private int matchPattern(int n, String string) {
        if (string == null || string.length() == 0) {
            return -1;
        }
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c;
            char c2;
            if ((c2 = this.textBuffer.getChar(n++)) == (c = string.charAt(n3++))) continue;
            return -1;
        }
        return n2;
    }

    private boolean isOctalDigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                return true;
            }
        }
        return false;
    }

    private boolean isDecimalDigit(char c) {
        switch (c) {
            case '8': 
            case '9': {
                return true;
            }
        }
        return this.isOctalDigit(c);
    }

    private boolean isHexDigit(char c) {
        switch (c) {
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return true;
            }
        }
        return this.isDecimalDigit(c);
    }

    protected int fillLexerToken(LexerToken lexerToken) {
        AbstractLexer.DefaultLexerToken defaultLexerToken = (AbstractLexer.DefaultLexerToken)lexerToken;
        defaultLexerToken.setToken(this.lastToken);
        defaultLexerToken.setStartOffset(this.startOffset);
        defaultLexerToken.setEndOffset(this.endOffset);
        return this.lastToken;
    }

    public static String tokenToString(int n) {
        switch (n) {
            case 10: {
                return "TK_KEYWORD";
            }
            case 11: {
                return "TK_IDENTIFIER";
            }
            case 12: {
                return "TK_SINGLE_COMMENT";
            }
            case 13: {
                return "TK_MULTI_COMMENT";
            }
            case 14: {
                return "TK_QUOTES";
            }
            case 15: {
                return "TK_INTEGER";
            }
            case 16: {
                return "TK_FLOAT";
            }
            case 17: {
                return "TK_OPEN_BRACE";
            }
            case 18: {
                return "TK_CLOSE_BRACE";
            }
        }
        return "**UNKNOWN**";
    }

    public static String tokenToText(int n) {
        switch (n) {
            case 10: {
                return "keyword";
            }
            case 11: {
                return "identifier";
            }
            case 12: {
                return "single-line comment";
            }
            case 13: {
                return "multi-line comment";
            }
            case 14: {
                return "quote literal";
            }
            case 15: {
                return "integer";
            }
            case 16: {
                return "float";
            }
            case 17: {
                return "open brace";
            }
            case 18: {
                return "close brace";
            }
        }
        return "**UNKNOWN**";
    }
}

