/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.html;

import oracle.javatools.parser.AbstractLexer;

abstract class EmbeddedLexer
extends AbstractLexer {
    protected boolean recognizeJSP = false;
    protected boolean recognizeEmbeddedTags = false;

    EmbeddedLexer() {
    }

    public void setRecognizeJSP(boolean bl) {
        this.recognizeJSP = bl;
    }

    public void setRecognizeEmbeddedTags(boolean bl) {
        this.recognizeEmbeddedTags = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void skipHTMLTag() {
        char c = '\u0000';
        boolean bl = false;
        while (true) {
            char c2;
            if ((c2 = this.textBuffer.getChar(this.currentPos++)) == '\\') {
                ++this.currentPos;
                continue;
            }
            if (c != '\u0000') {
                if (c != c2) continue;
                c = '\u0000';
                if (!bl) continue;
                --this.currentPos;
                return;
            }
            if (c2 == '\"' || c2 == '\'') {
                c = c2;
                if (!this.isEmbeddedTagStart(this.currentPos)) continue;
                this.skipEmbeddedTag();
                continue;
            }
            if (c2 == '<') {
                if (this.isEmbeddedTagStart(this.currentPos - 1)) {
                    if (this.textBuffer.getChar(this.currentPos) == '/') {
                        --this.currentPos;
                        return;
                    }
                    c2 = this.textBuffer.getChar(this.currentPos - 2);
                    if (c2 == '\"' || c2 == '\'') {
                        c = c2;
                    }
                    this.skipEmbeddedTag();
                    c2 = this.textBuffer.getChar(this.currentPos);
                    if (c == c2) return;
                    if (c == '\u0000') continue;
                    bl = true;
                    continue;
                }
                if (c != '\u0000') continue;
                --this.currentPos;
                return;
            }
            if (c2 == '>') return;
        }
    }

    private void _skipToTagEnd() {
        while (this.textBuffer.getChar(this.currentPos++) != '>') {
        }
    }

    protected boolean isEmbeddedTagStart(int n) {
        char c;
        if (this.recognizeJSP && this.recognizeEmbeddedTags) {
            char c2;
            if ((c2 = this.textBuffer.getChar(n++)) == '<') {
                if (this.textBuffer.getChar(n) == '%') {
                    return this.textBuffer.getChar(n + 1) == '=';
                }
                if (this.textBuffer.getChar(n) == '!' && this.textBuffer.getChar(n + 1) == '-' && this.textBuffer.getChar(n + 2) == '-') {
                    return false;
                }
                int n2 = 6;
                int n3 = 0;
                while (n3 <= n2) {
                    if (this.textBuffer.getChar(n + n3) == '\'' || this.textBuffer.getChar(n + n3) == '\"') {
                        return false;
                    }
                    if (this.textBuffer.getChar(n + n3) == ':') {
                        return true;
                    }
                    ++n3;
                }
                return false;
            }
            if (c2 == '$') {
                return this.textBuffer.getChar(n) == '{';
            }
        } else if (this.recognizeEmbeddedTags && (c = this.textBuffer.getChar(n++)) == '<') {
            return this.textBuffer.getChar(n) != '!' || this.textBuffer.getChar(n + 1) != '-' || this.textBuffer.getChar(n + 2) != '-';
        }
        return false;
    }

    protected void skipEmbeddedTag() {
        if (this.textBuffer.getChar(this.currentPos + 1) == '%') {
            this.skipJSPScriplet();
        } else if (this.textBuffer.getChar(this.currentPos) == '{' || this.textBuffer.getChar(this.currentPos + 1) == '{') {
            this.skipJSPEL();
        } else {
            this.skipHTMLTag();
            if (this.textBuffer.getChar(this.currentPos - 1) == '>' && this.textBuffer.getChar(this.currentPos - 2) != '/' && this.textBuffer.getChar(this.currentPos) != '\"' && this.textBuffer.getChar(this.currentPos) != '\'') {
                this._skipToTagEnd();
            }
        }
    }

    protected void skipJSPScriplet() {
        char c;
        while ((c = this.textBuffer.getChar(this.currentPos++)) != '%' || (c = this.textBuffer.getChar(this.currentPos)) != '>') {
        }
        ++this.currentPos;
    }

    protected void skipJSPEL() {
        char c;
        while ((c = this.textBuffer.getChar(this.currentPos++)) != '}') {
        }
    }
}

