/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.html;

import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.html.EmbeddedLexer;
import oracle.javatools.parser.html.HTMLTokens;

public class HTMLLexer
extends EmbeddedLexer
implements HTMLTokens {
    private int lastToken;
    private int startOffset;
    private int endOffset;
    private boolean useLastToken;
    private boolean skipComments;
    private boolean recognizeScripts;
    private boolean recognizeStyles;
    private boolean recognizePHP;
    private int caretPosition;

    void $init$() {
        this.caretPosition = -1;
    }

    public HTMLLexer() {
        this.$init$();
        this.lastToken = -1;
        this.startOffset = -1;
        this.endOffset = -1;
        this.useLastToken = false;
        this.skipComments = false;
        this.recognizeScripts = false;
        this.recognizeStyles = false;
        this.recognizePHP = false;
        this.setTextBuffer(null);
        this.setPosition(0);
    }

    public void setSkipComments(boolean bl) {
        this.skipComments = bl;
    }

    public void setRecognizeScripts(boolean bl) {
        this.recognizeScripts = bl;
    }

    public void setRecognizeStyles(boolean bl) {
        this.recognizeStyles = bl;
    }

    public void setRecognizePHP(boolean bl) {
        this.recognizePHP = bl;
    }

    public void setCaretPosition(int n) {
        this.caretPosition = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int lex(LexerToken lexerToken) {
        int n;
        block36: {
            if (this.useLastToken) {
                this.useLastToken = false;
                return this.fillLexerToken(lexerToken);
            }
            int n2 = -1;
            n = -1;
            this.lastToken = 0;
            try {
                block14: while (true) {
                    char c = this.textBuffer.getChar(this.currentPos++);
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            if (n2 == -1) {
                                n2 = this.currentPos - 1;
                            }
                            n = this.currentPos;
                            continue block14;
                        }
                    }
                    this.startOffset = this.currentPos - 1;
                    block4 : switch (c) {
                        case '<': {
                            this.lastToken = 11;
                            char c2 = this.textBuffer.getChar(this.currentPos);
                            if (c2 != '!' && c2 != '-' && c2 != '%' && c2 != '?' && c2 != '/' && !Character.isLetter(c2) && this.currentPos != this.caretPosition) {
                                if (n2 == -1) {
                                    n2 = this.currentPos - 1;
                                }
                                n = this.currentPos;
                                break;
                            }
                            if (n2 != -1) {
                                this.lastToken = 15;
                                --this.currentPos;
                                this.startOffset = n2;
                                break block14;
                            }
                            this.lastToken = 11;
                            if (this.textBuffer.getChar(this.currentPos) == '!') {
                                ++this.currentPos;
                                this.lastToken = 15;
                                if (this.textBuffer.getChar(this.currentPos) == '-' && this.textBuffer.getChar(this.currentPos + 1) == '-') {
                                    this.currentPos += 2;
                                    this.lastToken = 12;
                                    this.skipHTMLComment();
                                    if (this.skipComments) {
                                        this.lastToken = 0;
                                        break;
                                    }
                                    break block36;
                                } else if (!(this.textBuffer.getChar(this.currentPos) != 'D' && this.textBuffer.getChar(this.currentPos) != 'd' || this.textBuffer.getChar(this.currentPos + 1) != 'O' && this.textBuffer.getChar(this.currentPos + 1) != 'o' || this.textBuffer.getChar(this.currentPos + 2) != 'C' && this.textBuffer.getChar(this.currentPos + 2) != 'c' || this.textBuffer.getChar(this.currentPos + 3) != 'T' && this.textBuffer.getChar(this.currentPos + 3) != 't' || this.textBuffer.getChar(this.currentPos + 4) != 'Y' && this.textBuffer.getChar(this.currentPos + 4) != 'y' || this.textBuffer.getChar(this.currentPos + 5) != 'P' && this.textBuffer.getChar(this.currentPos + 5) != 'p' || this.textBuffer.getChar(this.currentPos + 6) != 'E' && this.textBuffer.getChar(this.currentPos + 6) != 'e')) {
                                    this.lastToken = 16;
                                    this.skipDocumentType();
                                    break block14;
                                }
                                break block36;
                            }
                            if (this.recognizeJSP && this.textBuffer.getChar(this.currentPos) == '%') {
                                ++this.currentPos;
                                this.lastToken = 22;
                                c = this.textBuffer.getChar(this.currentPos);
                                switch (c) {
                                    case '@': {
                                        this.lastToken = 21;
                                        this.skipJSPDirective();
                                        break;
                                    }
                                    case '!': {
                                        this.lastToken = 23;
                                        this.skipJSPScriplet();
                                        break;
                                    }
                                    case '=': {
                                        this.lastToken = 24;
                                        this.skipJSPScriplet();
                                        break;
                                    }
                                    case '-': {
                                        if (this.textBuffer.getChar(this.currentPos + 1) == '-') {
                                            this.currentPos += 2;
                                            this.lastToken = 25;
                                            this.skipJSPComment();
                                            if (!this.skipComments) break;
                                            this.lastToken = 0;
                                            break block4;
                                        }
                                    }
                                    default: {
                                        this.skipJSPScriplet();
                                        break;
                                    }
                                }
                                break block36;
                            } else {
                                if (this.recognizePHP && this.textBuffer.getChar(this.currentPos) == '?') {
                                    ++this.currentPos;
                                    this.lastToken = 31;
                                    this.skipPHPTag();
                                    break block14;
                                }
                                if (this.recognizePHP && this.textBuffer.getChar(this.currentPos) == '%') {
                                    ++this.currentPos;
                                    this.lastToken = 32;
                                    this.skipPHPASPTag();
                                    break block14;
                                }
                                this.skipHTMLTag();
                                if (this.recognizeScripts && this.isScriptStart(this.startOffset, this.currentPos)) {
                                    this.lastToken = 13;
                                    this.skipScriptChunk();
                                }
                                if (this.recognizeStyles && this.isStyleStart(this.startOffset, this.currentPos)) {
                                    this.lastToken = 14;
                                    this.skipStyleChunk();
                                    break block14;
                                }
                            }
                            break block36;
                        }
                        default: {
                            if (n2 == -1) {
                                n2 = this.currentPos - 1;
                            }
                            n = this.currentPos;
                            break;
                        }
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.currentPos = this.textBuffer.getLength();
                if (this.lastToken == 0) {
                    if (n2 != -1) {
                        this.lastToken = 15;
                        this.startOffset = n2;
                    } else {
                        this.startOffset = this.currentPos;
                    }
                }
                if (!this.skipComments || this.lastToken != 12 && this.lastToken != 25) break block36;
                this.lastToken = 0;
                this.startOffset = this.currentPos;
            }
        }
        this.endOffset = n == -1 ? this.currentPos : n;
        this.useLastToken = false;
        return this.fillLexerToken(lexerToken);
    }

    public void backup() {
        this.useLastToken = true;
    }

    public void setPosition(int n) {
        super.setPosition(n);
        this.useLastToken = false;
    }

    private void skipToEndTag() {
        char c;
        while ((c = this.textBuffer.getChar(this.currentPos++)) != '<' || this.textBuffer.getChar(this.currentPos) != '/' || ('a' > (c = this.textBuffer.getChar(this.currentPos + 1)) || c > 'z') && ('A' > c || c > 'Z')) {
        }
        this.skipHTMLTag();
    }

    private void skipScriptChunk() {
        this.skipToEndTag();
    }

    private boolean isScriptStart(int n, int n2) {
        char c;
        if (n2 - n < 8) {
            return false;
        }
        int n3 = n;
        if ((c = this.textBuffer.getChar(n3++)) != '<') {
            return false;
        }
        if ((c = this.textBuffer.getChar(n3++)) != 's' && c != 'S') {
            return false;
        }
        if ((c = this.textBuffer.getChar(n3++)) != 'c' && c != 'C') {
            return false;
        }
        if ((c = this.textBuffer.getChar(n3++)) != 'r' && c != 'R') {
            return false;
        }
        if ((c = this.textBuffer.getChar(n3++)) != 'i' && c != 'I') {
            return false;
        }
        if ((c = this.textBuffer.getChar(n3++)) != 'p' && c != 'P') {
            return false;
        }
        if ((c = this.textBuffer.getChar(n3++)) != 't' && c != 'T') {
            return false;
        }
        return (c = this.textBuffer.getChar(n3++)) == '>' || Character.isWhitespace(c);
    }

    private boolean isScriptEnd(int n, int n2) {
        char c;
        if (n2 - n < 9) {
            return false;
        }
        int n3 = n;
        if ((c = this.textBuffer.getChar(n3++)) != '<') {
            return false;
        }
        if ((c = this.textBuffer.getChar(n3++)) != '/') {
            return false;
        }
        if ((c = this.textBuffer.getChar(n3++)) != 's' && c != 'S') {
            return false;
        }
        if ((c = this.textBuffer.getChar(n3++)) != 'c' && c != 'C') {
            return false;
        }
        if ((c = this.textBuffer.getChar(n3++)) != 'r' && c != 'R') {
            return false;
        }
        if ((c = this.textBuffer.getChar(n3++)) != 'i' && c != 'I') {
            return false;
        }
        if ((c = this.textBuffer.getChar(n3++)) != 'p' && c != 'P') {
            return false;
        }
        if ((c = this.textBuffer.getChar(n3++)) != 't' && c != 'T') {
            return false;
        }
        return (c = this.textBuffer.getChar(n3++)) == '>';
    }

    private void skipStyleChunk() {
        this.skipToEndTag();
    }

    private boolean isStyleStart(int n, int n2) {
        char c;
        if (n2 - n < 7) {
            return false;
        }
        int n3 = n;
        if ((c = this.textBuffer.getChar(n3++)) != '<') {
            return false;
        }
        if ((c = this.textBuffer.getChar(n3++)) != 's' && c != 'S') {
            return false;
        }
        if ((c = this.textBuffer.getChar(n3++)) != 't' && c != 'T') {
            return false;
        }
        if ((c = this.textBuffer.getChar(n3++)) != 'y' && c != 'Y') {
            return false;
        }
        if ((c = this.textBuffer.getChar(n3++)) != 'l' && c != 'L') {
            return false;
        }
        if ((c = this.textBuffer.getChar(n3++)) != 'e' && c != 'E') {
            return false;
        }
        return (c = this.textBuffer.getChar(n3++)) == '>' || Character.isWhitespace(c);
    }

    private boolean isStyleEnd(int n, int n2) {
        char c;
        if (n2 - n < 8) {
            return false;
        }
        int n3 = n;
        if ((c = this.textBuffer.getChar(n3++)) != '<') {
            return false;
        }
        if ((c = this.textBuffer.getChar(n3++)) != '/') {
            return false;
        }
        if ((c = this.textBuffer.getChar(n3++)) != 's' && c != 'S') {
            return false;
        }
        if ((c = this.textBuffer.getChar(n3++)) != 't' && c != 'T') {
            return false;
        }
        if ((c = this.textBuffer.getChar(n3++)) != 'y' && c != 'Y') {
            return false;
        }
        if ((c = this.textBuffer.getChar(n3++)) != 'l' && c != 'L') {
            return false;
        }
        if ((c = this.textBuffer.getChar(n3++)) != 'e' && c != 'E') {
            return false;
        }
        return (c = this.textBuffer.getChar(n3++)) == '>';
    }

    private void skipHTMLComment() {
        char c;
        while ((c = this.textBuffer.getChar(this.currentPos++)) != '-' || this.textBuffer.getChar(this.currentPos) != '-' || this.textBuffer.getChar(this.currentPos + 1) != '>') {
        }
        this.currentPos += 2;
    }

    private void skipDocumentType() {
        this.currentPos += 7;
        char c = '\u0000';
        boolean bl = false;
        block7: while (true) {
            char c2 = this.textBuffer.getChar(this.currentPos++);
            switch (c2) {
                case '\"': 
                case '\'': {
                    if (c != '\u0000') {
                        if (c != c2) continue block7;
                        c = '\u0000';
                        break;
                    }
                    c = c2;
                    break;
                }
                case '[': {
                    if (c != '\u0000') continue block7;
                    bl = true;
                    break;
                }
                case ']': {
                    if (c != '\u0000') continue block7;
                    bl = false;
                    break;
                }
                case '>': {
                    if (c != '\u0000' || bl) continue block7;
                    return;
                }
                case '<': {
                    if (bl) continue block7;
                    --this.currentPos;
                    return;
                }
            }
        }
    }

    private void skipJSPComment() {
        char c;
        while ((c = this.textBuffer.getChar(this.currentPos++)) != '-' || this.textBuffer.getChar(this.currentPos) != '-' || this.textBuffer.getChar(this.currentPos + 1) != '%' || this.textBuffer.getChar(this.currentPos + 2) != '>') {
        }
        this.currentPos += 3;
    }

    private void skipJSPDirective() {
        char c = '\u0000';
        while (true) {
            char c2;
            if ((c2 = this.textBuffer.getChar(this.currentPos++)) == '\\') {
                ++this.currentPos;
                continue;
            }
            if (c != '\u0000') {
                if (c != c2) continue;
                c = '\u0000';
                continue;
            }
            if (c2 == '\"' || c2 == '\'') {
                c = c2;
                continue;
            }
            if (c2 == '%' && (c2 = this.textBuffer.getChar(this.currentPos)) == '>') break;
        }
        ++this.currentPos;
    }

    protected void skipPHPTag() {
        char c;
        while ((c = this.textBuffer.getChar(this.currentPos++)) != '?' || (c = this.textBuffer.getChar(this.currentPos)) != '>') {
        }
        ++this.currentPos;
    }

    protected void skipPHPASPTag() {
        this.skipJSPScriplet();
    }

    private int fillLexerToken(LexerToken lexerToken) {
        AbstractLexer.DefaultLexerToken defaultLexerToken = (AbstractLexer.DefaultLexerToken)lexerToken;
        defaultLexerToken.setToken(this.lastToken);
        defaultLexerToken.setStartOffset(this.startOffset);
        defaultLexerToken.setEndOffset(this.endOffset);
        return this.lastToken;
    }

    public static String tokenToString(int n) {
        switch (n) {
            case 11: {
                return "TK_HTML_TAG";
            }
            case 12: {
                return "TK_HTML_COMMENT";
            }
            case 15: {
                return "TK_HTML_TEXT";
            }
            case 16: {
                return "TK_HTML_DOCUMENT_TYPE";
            }
            case 13: {
                return "TK_HTML_SCRIPT";
            }
            case 14: {
                return "TK_HTML_STYLE";
            }
            case 21: {
                return "TK_JSP_DIRECTIVE";
            }
            case 22: {
                return "TK_JSP_SCRIPLET";
            }
            case 23: {
                return "TK_JSP_DECLARATION";
            }
            case 24: {
                return "TK_JSP_EXPRESSION";
            }
            case 25: {
                return "TK_JSP_COMMENT";
            }
            case 31: {
                return "TK_PHP_TAG";
            }
            case 32: {
                return "TK_PHP_ASPTAG";
            }
        }
        return "**UNKNOWN**";
    }

    public static String tokenToText(int n) {
        switch (n) {
            case 11: {
                return "HTML Tag";
            }
            case 12: {
                return "HTML Comment";
            }
            case 15: {
                return "HTML Text";
            }
            case 16: {
                return "HTML Document Type";
            }
            case 13: {
                return "HTML Script";
            }
            case 14: {
                return "HTML Style";
            }
            case 21: {
                return "JSP Directive";
            }
            case 22: {
                return "JSP Scriplet";
            }
            case 23: {
                return "JSP Declaration";
            }
            case 24: {
                return "JSP Expression";
            }
            case 25: {
                return "JSP Comment";
            }
            case 31: {
                return "PHP Tag";
            }
            case 32: {
                return "PHP ASP Tag";
            }
        }
        return "**UNKNOWN**";
    }
}

