/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.html;

import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.html.EmbeddedLexer;
import oracle.javatools.parser.html.TagTokens;

public class TagLexer
extends EmbeddedLexer
implements TagTokens {
    private int lastToken = -1;
    private int startOffset = -1;
    private int endOffset = -1;
    private boolean useLastToken = false;
    private boolean skipSymbols = false;
    private boolean recognizeSlash = false;
    private int nextNameType;

    public TagLexer() {
        this.setTextBuffer(null);
        this.setPosition(0);
    }

    public void setSkipSymbols(boolean bl) {
        this.skipSymbols = bl;
    }

    public void setRecognizeSlash(boolean bl) {
        this.recognizeSlash = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int lex(LexerToken lexerToken) {
        block18: {
            if (this.useLastToken) {
                this.useLastToken = false;
                return this.fillLexerToken(lexerToken);
            }
            this.lastToken = 0;
            try {
                block12: while (true) {
                    char c = this.textBuffer.getChar(this.currentPos++);
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            continue block12;
                        }
                    }
                    this.startOffset = this.currentPos - 1;
                    switch (c) {
                        case '=': {
                            this.nextNameType = 22;
                        }
                        case '$': 
                        case '<': {
                            if ((this.nextNameType == 21 || this.nextNameType == 22) && this.isEmbeddedTagStart(this.startOffset)) {
                                this.lastToken = this.nextNameType;
                                this.nextNameType = 21;
                                --this.currentPos;
                                this.skipNameOrValue();
                                break block12;
                            }
                        }
                        case '>': {
                            this.lastToken = 31;
                            if (this.recognizeJSP && c == '<' && this.textBuffer.getChar(this.currentPos) == '%' && this.textBuffer.getChar(this.currentPos + 1) == '@') {
                                this.currentPos += 2;
                            }
                            if (!this.skipSymbols) break block12;
                            this.lastToken = 0;
                            continue block12;
                        }
                        case '/': {
                            if (this.recognizeSlash) {
                                this.lastToken = 31;
                                if (!this.skipSymbols) break block12;
                                this.lastToken = 0;
                                continue block12;
                            }
                        }
                        case '%': {
                            this.lastToken = 31;
                            if (this.recognizeJSP && this.textBuffer.getChar(this.currentPos) == '>') {
                                ++this.currentPos;
                                if (!this.skipSymbols) break block12;
                                this.lastToken = 0;
                                continue block12;
                            }
                        }
                        default: {
                            this.lastToken = this.nextNameType;
                            this.nextNameType = 21;
                            --this.currentPos;
                            this.skipNameOrValue();
                            break block12;
                        }
                    }
                    break;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.currentPos = this.textBuffer.getLength();
                if (this.lastToken != 0) break block18;
                this.startOffset = this.currentPos;
            }
        }
        this.endOffset = this.currentPos;
        this.useLastToken = false;
        return this.fillLexerToken(lexerToken);
    }

    public void backup() {
        this.useLastToken = true;
    }

    public void setPosition(int n) {
        super.setPosition(n);
        this.useLastToken = false;
        this.nextNameType = 11;
    }

    public int skipNameOrValue(boolean bl) {
        char c = '\u0000';
        char c2 = '\u0000';
        int n = 0;
        boolean bl2 = false;
        block11: while (true) {
            char c3 = c;
            c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case '[': {
                    if (!bl) continue block11;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (bl2) continue block11;
                }
                case '=': 
                case '>': {
                    if (c2 != '\u0000') continue block11;
                    --this.currentPos;
                    if (this.recognizeSlash && this.textBuffer.getChar(this.currentPos - 1) == '/') {
                        --this.currentPos;
                    }
                    return this.currentPos;
                }
                case '{': {
                    if (this.recognizeJSP) {
                        if (c3 != '$') continue block11;
                        this.lastToken = 22;
                        bl2 = true;
                        break;
                    }
                }
                case '}': {
                    if (this.recognizeJSP) {
                        if (!bl2) continue block11;
                        bl2 = false;
                        break;
                    }
                }
                case '$': 
                case '<': {
                    if (this.lastToken != 21 && this.lastToken != 22 || !this.isEmbeddedTagStart(this.currentPos - 1)) continue block11;
                    if (this.lastToken == 21) {
                        this.lastToken = 23;
                    } else if (this.lastToken == 22) {
                        this.lastToken = 24;
                    }
                    this.skipEmbeddedTag();
                    break;
                }
                case '\\': {
                    ++this.currentPos;
                    break;
                }
                case '\"': 
                case '\'': {
                    if (c2 != '\u0000') {
                        if (c2 != c) continue block11;
                        c2 = '\u0000';
                        break;
                    }
                    c2 = c;
                    if (this.lastToken != 22 || !this.isEmbeddedTagStart(this.currentPos)) continue block11;
                    this.lastToken = 24;
                    this.skipEmbeddedTag();
                    break;
                }
                case '%': {
                    if (this.recognizeJSP && c2 == '\u0000' && this.textBuffer.getChar(this.currentPos) == '>') {
                        --this.currentPos;
                        return this.currentPos;
                    }
                }
                default: {
                    if (n == 0 && c == '&') {
                        ++n;
                        break;
                    }
                    if (n == 1 && c3 == '&' && c == 'g') {
                        ++n;
                        break;
                    }
                    if (n == 2 && c3 == 'g' && c == 't') {
                        ++n;
                        break;
                    }
                    if (n == 3 && c3 == 't' && c == ';') {
                        n = 0;
                        if (c2 != '\u0000') continue block11;
                        --this.currentPos;
                        return this.currentPos;
                    }
                    n = 0;
                }
            }
        }
    }

    private void skipNameOrValue() {
        this.skipNameOrValue(false);
    }

    private int fillLexerToken(LexerToken lexerToken) {
        AbstractLexer.DefaultLexerToken defaultLexerToken = (AbstractLexer.DefaultLexerToken)lexerToken;
        defaultLexerToken.setToken(this.lastToken);
        defaultLexerToken.setStartOffset(this.startOffset);
        defaultLexerToken.setEndOffset(this.endOffset);
        return this.lastToken;
    }

    public static String tokenToString(int n) {
        switch (n) {
            case 11: {
                return "TK_ELEMENT_NAME";
            }
            case 21: {
                return "TK_ATTRIBUTE_NAME";
            }
            case 22: {
                return "TK_ATTRIBUTE_VALUE";
            }
            case 31: {
                return "TK_SYMBOL";
            }
            case 23: {
                return "TK_ATTRIBUTE_NAME_EMBEDDED";
            }
            case 24: {
                return "TK_ATTRIBUTE_VALUE_EMBEDDED";
            }
        }
        return "**UNKNOWN**";
    }

    public static String tokenToText(int n) {
        switch (n) {
            case 11: {
                return "Element name";
            }
            case 21: {
                return "Attribute name";
            }
            case 22: {
                return "Attribute value";
            }
            case 31: {
                return "Tag symbol";
            }
            case 23: {
                return "Embedded Tag in Attribute Name";
            }
            case 24: {
                return "Embedded Tag in Attribute Value";
            }
        }
        return "**UNKNOWN**";
    }
}

